/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.maven.ModelConverter;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.Parser;
import org.cyclonedx.parsers.XmlParser;

public abstract class BaseCycloneDxMojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="projectType", defaultValue="library", required=false)
    private String projectType;
    @Parameter(property="schemaVersion", defaultValue="1.4", required=false)
    private String schemaVersion;
    @Parameter(property="outputFormat", defaultValue="all", required=false)
    private String outputFormat;
    @Parameter(property="outputName", defaultValue="bom", required=false)
    private String outputName;
    @Parameter(defaultValue="${project.build.directory}", required=false)
    private File outputDirectory;
    @Parameter(property="includeBomSerialNumber", defaultValue="true", required=false)
    private Boolean includeBomSerialNumber;
    @Parameter(property="includeCompileScope", defaultValue="true", required=false)
    private Boolean includeCompileScope;
    @Parameter(property="includeProvidedScope", defaultValue="true", required=false)
    private Boolean includeProvidedScope;
    @Parameter(property="includeRuntimeScope", defaultValue="true", required=false)
    private Boolean includeRuntimeScope;
    @Parameter(property="includeTestScope", defaultValue="false", required=false)
    private Boolean includeTestScope;
    @Parameter(property="includeSystemScope", defaultValue="true", required=false)
    private Boolean includeSystemScope;
    @Parameter(property="includeLicenseText", defaultValue="false", required=false)
    private Boolean includeLicenseText;
    @Parameter(property="excludeTypes", required=false)
    private String[] excludeTypes;
    @Parameter(property="cyclonedx.skip", defaultValue="false", required=false)
    private boolean skip = false;
    @Parameter(property="cyclonedx.skipAttach", defaultValue="false", required=false)
    private boolean skipAttach = false;
    @Parameter(property="cyclonedx.verbose", defaultValue="true", required=false)
    private boolean verbose = true;
    @org.apache.maven.plugins.annotations.Component
    private MavenProjectHelper mavenProjectHelper;
    @org.apache.maven.plugins.annotations.Component
    private DependencyCollectorBuilder dependencyCollectorBuilder;
    @org.apache.maven.plugins.annotations.Component
    private ModelConverter modelConverter;
    private Set<String> excludeTypesSet;
    protected static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    protected static final String MESSAGE_RESOLVING_AGGREGATED_DEPS = "CycloneDX: Resolving Aggregated Dependencies";
    protected static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    protected static final String MESSAGE_WRITING_BOM = "CycloneDX: Writing BOM (%s): %s";
    protected static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM (%s): %s";
    protected static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard as defined by the XSD";

    protected MavenProject getProject() {
        return this.project;
    }

    protected String generatePackageUrl(Artifact artifact) {
        return this.modelConverter.generatePackageUrl(artifact);
    }

    protected String generateVersionlessPackageUrl(Artifact artifact) {
        return this.modelConverter.generateVersionlessPackageUrl(artifact);
    }

    protected Component convert(Artifact artifact) {
        return this.modelConverter.convert(artifact, this.schemaVersion(), this.includeLicenseText);
    }

    protected abstract String analyze(Set<Component> var1, Set<Dependency> var2) throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("cyclonedx.skip", Boolean.toString(this.skip)));
        if (shouldSkip) {
            this.getLog().info((CharSequence)"Skipping CycloneDX");
            return;
        }
        this.logParameters();
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        String analysis = this.analyze(components, dependencies);
        if (analysis != null) {
            this.generateBom(analysis, components, dependencies);
        }
    }

    private void generateBom(String analysis, Set<Component> components, Set<Dependency> dependencies) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)MESSAGE_CREATING_BOM);
            Bom bom = new Bom();
            if (this.schemaVersion().getVersion() >= 1.1 && this.includeBomSerialNumber.booleanValue()) {
                bom.setSerialNumber("urn:uuid:" + UUID.randomUUID());
            }
            if (this.schemaVersion().getVersion() >= 1.2) {
                Metadata metadata = this.modelConverter.convert(this.project, analysis, this.projectType, this.schemaVersion(), this.includeLicenseText);
                bom.setMetadata(metadata);
            }
            bom.setComponents(new ArrayList<Component>(components));
            if (this.schemaVersion().getVersion() >= 1.2 && dependencies != null && !dependencies.isEmpty()) {
                bom.setDependencies(new ArrayList<Dependency>(dependencies));
                this.validateBomDependencies(bom);
            }
            if (this.schemaVersion().getVersion() >= 1.3) {
                // empty if block
            }
            if (!(this.outputFormat.trim().equalsIgnoreCase("all") || this.outputFormat.trim().equalsIgnoreCase("xml") || this.outputFormat.trim().equalsIgnoreCase("json"))) {
                this.getLog().error((CharSequence)"Unsupported output format. Valid options are XML and JSON");
                return;
            }
            this.saveBom(bom);
        }
        catch (IOException | ParserConfigurationException | GeneratorException e) {
            throw new MojoExecutionException("An error occurred executing " + ((Object)((Object)this)).getClass().getName() + ": " + e.getMessage(), (Exception)e);
        }
    }

    private void saveBom(Bom bom) throws ParserConfigurationException, IOException, GeneratorException, MojoExecutionException {
        String bomString;
        BomXmlGenerator bomGenerator;
        if (this.outputFormat.trim().equalsIgnoreCase("all") || this.outputFormat.trim().equalsIgnoreCase("xml")) {
            bomGenerator = BomGeneratorFactory.createXml((CycloneDxSchema.Version)this.schemaVersion(), (Bom)bom);
            bomGenerator.generate();
            bomString = bomGenerator.toXmlString();
            this.saveBomToFile(bomString, "xml", (Parser)new XmlParser());
        }
        if (this.outputFormat.trim().equalsIgnoreCase("all") || this.outputFormat.trim().equalsIgnoreCase("json")) {
            bomGenerator = BomGeneratorFactory.createJson((CycloneDxSchema.Version)this.schemaVersion(), (Bom)bom);
            bomString = bomGenerator.toJsonString();
            this.saveBomToFile(bomString, "json", (Parser)new JsonParser());
        }
    }

    private void saveBomToFile(String bomString, String extension, Parser bomParser) throws IOException, MojoExecutionException {
        File bomFile = new File(this.outputDirectory, this.outputName + "." + extension);
        this.getLog().info((CharSequence)String.format(MESSAGE_WRITING_BOM, extension.toUpperCase(), bomFile.getAbsolutePath()));
        FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        this.getLog().info((CharSequence)String.format(MESSAGE_VALIDATING_BOM, extension.toUpperCase(), bomFile.getAbsolutePath()));
        if (!bomParser.isValid(bomFile, this.schemaVersion())) {
            throw new MojoExecutionException(MESSAGE_VALIDATION_FAILURE);
        }
        if (!this.skipAttach) {
            this.mavenProjectHelper.attachArtifact(this.project, extension, "cyclonedx", bomFile);
        }
    }

    private void validateBomDependencies(Bom bom) {
        HashMap<String, Component> components = new HashMap<String, Component>();
        components.put(bom.getMetadata().getComponent().getBomRef(), bom.getMetadata().getComponent());
        for (Component component : bom.getComponents()) {
            components.put(component.getBomRef(), component);
        }
        HashSet<String> dependencyRefs = new HashSet<String>();
        for (Dependency dependency : bom.getDependencies()) {
            dependencyRefs.add(dependency.getRef());
            List childDependencies = dependency.getDependencies();
            if (childDependencies == null) continue;
            childDependencies.forEach(d -> dependencyRefs.add(d.getRef()));
        }
        for (Map.Entry entry : components.entrySet()) {
            Component component;
            String componentRef = (String)entry.getKey();
            if (dependencyRefs.contains(componentRef)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("CycloneDX: Component not used in dependency graph, pruning component from bom: " + componentRef));
            }
            if ((component = (Component)entry.getValue()) == null) continue;
            bom.getComponents().remove(component);
        }
        for (String string : dependencyRefs) {
            if (components.containsKey(string)) continue;
            this.getLog().warn((CharSequence)("CycloneDX: Dependency missing component entry: " + string));
        }
    }

    protected CycloneDxSchema.Version schemaVersion() {
        if ("1.0".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_10;
        }
        if ("1.1".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_11;
        }
        if ("1.2".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_12;
        }
        if ("1.3".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_13;
        }
        return CycloneDxSchema.Version.VERSION_14;
    }

    private Set<String> getExcludeTypesSet() {
        if (this.excludeTypesSet == null) {
            this.excludeTypesSet = new HashSet<String>(Arrays.asList(this.excludeTypes));
        }
        return this.excludeTypesSet;
    }

    protected Set<Dependency> buildDependencyGraph(MavenProject mavenProject) throws MojoExecutionException {
        LinkedHashMap<Dependency, Dependency> dependencies = new LinkedHashMap<Dependency, Dependency>();
        HashSet<String> scope = new HashSet<String>();
        if (this.includeCompileScope.booleanValue()) {
            scope.add("compile");
        }
        if (this.includeProvidedScope.booleanValue()) {
            scope.add("provided");
        }
        if (this.includeRuntimeScope.booleanValue()) {
            scope.add("runtime");
        }
        if (this.includeSystemScope.booleanValue()) {
            scope.add("system");
        }
        if (this.includeTestScope.booleanValue()) {
            scope.add("test");
        }
        CumulativeScopeArtifactFilter artifactFilter = new CumulativeScopeArtifactFilter(scope);
        if (mavenProject == null) {
            mavenProject = this.project;
        }
        ProjectBuildingRequest buildingRequest = this.getProjectBuildingRequest(mavenProject);
        Map<String, String> resolvedPUrls = this.generateResolvedPUrls(mavenProject);
        try {
            DependencyNode rootNode = this.dependencyCollectorBuilder.collectDependencyGraph(buildingRequest, (ArtifactFilter)artifactFilter);
            HashMap<String, DependencyNode> excludedNodes = new HashMap<String, DependencyNode>();
            HashSet<String> loggedReplacementPUrls = new HashSet<String>();
            this.buildDependencyGraphNode(dependencies, rootNode, null, excludedNodes, resolvedPUrls, loggedReplacementPUrls);
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor(){

                public boolean visit(DependencyNode node) {
                    if (BaseCycloneDxMojo.this.isExcludedNode(node)) {
                        return false;
                    }
                    return super.visit(node);
                }
            };
            rootNode.accept((DependencyNodeVisitor)visitor);
            for (DependencyNode dependencyNode : visitor.getNodes()) {
                this.buildDependencyGraphNode(dependencies, dependencyNode, null, excludedNodes, resolvedPUrls, loggedReplacementPUrls);
            }
            if (this.includeCompileScope.booleanValue() && !this.includeTestScope.booleanValue() || !excludedNodes.isEmpty()) {
                ProjectBuildingRequest testBuildingRequest = this.getProjectBuildingRequest(mavenProject);
                HashMap<String, DependencyNode> hiddenNodes = new HashMap<String, DependencyNode>();
                HashMap<String, DependencyNode> hiddenEmptyNodes = new HashMap<String, DependencyNode>();
                if (this.includeCompileScope.booleanValue() && !this.includeTestScope.booleanValue()) {
                    DependencyNode testRootNode = this.dependencyCollectorBuilder.collectDependencyGraph(testBuildingRequest, null);
                    for (DependencyNode child : testRootNode.getChildren()) {
                        if (!"test".equals(child.getArtifact().getScope())) continue;
                        this.collectNodes(hiddenNodes, hiddenEmptyNodes, child);
                    }
                    if (!this.includeRuntimeScope.booleanValue()) {
                        this.collectRuntimeNodes(hiddenNodes, hiddenEmptyNodes, testRootNode);
                    }
                }
                if (!excludedNodes.isEmpty()) {
                    for (DependencyNode excluded : excludedNodes.values()) {
                        this.collectNodes(hiddenNodes, hiddenEmptyNodes, excluded);
                    }
                }
                HashSet<String> loggedPurls = new HashSet<String>();
                ArrayDeque toProcess = new ArrayDeque(dependencies.values());
                while (!toProcess.isEmpty()) {
                    Dependency dependency = (Dependency)toProcess.remove();
                    if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) continue;
                    String purl = dependency.getRef();
                    DependencyNode hiddenNode = (DependencyNode)hiddenNodes.get(purl);
                    if (hiddenNode == null) {
                        hiddenNode = (DependencyNode)hiddenEmptyNodes.get(purl);
                    }
                    if (hiddenNode == null) continue;
                    if (!loggedPurls.contains(purl)) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("CycloneDX: Populating hidden node: " + purl));
                        }
                        loggedPurls.add(purl);
                    }
                    for (DependencyNode child : hiddenNode.getChildren()) {
                        this.buildDependencyGraphNode(dependencies, child, dependency, excludedNodes, resolvedPUrls, loggedReplacementPUrls);
                        this.buildDependencyGraphNode(dependencies, child, null, excludedNodes, resolvedPUrls, loggedReplacementPUrls);
                    }
                    Dependency topLevelDependency = (Dependency)dependencies.get(dependency);
                    if (topLevelDependency.getDependencies() == null) continue;
                    toProcess.addAll(topLevelDependency.getDependencies());
                }
            }
        }
        catch (DependencyCollectorBuilderException e) {
            if (mavenProject != null) {
                this.getLog().warn((CharSequence)("An error occurred building dependency graph: " + e.getMessage()));
            }
            throw new MojoExecutionException("An error occurred building dependency graph", (Exception)((Object)e));
        }
        return dependencies.keySet();
    }

    private Map<String, String> generateResolvedPUrls(MavenProject mavenProject) {
        HashMap<String, String> resolvedPUrls = new HashMap<String, String>();
        Artifact projectArtifact = mavenProject.getArtifact();
        resolvedPUrls.put(this.generateVersionlessPackageUrl(projectArtifact), this.generatePackageUrl(projectArtifact));
        for (Artifact artifact : mavenProject.getArtifacts()) {
            resolvedPUrls.put(this.generateVersionlessPackageUrl(artifact), this.generatePackageUrl(artifact));
        }
        return resolvedPUrls;
    }

    private void collectRuntimeNodes(Map<String, DependencyNode> hiddenNodes, Map<String, DependencyNode> hiddenEmptyNodes, DependencyNode node) {
        block4: {
            if (node.getChildren().isEmpty()) break block4;
            if ("runtime".equals(node.getArtifact().getScope())) {
                String purl = this.generatePackageUrl(node.getArtifact());
                hiddenNodes.put(purl, node);
                for (DependencyNode child : node.getChildren()) {
                    this.collectNodes(hiddenNodes, hiddenEmptyNodes, child);
                }
            } else {
                for (DependencyNode child : node.getChildren()) {
                    this.collectRuntimeNodes(hiddenNodes, hiddenEmptyNodes, child);
                }
            }
        }
    }

    private void collectNodes(Map<String, DependencyNode> hiddenNodes, Map<String, DependencyNode> hiddenEmptyNodes, DependencyNode node) {
        String purl = this.generatePackageUrl(node.getArtifact());
        if (!node.getChildren().isEmpty()) {
            hiddenNodes.put(purl, node);
            for (DependencyNode child : node.getChildren()) {
                this.collectNodes(hiddenNodes, hiddenEmptyNodes, child);
            }
        } else {
            hiddenEmptyNodes.put(purl, node);
        }
    }

    private boolean isExcludedNode(DependencyNode node) {
        String type = node.getArtifact().getType();
        return type == null || this.getExcludeTypesSet().contains(type);
    }

    private void buildDependencyGraphNode(Map<Dependency, Dependency> dependencies, DependencyNode artifactNode, Dependency parent, Map<String, DependencyNode> excludedNodes, Map<String, String> resolvedPurls, Set<String> loggedReplacementPUrls) {
        String versionlessPurl;
        String resolvedPurl;
        String purl = this.generatePackageUrl(artifactNode.getArtifact());
        if (this.isExcludedNode(artifactNode)) {
            excludedNodes.put(purl, artifactNode);
            return;
        }
        if (!this.includeTestScope.booleanValue() && !this.includeRuntimeScope.booleanValue() && "runtime".equals(artifactNode.getArtifact().getScope())) {
            return;
        }
        if (artifactNode.getChildren().isEmpty() && !purl.equals(resolvedPurl = resolvedPurls.get(versionlessPurl = this.generateVersionlessPackageUrl(artifactNode.getArtifact())))) {
            if (!loggedReplacementPUrls.contains(purl)) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("CycloneDX: replacing reference to " + purl + " with resolved package url " + resolvedPurl));
                }
                loggedReplacementPUrls.add(purl);
            }
            purl = resolvedPurl;
        }
        Dependency dependency = new Dependency(purl);
        this.addDependencyToGraph(dependencies, parent, dependency);
        for (DependencyNode childrenNode : artifactNode.getChildren()) {
            this.buildDependencyGraphNode(dependencies, childrenNode, dependency, excludedNodes, resolvedPurls, loggedReplacementPUrls);
        }
    }

    private void addDependencyToGraph(Map<Dependency, Dependency> dependencies, Dependency parent, Dependency dependency) {
        Dependency topLevelParent;
        if (parent == null) {
            dependencies.putIfAbsent(dependency, dependency);
        } else if (!parent.getRef().equals(dependency.getRef()) && (topLevelParent = dependencies.get(parent)) != null) {
            topLevelParent.addDependency(dependency);
        }
    }

    protected void logAdditionalParameters() {
    }

    protected void logParameters() {
        if (this.verbose && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"CycloneDX: Parameters");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)("schemaVersion          : " + this.schemaVersion().getVersionString()));
            this.getLog().info((CharSequence)("includeBomSerialNumber : " + this.includeBomSerialNumber));
            this.getLog().info((CharSequence)("includeCompileScope    : " + this.includeCompileScope));
            this.getLog().info((CharSequence)("includeProvidedScope   : " + this.includeProvidedScope));
            this.getLog().info((CharSequence)("includeRuntimeScope    : " + this.includeRuntimeScope));
            this.getLog().info((CharSequence)("includeTestScope       : " + this.includeTestScope));
            this.getLog().info((CharSequence)("includeSystemScope     : " + this.includeSystemScope));
            this.getLog().info((CharSequence)("includeLicenseText     : " + this.includeLicenseText));
            this.getLog().info((CharSequence)("outputFormat           : " + this.outputFormat));
            this.getLog().info((CharSequence)("outputName             : " + this.outputName));
            this.logAdditionalParameters();
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    private ProjectBuildingRequest getProjectBuildingRequest(MavenProject mavenProject) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProject(mavenProject);
        return buildingRequest;
    }
}

