/*
 * (c) Copyright 2012 by Volker Bergmann. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted under the terms of the
 * GNU General Public License (GPL).
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * WITHOUT A WARRANTY OF ANY KIND. ALL EXPRESS OR IMPLIED CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
 * HEREBY EXCLUDED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package org.databene.benerator.anno;

import java.io.File;

/**
 * Abstract implementation of the {@link PathResolver} interface.<br/><br/>
 * Created: 04.05.2012 08:56:44
 * @since 0.7.7
 * @author Volker Bergmann
 */
public abstract class AbstractPathResolver implements PathResolver {
	
	protected String basePath;

	protected AbstractPathResolver() {
		this(".");
	}
	
	protected AbstractPathResolver(String basePath) {
		setBasePath(basePath);
	}
	
	public String getBasePath() {
		return basePath;
	}
	
	// partial PathResolver interface implementation -------------------------------------------------------------------

	public void setBasePath(String basePath) {
		this.basePath = normalizePath(basePath);
	}
	
	protected String normalizePath(String path) {
		return path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
	}

}
