/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.io.IOException;
import java.util.Map;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;

public class JDBCConnectData {
    public final String driver;
    public final String url;
    public final String user;
    public final String password;
    public final String catalog;
    public final String schema;
    public final boolean readOnly;

    public JDBCConnectData(String driver, String url, String user, String password) {
        this(driver, url, user, password, null, null, false);
    }

    public JDBCConnectData(String driver, String url, String user, String password, String catalog, String schema, boolean readOnly) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.schema = schema;
        this.catalog = catalog;
        this.readOnly = readOnly;
    }

    public static JDBCConnectData parseSingleDbProperties(String filename) throws IOException {
        Map properties = IOUtil.readProperties((String)filename);
        String readOnlyConfig = (String)properties.get("db_readonly");
        boolean readOnly = !StringUtil.isEmpty((CharSequence)readOnlyConfig) ? Boolean.parseBoolean(readOnlyConfig) : false;
        return new JDBCConnectData((String)properties.get("db_driver"), (String)properties.get("db_url"), (String)properties.get("db_user"), (String)properties.get("db_password"), (String)properties.get("db_catalog"), (String)properties.get("db_schema"), readOnly);
    }
}

