/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.databene.commons.iterator.IteratorProxy;
import org.databene.jdbacl.ResultSetIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterator
extends IteratorProxy<ResultSet> {
    public QueryIterator(String query, Connection connection, int fetchSize) {
        super(QueryIterator.createSource(query, connection, fetchSize));
    }

    private static Iterator<ResultSet> createSource(String query, Connection connection, int fetchSize) {
        try {
            Statement statement = connection.createStatement(1003, 1007, 1);
            statement.setFetchSize(fetchSize);
            ResultSet resultSet = statement.executeQuery(query);
            return new ResultSetIterator(resultSet, query);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error in query: " + query, e);
        }
    }

    public String[] getColumnLabels() {
        return ((ResultSetIterator)((Object)this.source)).getColumnLabels();
    }
}

