/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.databene.commons.HeavyweightIterator;
import org.databene.jdbacl.DBUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetIterator
implements HeavyweightIterator<ResultSet> {
    private ResultSet resultSet;
    private Boolean hasNext;
    private String[] columnLabels;
    private String query;
    private static final Logger logger = LoggerFactory.getLogger(ResultSetIterator.class);

    public ResultSetIterator(ResultSet resultSet) {
        this(resultSet, "");
    }

    public ResultSetIterator(ResultSet resultSet, String query) {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet is null");
        }
        this.resultSet = resultSet;
        this.hasNext = null;
        this.query = query;
    }

    public String[] getColumnLabels() {
        if (this.columnLabels == null) {
            try {
                ResultSetMetaData metaData = this.resultSet.getMetaData();
                int n = metaData.getColumnCount();
                this.columnLabels = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.columnLabels[i] = metaData.getColumnLabel(i + 1);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Error querying column meta data", e);
            }
        }
        return this.columnLabels;
    }

    public boolean hasNext() {
        if (logger.isDebugEnabled()) {
            logger.debug("hasNext() called on: " + this);
        }
        if (this.hasNext != null) {
            return this.hasNext;
        }
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("hasNext() checks resultSet availability of: " + this);
            }
            this.hasNext = this.resultSet.next();
            if (!this.hasNext.booleanValue()) {
                this.close();
            }
            return this.hasNext;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error in query: " + this.query, e);
        }
    }

    public ResultSet next() {
        if (logger.isDebugEnabled()) {
            logger.debug("next() called on: " + this);
        }
        if (!this.hasNext()) {
            throw new IllegalStateException("No more row available. Use hasNext() for checking availability.");
        }
        this.hasNext = null;
        return this.resultSet;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    public synchronized void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("closing " + this);
        }
        this.hasNext = false;
        if (this.resultSet == null) {
            return;
        }
        DBUtil.closeResultSetAndStatement(this.resultSet);
        this.resultSet = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.query + ']';
    }
}

