/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.databene.commons.ArrayFormat;
import org.databene.commons.CollectionUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.NameSpec;
import org.databene.jdbacl.model.DBCheckConstraint;
import org.databene.jdbacl.model.DBColumn;
import org.databene.jdbacl.model.DBConstraint;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBNotNullConstraint;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBPrimaryKeyConstraint;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBUniqueConstraint;
import org.databene.jdbacl.model.ForeignKeyPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLUtil {
    private static final Set<String> NO_SIZE_TYPES = CollectionUtil.toSet((Object[])new String[]{"DATE", "BLOB", "CLOB", "NCLOB"});
    private static final Set<String> DDL_STATEMENTS = CollectionUtil.toSet((Object[])new String[]{"create table", "alter table", "drop table", "create unique index", "drop index", "alter index", "rename", "create materialized view", "alter materialized view", "drop materialized view"});
    private static final Set<String> DML_STATEMENTS = CollectionUtil.toSet((Object[])new String[]{"insert", "update", "delete", "truncate", "select into"});
    private static final Set<String> PROCEDURE_CALLS = CollectionUtil.toSet((Object[])new String[]{"execute", "exec", "call"});

    public static Object[] parseColumnTypeAndSize(String spec) {
        int lparen = spec.indexOf(40);
        if (lparen < 0) {
            return new Object[]{spec};
        }
        String type = spec.substring(0, lparen);
        int rparen = spec.indexOf(41, lparen);
        if (rparen < 0) {
            throw new RuntimeException("Illegal column type format: " + spec);
        }
        String[] sizeAndFractionDigits = spec.substring(lparen + 1, rparen).split(",");
        if (sizeAndFractionDigits.length == 1) {
            return new Object[]{type, Integer.parseInt(sizeAndFractionDigits[0].trim())};
        }
        return new Object[]{type, Integer.parseInt(sizeAndFractionDigits[0].trim()), Integer.parseInt(sizeAndFractionDigits[1].trim())};
    }

    public static void renderCreateTable(DBTable table, boolean includeForeignKeys, NameSpec nameSpec, PrintWriter out) {
        out.print("create table ");
        out.print(table.getName());
        out.print(" (");
        List<DBColumn> columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                out.print(',');
            }
            out.println();
            out.print('\t');
            out.print(SQLUtil.renderColumn(columns.get(i)));
        }
        DBPrimaryKeyConstraint pk = table.getPrimaryKeyConstraint();
        if (pk != null) {
            out.println(",");
            out.print('\t');
            out.print(SQLUtil.pkSpec(pk, nameSpec));
        }
        Set<DBUniqueConstraint> uks = table.getUniqueConstraints(false);
        for (DBUniqueConstraint uk : uks) {
            out.println(",");
            out.print('\t');
            out.print(SQLUtil.ukSpec(uk, nameSpec));
        }
        if (includeForeignKeys) {
            Set<DBForeignKeyConstraint> fks = table.getForeignKeyConstraints();
            for (DBForeignKeyConstraint fk : fks) {
                out.println(",");
                out.print('\t');
                out.print(SQLUtil.fkSpec(fk, nameSpec));
            }
        }
        List<DBCheckConstraint> checks = table.getCheckConstraints();
        for (DBCheckConstraint check : checks) {
            out.println(",");
            out.print('\t');
            out.print(SQLUtil.checkSpec(check, nameSpec));
        }
        out.println();
        out.print(")");
    }

    public static void renderAddForeignKey(DBForeignKeyConstraint fk, NameSpec nameSpec, PrintWriter printer) {
        printer.println("ALTER TABLE " + fk.getTable().getName() + " ADD ");
        printer.print('\t');
        printer.print(SQLUtil.fkSpec(fk, nameSpec));
    }

    public static String[] prependAlias(String tableAlias, String[] columnNames) {
        if (tableAlias != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = tableAlias + '.' + columnNames[i];
            }
        }
        return columnNames;
    }

    public static String renderColumnNames(DBColumn[] columns) {
        StringBuilder builder = new StringBuilder(columns[0].getName());
        for (int i = 1; i < columns.length; ++i) {
            builder.append(", ").append(columns[i].getName());
        }
        return builder.toString();
    }

    public static String renderColumnNames(List<DBColumn> columns) {
        StringBuilder builder = new StringBuilder(columns.get(0).getName());
        for (int i = 1; i < columns.size(); ++i) {
            builder.append(", ").append(columns.get(i).getName());
        }
        return builder.toString();
    }

    public static String renderColumnNames(String[] columnNames) {
        return '(' + ArrayFormat.format((Object[])columnNames) + ')';
    }

    public static String renderColumn(DBColumn column) {
        StringBuilder builder = new StringBuilder();
        builder.append(column.getName());
        builder.append(' ');
        SQLUtil.renderColumnTypeWithSize(column, builder);
        if (column.getDefaultValue() != null) {
            builder.append(" DEFAULT " + column.getDefaultValue());
        }
        if (!column.isNullable()) {
            builder.append(" NOT");
        }
        builder.append(" NULL");
        return builder.toString();
    }

    public static String renderColumnTypeWithSize(DBColumn column) {
        StringBuilder builder = new StringBuilder();
        SQLUtil.renderColumnTypeWithSize(column, builder);
        return builder.toString();
    }

    public static void renderColumnTypeWithSize(DBColumn column, StringBuilder builder) {
        String typeName = column.getType().getName();
        builder.append(typeName);
        if (column.getSize() != null && !NO_SIZE_TYPES.contains(typeName)) {
            builder.append("(" + column.getSize());
            if (column.getFractionDigits() != null) {
                builder.append("," + column.getFractionDigits());
            }
            builder.append(")");
        }
    }

    public static String substituteMarkers(String sql, String marker, Object substitution, DatabaseDialect dialect) {
        return sql.replace(marker, dialect.formatValue(substitution));
    }

    public static String renderQuery(DBTable table, String[] columnNames, Object[] values, DatabaseDialect dialect) {
        StringBuilder builder = new StringBuilder("SELECT * FROM ").append(table.getName());
        builder.append(" WHERE ").append(SQLUtil.renderWhereClause(columnNames, values, dialect));
        return builder.toString();
    }

    public static String renderWhereClause(String[] columnNames, Object[] values, DatabaseDialect dialect) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < columnNames.length; ++i) {
            if (i > 0) {
                builder.append(" AND ");
            }
            builder.append(columnNames[i]).append(" = ").append(dialect.formatValue(values[i]));
        }
        return builder.toString();
    }

    public static Boolean mutatesDataOrStructure(String sql) {
        if ((sql = SQLUtil.normalizeSQL(sql)).trim().startsWith("alter session")) {
            return false;
        }
        if (Boolean.TRUE.equals(SQLUtil.mutatesStructure(sql))) {
            return true;
        }
        if (SQLUtil.isQuery(sql)) {
            return false;
        }
        if (SQLUtil.isDML(sql)) {
            return true;
        }
        return null;
    }

    public static Boolean mutatesStructure(String sql) {
        if (SQLUtil.isDDL(sql)) {
            return true;
        }
        if (SQLUtil.isProcedureCall(sql)) {
            return false;
        }
        return false;
    }

    public static boolean isDDL(String sql) {
        sql = SQLUtil.normalizeSQL(sql);
        for (String ddl : DDL_STATEMENTS) {
            if (!sql.startsWith(ddl)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDML(String sql) {
        sql = SQLUtil.normalizeSQL(sql);
        for (String ddl : DML_STATEMENTS) {
            if (!sql.startsWith(ddl)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProcedureCall(String sql) {
        sql = SQLUtil.normalizeSQL(sql);
        for (String call : PROCEDURE_CALLS) {
            if (!sql.startsWith(call)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuery(String sql) {
        if (!(sql = SQLUtil.normalizeSQL(sql)).startsWith("select")) {
            return false;
        }
        StringTokenizer t = new StringTokenizer(sql);
        while (t.hasMoreTokens()) {
            if (!"into".equals(t.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static String normalizeSQL(String sql) {
        sql = StringUtil.normalizeSpace((String)sql.trim().toLowerCase());
        while (sql.contains("/*")) {
            sql = StringUtil.removeSection((String)sql, (String)"/*", (String)"*/").trim();
        }
        return sql;
    }

    public static String constraintSpec(DBConstraint constraint, NameSpec nameSpec) {
        if (constraint instanceof DBPrimaryKeyConstraint) {
            return SQLUtil.pkSpec((DBPrimaryKeyConstraint)constraint, nameSpec);
        }
        if (constraint instanceof DBUniqueConstraint) {
            return SQLUtil.ukSpec((DBUniqueConstraint)constraint, nameSpec);
        }
        if (constraint instanceof DBForeignKeyConstraint) {
            return SQLUtil.fkSpec((DBForeignKeyConstraint)constraint, nameSpec);
        }
        if (constraint instanceof DBNotNullConstraint) {
            return SQLUtil.notNullSpec((DBNotNullConstraint)constraint);
        }
        if (constraint instanceof DBCheckConstraint) {
            return SQLUtil.checkSpec((DBCheckConstraint)constraint, nameSpec);
        }
        throw new UnsupportedOperationException("Unknown constraint type: " + constraint.getClass());
    }

    private static String checkSpec(DBCheckConstraint check, NameSpec nameSpec) {
        StringBuilder builder = SQLUtil.createConstraintSpecBuilder(check, nameSpec);
        builder.append("CHECK ").append(check.getConditionText());
        return builder.toString();
    }

    private static String notNullSpec(DBNotNullConstraint constraint) {
        return constraint.getColumnNames()[0] + " NOT NULL";
    }

    public static String pkSpec(DBPrimaryKeyConstraint pk, NameSpec nameSpec) {
        StringBuilder builder = SQLUtil.createConstraintSpecBuilder(pk, nameSpec);
        builder.append("PRIMARY KEY ").append(SQLUtil.renderColumnNames(pk.getColumnNames()));
        return builder.toString();
    }

    public static String ukSpec(DBUniqueConstraint uk, NameSpec nameSpec) {
        StringBuilder builder = SQLUtil.createConstraintSpecBuilder(uk, nameSpec);
        builder.append("UNIQUE ").append(SQLUtil.renderColumnNames(uk.getColumnNames()));
        return builder.toString();
    }

    public static String fkSpec(DBForeignKeyConstraint fk, NameSpec nameSpec) {
        StringBuilder builder = SQLUtil.createConstraintSpecBuilder(fk, nameSpec);
        builder.append("FOREIGN KEY ").append(SQLUtil.renderColumnNames(fk.getColumnNames()));
        builder.append(" REFERENCES ").append(fk.getRefereeTable()).append(SQLUtil.renderColumnNames(fk.getRefereeColumnNames()));
        return builder.toString();
    }

    protected static StringBuilder createConstraintSpecBuilder(DBConstraint constraint, NameSpec nameSpec) {
        StringBuilder builder = new StringBuilder();
        return SQLUtil.appendConstraintName(constraint, builder, nameSpec);
    }

    public static String insert(String table, DatabaseDialect dialect, Object ... values) {
        StringBuilder builder = new StringBuilder("insert into ").append(table).append(" values (");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(dialect.formatValue(values[i]));
        }
        return builder.append(")").toString();
    }

    public static String joinFKPath(ForeignKeyPath route, String join_Type, String startAlias, String endAlias, String intermediateAliasBase) {
        return SQLUtil.joinFKPath(route, join_Type, startAlias, endAlias, intermediateAliasBase, null);
    }

    public static String joinFKPath(ForeignKeyPath route, String join_Type, String startAlias, String endAlias, String intermediateAliasBase, String indent) {
        StringBuilder builder = new StringBuilder();
        List<DBForeignKeyConstraint> edges = route.getEdges();
        String currentReferrer = startAlias;
        for (int i = 0; i < edges.size() - 1; ++i) {
            String refereeAlias = intermediateAliasBase + "_" + (i + 1) + "__";
            DBForeignKeyConstraint fk = edges.get(i);
            builder.append(SQLUtil.joinFK(fk, join_Type, currentReferrer, refereeAlias));
            currentReferrer = refereeAlias;
            builder.append(' ');
            if (indent == null) continue;
            builder.append(SystemInfo.getLineSeparator()).append('\t');
        }
        DBForeignKeyConstraint fk = (DBForeignKeyConstraint)CollectionUtil.lastElement(edges);
        builder.append(SQLUtil.joinFK(fk, join_Type, currentReferrer, endAlias));
        return builder.toString();
    }

    public static String joinFK(DBForeignKeyConstraint fk, String joinType, String refererAlias, String refereeAlias) {
        return SQLUtil.join(joinType, refererAlias, fk.getColumnNames(), fk.getRefereeTable().getName(), refereeAlias, fk.getRefereeColumnNames());
    }

    public static String leftJoin(String alias1, String[] columns1, String table2, String alias2, String[] columns2) {
        return SQLUtil.join("LEFT", alias1, columns1, table2, alias2, columns2);
    }

    public static String innerJoin(String alias1, String[] columns1, String table2, String alias2, String[] columns2) {
        return SQLUtil.join("INNER", alias1, columns1, table2, alias2, columns2);
    }

    public static String join(String type, String refererAlias, String[] refererColumns, String refereeTable, String refereeAlias, String[] refereeColumns) {
        StringBuilder builder = new StringBuilder();
        if (!StringUtil.isEmpty((CharSequence)type) && !"INNER".equalsIgnoreCase(type)) {
            builder.append(type).append(' ');
        }
        builder.append("JOIN ");
        builder.append(refereeTable).append(" ").append(refereeAlias).append(" ON ");
        for (int i = 0; i < refererColumns.length; ++i) {
            if (i > 0) {
                builder.append(" AND ");
            }
            builder.append(refererAlias).append('.').append(refererColumns[i]);
            builder.append(" = ").append(refereeAlias).append('.').append(refereeColumns[i]);
        }
        return builder.toString();
    }

    public static StringBuilder addRequiredCondition(String condition, StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append(" AND ");
        }
        return builder.append(condition);
    }

    public static StringBuilder addOptionalCondition(String condition, StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append(" OR ");
        }
        return builder.append(condition);
    }

    public static String ownerDotComponent(DBObject object) {
        return (object.getOwner() != null ? object.getOwner() + "." : "") + object.getName();
    }

    public static StringBuilder appendConstraintName(DBConstraint constraint, StringBuilder builder, NameSpec nameSpec) {
        if (constraint.getName() != null && (nameSpec == NameSpec.ALWAYS || nameSpec == NameSpec.IF_REPRODUCIBLE && constraint.isNameDeterministic())) {
            builder.append("CONSTRAINT " + SQLUtil.quoteNameIfNecessary(constraint.getName()) + ' ');
        }
        return builder;
    }

    public static void appendConstraintName(DBConstraint constraint, StringBuilder builder) {
        if (constraint.getName() != null) {
            builder.append("CONSTRAINT " + SQLUtil.quoteNameIfNecessary(constraint.getName()) + ' ');
        }
    }

    public static String constraintName(DBConstraint constraint) {
        return constraint.getName() != null ? "CONSTRAINT " + SQLUtil.quoteNameIfNecessary(constraint.getName()) + ' ' : "";
    }

    public static String typeAndName(DBObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        String name = dbObject.getName();
        if (name == null && dbObject instanceof DBConstraint) {
            name = "CONSTRAINT";
        }
        return dbObject.getObjectType() + ' ' + name;
    }

    public static String removeComments(String sql) {
        String tmp;
        String result = sql;
        while (!(result = StringUtil.removeSection((String)(tmp = result), (String)"/*", (String)"*/")).equals(tmp)) {
        }
        return result;
    }

    public static String normalize(String sql, boolean removeComments) {
        if (removeComments) {
            sql = sql.replace("--", "//");
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(sql));
        tokenizer.resetSyntax();
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(95, 95);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.whitespaceChars(10, 10);
        tokenizer.whitespaceChars(13, 13);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.quoteChar(39);
        tokenizer.quoteChar(34);
        if (removeComments) {
            tokenizer.slashStarComments(true);
            tokenizer.slashSlashComments(true);
        }
        StringBuilder builder = new StringBuilder();
        int lastTtype = -1;
        try {
            while (tokenizer.nextToken() != -1) {
                int ttype = tokenizer.ttype;
                if (!(builder.length() <= 0 || ttype == 41 || ttype == 44 || lastTtype == 40 || lastTtype == 46 || ttype == 46 || lastTtype == 47 && ttype == 42 || lastTtype == 45 && ttype == 45 || lastTtype == 42 && ttype == 47)) {
                    builder.append(' ');
                }
                switch (ttype) {
                    case -3: {
                        builder.append(tokenizer.sval);
                        break;
                    }
                    case -2: {
                        builder.append(SQLUtil.renderNumber(tokenizer));
                        break;
                    }
                    case 34: {
                        builder.append('\"').append(tokenizer.sval).append('\"');
                        break;
                    }
                    case 39: {
                        builder.append('\'').append(tokenizer.sval).append('\'');
                        break;
                    }
                    default: {
                        builder.append((char)ttype);
                    }
                }
                lastTtype = ttype;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    protected static String renderNumber(StreamTokenizer tokenizer) {
        double value = tokenizer.nval;
        if (Math.floor(value) == value) {
            return SQLUtil.renderLong((long)value);
        }
        return SQLUtil.renderDouble(value);
    }

    public static String renderColumnListWithTableName(String table, String ... columns) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(table).append('.').append(columns[i]);
        }
        return builder.toString();
    }

    public static String equals(String tableAlias1, String[] colNames1, String tableAlias2, String[] colNames2) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < colNames1.length; ++i) {
            if (i > 0) {
                builder.append(" AND ");
            }
            if (tableAlias1 != null) {
                builder.append(tableAlias1).append('.');
            }
            builder.append(colNames1[i]).append(" = ");
            if (tableAlias2 != null) {
                builder.append(tableAlias2).append('.');
            }
            builder.append(colNames2[i]);
        }
        return builder.toString();
    }

    private static String renderLong(long value) {
        if (value > 0L) {
            return String.valueOf(value);
        }
        return "- " + String.valueOf(Math.abs(value));
    }

    private static String renderDouble(double value) {
        if (value > 0.0) {
            return String.valueOf(value);
        }
        return "- " + String.valueOf(Math.abs(value));
    }

    private static String quoteNameIfNecessary(String name) {
        return name != null && name.indexOf(32) >= 0 ? '\"' + name + '\"' : name;
    }

    public static String formatValueList(List<String> values, DatabaseDialect dialect) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(dialect.formatValue(values.get(i)));
        }
        return builder.toString();
    }
}

