/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.sql.Query;

public class MySQLDialect
extends DatabaseDialect {
    private static final String DATE_PATTERN = "''yyyy-MM-dd''";
    private static final String TIME_PATTERN = "''HH:mm:ss''";
    private static final String DATETIME_PATTERN = "''yyyy-MM-dd HH:mm:ss''";

    public MySQLDialect() {
        super("mysql", false, false, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    public boolean isDefaultCatalog(String catalog, String user) {
        return false;
    }

    public boolean isDefaultSchema(String schema, String user) {
        return false;
    }

    public boolean isDeterministicPKName(String pkName) {
        return true;
    }

    public boolean isDeterministicUKName(String ukName) {
        return true;
    }

    public boolean isDeterministicFKName(String fkName) {
        return true;
    }

    public boolean isDeterministicIndexName(String indexName) {
        return true;
    }

    public boolean supportsRegex() {
        return true;
    }

    public String regexQuery(String expression, boolean not, String regex) {
        return expression + (not ? " NOT" : "") + " REGEXP '" + regex + "'";
    }

    public void restrictRownums(int firstRowIndex, int rowCount, Query query) {
        throw new UnsupportedOperationException("MySQLDialect.applyRownumRestriction() is not implemented");
    }
}

