/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity;

import java.io.Closeable;
import java.sql.Connection;
import java.util.Iterator;
import org.databene.commons.ArrayFormat;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.iterator.ConvertingIterator;
import org.databene.commons.iterator.TabularIterator;
import org.databene.jdbacl.ArrayResultSetIterator;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.DatabaseDialectManager;
import org.databene.jdbacl.QueryIterator;
import org.databene.jdbacl.ResultSetConverter;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.IdentityProvider;
import org.databene.jdbacl.identity.InvalidIdentityDefinitionError;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.Database;

public class SubNkPkQueryIdentity
extends IdentityModel {
    private String[] parentTableNames;
    private String subNkPkQuery;
    private IdentityProvider identityProvider;

    public SubNkPkQueryIdentity(String tableName, String[] parentTableNames, IdentityProvider identityProvider) {
        super(tableName);
        this.parentTableNames = parentTableNames;
        this.identityProvider = identityProvider;
    }

    public void setSubNkPkQuery(String subNkPkQuery) {
        this.subNkPkQuery = subNkPkQuery;
    }

    public String getDescription() {
        return "Sub identity of (" + ArrayFormat.format((Object[])this.parentTableNames) + "):" + SystemInfo.getLineSeparator() + this.subNkPkQuery;
    }

    public TabularIterator createNkPkIterator(Connection connection, String dbId, KeyMapper mapper, Database database) {
        return new RecursiveIterator(connection, dbId, mapper, database);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RecursiveIterator
    implements TabularIterator {
        Connection connection;
        String dbId;
        KeyMapper mapper;
        HeavyweightIterator<Object> ownerPkIterator;
        String ownerNK;
        TabularIterator subNkPkIterator;
        DatabaseDialect dialect;

        public RecursiveIterator(Connection connection, String dbId, KeyMapper mapper, Database database) {
            this.connection = connection;
            this.dbId = dbId;
            this.mapper = mapper;
            this.dialect = DatabaseDialectManager.getDialectForProduct(database.getDatabaseProductName(), database.getDatabaseProductVersion());
            this.ownerPkIterator = this.createParentPkIterator(connection, database);
            this.createSubNkPkIterator(connection, dbId);
        }

        protected HeavyweightIterator<Object> createParentPkIterator(Connection connection, Database database) {
            DBTable parentTable = database.getTable(SubNkPkQueryIdentity.this.parentTableNames[0]);
            StringBuilder query = new StringBuilder("select ");
            query.append(ArrayFormat.format((Object[])parentTable.getPKColumnNames()));
            query.append(" from ").append(parentTable);
            QueryIterator rawIterator = new QueryIterator(query.toString(), connection, 100);
            ResultSetConverter<Object> converter = new ResultSetConverter<Object>(Object.class, true);
            return new ConvertingIterator((Iterator)((Object)rawIterator), converter);
        }

        public boolean hasNext() {
            if (this.subNkPkIterator.hasNext()) {
                return true;
            }
            while (this.subNkPkIterator != null && !this.subNkPkIterator.hasNext() && this.ownerPkIterator.hasNext()) {
                IOUtil.close((Closeable)this.subNkPkIterator);
                this.createSubNkPkIterator(this.connection, this.dbId);
            }
            return this.subNkPkIterator != null && this.subNkPkIterator.hasNext();
        }

        public Object[] next() {
            Object[] result = (Object[])this.subNkPkIterator.next();
            result[0] = this.ownerNK + '|' + result[0];
            return result;
        }

        public String[] getColumnNames() {
            return this.subNkPkIterator.getColumnNames();
        }

        public void remove() {
            throw new UnsupportedOperationException(this.getClass() + " does not support removal");
        }

        public void close() {
            IOUtil.close((Closeable)this.subNkPkIterator);
            IOUtil.close(this.ownerPkIterator);
        }

        private void createSubNkPkIterator(Connection connection, String dbId) {
            if (this.ownerPkIterator.hasNext()) {
                Object ownerPk = this.ownerPkIterator.next();
                this.ownerNK = this.mapper.getNaturalKey(dbId, SubNkPkQueryIdentity.this.identityProvider.getIdentity(SubNkPkQueryIdentity.this.parentTableNames[0]), ownerPk);
                if (this.ownerNK == null) {
                    throw new InvalidIdentityDefinitionError(SubNkPkQueryIdentity.this.tableName + " row with PK " + ownerPk + " cannot be found. Most likely this is a subsequent fault of a parent's identity" + " definition: " + ArrayFormat.format((Object[])SubNkPkQueryIdentity.this.parentTableNames));
                }
                String query = SQLUtil.substituteMarkers(SubNkPkQueryIdentity.this.subNkPkQuery, "?", ownerPk, this.dialect);
                this.subNkPkIterator = new ArrayResultSetIterator(connection, query);
            } else {
                this.subNkPkIterator = null;
            }
        }
    }
}

