/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity;

import java.sql.Connection;
import java.util.Iterator;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.converter.ThreadSafeConverter;
import org.databene.commons.iterator.ConvertingIterator;
import org.databene.commons.iterator.TabularIterator;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.identity.NKBuilder;
import org.databene.jdbacl.model.Database;

public class UniqueKeyIdentity
extends IdentityModel {
    private String[] columnNames;

    public UniqueKeyIdentity(String tableName, String ... columnNames) {
        super(tableName);
        this.setColumns(columnNames);
    }

    public void setColumns(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public TabularIterator createNkPkIterator(Connection connection, String dbId, KeyMapper mapper, Database database) {
        String[] pkColumnNames;
        if (ArrayUtil.isEmpty((Object)this.columnNames)) {
            throw new ConfigurationError("No unique key columns defined");
        }
        StringBuilder builder = new StringBuilder("select ");
        builder.append(this.columnNames[0]);
        for (int i = 1; i < this.columnNames.length; ++i) {
            builder.append(", ").append(this.columnNames[i]);
        }
        for (String columnName : pkColumnNames = database.getTable(this.tableName).getPKColumnNames()) {
            builder.append(", ").append(columnName);
        }
        builder.append(" from ").append(this.tableName);
        String query = builder.toString();
        TabularIterator rawIterator = this.query(query, connection);
        ColumnToNkConverter converter = new ColumnToNkConverter(dbId, mapper);
        return new UniqueKeyNkPkIterator(rawIterator, converter, pkColumnNames);
    }

    public String getDescription() {
        return "Identity definition by unique key: " + ArrayFormat.format((Object[])this.columnNames);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnToNkConverter
    extends ThreadSafeConverter<Object[], Object[]> {
        String dbId;
        KeyMapper mapper;

        public ColumnToNkConverter(String dbId, KeyMapper mapper) {
            super(Object[].class, Object[].class);
            this.dbId = dbId;
            this.mapper = mapper;
        }

        public Object[] convert(Object[] raw) {
            NKBuilder nkBuilder = new NKBuilder();
            for (int i = 0; i < UniqueKeyIdentity.this.columnNames.length; ++i) {
                Object value = raw[i];
                nkBuilder.addComponent(value);
            }
            ArrayBuilder arrayBuilder = new ArrayBuilder(Object.class);
            arrayBuilder.add((Object)nkBuilder.toString());
            for (int i = UniqueKeyIdentity.this.columnNames.length; i < raw.length; ++i) {
                arrayBuilder.add(raw[i]);
            }
            return arrayBuilder.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UniqueKeyNkPkIterator
    extends ConvertingIterator<Object[], Object[]>
    implements TabularIterator {
        String[] pkColumnNames;

        public UniqueKeyNkPkIterator(TabularIterator rawIterator, ColumnToNkConverter converter, String[] pkColumnNames) {
            super((Iterator)rawIterator, (Converter)converter);
            this.pkColumnNames = UniqueKeyIdentity.this.columnNames;
        }

        public String[] getColumnNames() {
            String[] labels = new String[1 + this.pkColumnNames.length];
            labels[0] = "NK";
            for (int i = 1; i < labels.length; ++i) {
                labels[i] = this.pkColumnNames[i - 1];
            }
            return labels;
        }
    }
}

