/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.databene.commons.CollectionUtil;
import org.databene.commons.Named;

public class DBDataType
implements Named,
Serializable {
    private static final long serialVersionUID = 7725335502838132325L;
    private static final Set<Integer> ALPHA_TYPES = CollectionUtil.toSet((Object[])new Integer[]{1, 2005, -1, -16, -15, 2011, -9, 12});
    private static final Set<Integer> NUMBER_TYPES = CollectionUtil.toSet((Object[])new Integer[]{-5, 3, 8, 6, 4, 2, 5, -6});
    private static final Set<Integer> INTEGER_TYPES = CollectionUtil.toSet((Object[])new Integer[]{-5, 4, 5, -6});
    private static final HashMap<String, Integer> JDBC_TYPE_FOR_DB_TYPE = (HashMap)CollectionUtil.buildMap((Object[])new Object[]{"ARRAY", 2003, "BIGINT", -5, "BINARY", -2, "BIT", -7, "BLOB", 2004, "BOOLEAN", 16, "BOOL", 16, "CHAR", 1, "CHARACTER", 1, "CLOB", 2005, "DATALINK", 70, "DATE", 91, "DECIMAL", 3, "DEC", 3, "NUMBER", 3, "DISTINCT", 2001, "DOUBLE", 8, "DOUBLE PRECISION", 8, "BINARY_DOUBLE", 8, "FLOAT", 6, "BINARY_FLOAT", 6, "INT", 4, "INTEGER", 4, "BINARY_INTEGER", 4, "PLS_INTEGER", 4, "OBJECT", 2000, "LONGNVARCHAR", -16, "LONG", -16, "LONGVARBINARY", -4, "LONGVARCHAR", -1, "NCHAR", -15, "NATIONAL CHARACTER", -15, "NCLOB", 2011, "NULL", 0, "NUMERIC", 2, "NVARCHAR", -9, "NATIONAL CHARACTER VARYING", -9, "NVARCHAR2", -9, "REAL", 7, "REF", 2006, "ROWID", -8, "UROWID", -8, "SMALLINT", 5, "XML", 2009, "XMLType", 2009, "STRUCT", 2002, "TIME", 92, "DATETIME", 93, "TIMESTAMP", 93, "TINYINT", -6, "VARBINARY", -3, "TEXT", 12, "VARCHAR", 12, "CHARACTER VARYING", 12, "VARCHAR2", 12, "BIT VARYING", 1111, "INTERVAL", 1111});
    private static final HashMap<TypeDescriptor, DBDataType> INSTANCES_BY_TYPE_AND_NAME = new HashMap();
    private static final HashMap<String, DBDataType> INSTANCES_BY_NAME = new HashMap();
    private String name;
    private int jdbcType;

    public static DBDataType getInstance(String name) {
        DBDataType result = INSTANCES_BY_NAME.get(name = name.toUpperCase());
        if (result == null) {
            result = new DBDataType(DBDataType.jdbcTypeFor(name), name);
            INSTANCES_BY_NAME.put(name, result);
        }
        return result;
    }

    public static DBDataType getInstance(int jdbcType, String name) {
        TypeDescriptor descriptor = new TypeDescriptor(jdbcType, name.toUpperCase());
        DBDataType result = INSTANCES_BY_TYPE_AND_NAME.get(descriptor);
        if (result == null) {
            result = new DBDataType(jdbcType, name);
            INSTANCES_BY_TYPE_AND_NAME.put(descriptor, result);
            if (result.jdbcType != descriptor.jdbcType) {
                INSTANCES_BY_TYPE_AND_NAME.put(new TypeDescriptor(jdbcType, name), result);
            }
        }
        return result;
    }

    private DBDataType(String name) {
        this(DBDataType.jdbcTypeFor(name), name);
    }

    private DBDataType(int sqlType, String name) {
        if (name.equals("NCLOB")) {
            sqlType = 2011;
        }
        this.jdbcType = sqlType;
        this.name = name.toUpperCase();
    }

    public static int jdbcTypeFor(String name) {
        return JDBC_TYPE_FOR_DB_TYPE.get(name.toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public boolean isLOB() {
        return this.jdbcType == 2004 || this.jdbcType == 2005 || this.jdbcType == 2011 || this.name.endsWith("CLOB") || "BLOB".equals(this.name);
    }

    public boolean isVarChar() {
        return this.jdbcType == 12 || this.jdbcType == -9;
    }

    public boolean isAlpha() {
        if (ALPHA_TYPES.contains(this.jdbcType)) {
            return true;
        }
        return this.name.endsWith("VARCHAR2") || this.name.endsWith("CLOB");
    }

    public boolean isNumber() {
        return NUMBER_TYPES.contains(this.jdbcType);
    }

    public boolean isInteger() {
        return INTEGER_TYPES.contains(this.jdbcType);
    }

    public boolean isDecimal() {
        return this.jdbcType == 3 || this.jdbcType == 2;
    }

    public boolean isTemporal() {
        return this.jdbcType == 91 || this.jdbcType == 93 || this.name.contains("DATE") || this.name.contains("TIME");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBDataType that = (DBDataType)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    private static class TypeDescriptor {
        final int jdbcType;
        final String name;

        TypeDescriptor(int jdbcType, String name) {
            this.jdbcType = jdbcType;
            this.name = name;
        }

        public int hashCode() {
            return this.jdbcType * 31 + this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TypeDescriptor that = (TypeDescriptor)other;
            return this.jdbcType == that.jdbcType && this.name.equals(that.name);
        }
    }
}

