/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.List;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.anno.Nullable;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.jdbacl.model.AbstractCompositeDBObject;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBProcedure;
import org.databene.jdbacl.model.DBSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPackage
extends AbstractCompositeDBObject<DBProcedure> {
    private static final long serialVersionUID = 5001335810310474145L;
    @Nullable
    private String subObjectName;
    private String objectId;
    @Nullable
    private String dataObjectId;
    private String objectType;
    private String status;
    private OrderedNameMap<DBProcedure> procedures = OrderedNameMap.createCaseIgnorantMap();

    public DBPackage(String name, DBSchema owner) {
        super(name, "package", owner);
        if (owner != null) {
            owner.addPackage(this);
        }
    }

    public DBSchema getSchema() {
        return (DBSchema)this.getOwner();
    }

    public void setSchema(DBSchema schema) {
        this.setOwner(schema);
    }

    public String getSubObjectName() {
        return this.subObjectName;
    }

    public void setSubObjectName(String subObjectName) {
        this.subObjectName = subObjectName;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getDataObjectId() {
        return this.dataObjectId;
    }

    public void setDataObjectId(String dataObjectId) {
        this.dataObjectId = dataObjectId;
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<DBProcedure> getProcedures() {
        return this.procedures.values();
    }

    public void setProcedures(OrderedNameMap<DBProcedure> procedures) {
        this.procedures = procedures;
    }

    @Override
    public List<DBProcedure> getComponents() {
        return this.procedures.values();
    }

    public void addProcedure(DBProcedure procedure) {
        this.procedures.put(procedure.getName(), (Object)procedure);
        procedure.setOwner(this);
    }

    @Override
    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DBPackage that = (DBPackage)other;
        return NullSafeComparator.equals((Object)this.subObjectName, (Object)that.subObjectName) && this.objectId.equals(that.objectId) && NullSafeComparator.equals((Object)this.dataObjectId, (Object)that.dataObjectId) && this.objectType.equals(that.objectType) && this.status.equals(that.status);
    }
}

