/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.databene.commons.ArrayFormat;
import org.databene.commons.Assert;
import org.databene.commons.CollectionUtil;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.NameUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.OrderedSet;
import org.databene.commons.StringUtil;
import org.databene.commons.bean.HashCodeBuilder;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.depend.Dependent;
import org.databene.commons.iterator.ConvertingIterator;
import org.databene.commons.iterator.TabularIterator;
import org.databene.jdbacl.ArrayResultSetIterator;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.QueryIterator;
import org.databene.jdbacl.ResultSetConverter;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.AbstractCompositeDBObject;
import org.databene.jdbacl.model.ContainerComponent;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBCheckConstraint;
import org.databene.jdbacl.model.DBColumn;
import org.databene.jdbacl.model.DBDataType;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBIndex;
import org.databene.jdbacl.model.DBNonUniqueIndex;
import org.databene.jdbacl.model.DBPrimaryKeyConstraint;
import org.databene.jdbacl.model.DBRow;
import org.databene.jdbacl.model.DBRowIterator;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBTableComponent;
import org.databene.jdbacl.model.DBUniqueConstraint;
import org.databene.jdbacl.model.DBUniqueIndex;
import org.databene.jdbacl.model.MultiColumnObject;
import org.databene.jdbacl.model.TableType;
import org.databene.jdbacl.model.jdbc.DBIndexInfo;
import org.databene.jdbacl.model.jdbc.JDBCDBImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTable
extends AbstractCompositeDBObject<DBTableComponent>
implements ContainerComponent,
MultiColumnObject,
Dependent<DBTable> {
    private static final long serialVersionUID = 1259670951314570432L;
    private static final String[] EMPTY_ARRAY = new String[0];
    private TableType tableType;
    private JDBCDBImporter importer;
    private OrderedNameMap<DBColumn> columns;
    private boolean pkImported;
    private DBPrimaryKeyConstraint pk;
    private OrderedSet<DBUniqueConstraint> uniqueConstraints;
    private OrderedSet<DBForeignKeyConstraint> foreignKeyConstraints;
    private OrderedNameMap<DBIndex> indexes;
    private Set<DBTable> referrers;
    private List<DBCheckConstraint> checkConstraints;

    public DBTable(String name) {
        this(name, TableType.TABLE, null);
    }

    public DBTable(String name, TableType type, DBSchema schema) {
        this(name, TableType.TABLE, null, schema, null);
    }

    public DBTable(String name, TableType type, String doc, DBSchema schema, JDBCDBImporter importer) {
        super(name, "table", schema);
        this.importer = importer;
        this.name = name;
        this.tableType = type;
        this.doc = doc;
        this.tableType = type;
        this.pkImported = false;
        if (schema != null) {
            schema.addTable(this);
        }
    }

    @Override
    public List<DBTableComponent> getComponents() {
        ArrayList<DBTableComponent> result = new ArrayList<DBTableComponent>();
        result.addAll(this.getColumns());
        this.havePKImported();
        if (this.pk != null) {
            result.add(this.pk);
        }
        this.haveIndexesImported();
        result.addAll((Collection<DBTableComponent>)this.uniqueConstraints);
        result.addAll(this.indexes.values());
        this.haveFKsImported();
        result.addAll((Collection<DBTableComponent>)this.foreignKeyConstraints);
        return result;
    }

    public DBCatalog getCatalog() {
        return this.getSchema().getCatalog();
    }

    public DBSchema getSchema() {
        return (DBSchema)this.getOwner();
    }

    public void setSchema(DBSchema schema) {
        this.setOwner(schema);
    }

    public TableType getTableType() {
        return this.tableType;
    }

    @Override
    public String[] getColumnNames() {
        this.haveColumnsImported();
        return (String[])CollectionUtil.toArray((Collection)NameUtil.getNames((Collection)this.columns.values()), String.class);
    }

    public List<DBColumn> getColumns() {
        this.haveColumnsImported();
        return this.columns.values();
    }

    public DBColumn[] getColumns(String[] columnNames) {
        this.haveColumnsImported();
        ArrayList<DBColumn> list = new ArrayList<DBColumn>(columnNames.length);
        for (String columnName : columnNames) {
            DBColumn column = this.getColumn(columnName);
            if (column == null) {
                throw new IllegalArgumentException("Table '" + this.name + "' does not have a column '" + columnName + "'");
            }
            list.add(column);
        }
        DBColumn[] array = new DBColumn[columnNames.length];
        return list.toArray(array);
    }

    public DBColumn getColumn(String columnName) {
        this.haveColumnsImported();
        DBColumn column = (DBColumn)this.columns.get(columnName);
        if (column == null) {
            throw new ObjectNotFoundException("Column '" + columnName + "' not found in table '" + this.getName() + "'");
        }
        return column;
    }

    public void addColumn(DBColumn column) {
        this.haveColumnsImported();
        this.receiveColumn(column);
    }

    public void receiveColumn(DBColumn column) {
        if (this.columns == null) {
            this.columns = OrderedNameMap.createCaseIgnorantMap();
        }
        column.setTable(this);
        this.columns.put(column.getName(), (Object)column);
    }

    private void haveColumnsImported() {
        if (this.columns == null) {
            this.columns = OrderedNameMap.createCaseIgnorantMap();
            if (this.importer != null) {
                this.importer.importColumnsOfTable(this, new ColReceiver());
            }
        }
    }

    public void setPrimaryKey(DBPrimaryKeyConstraint constraint) {
        this.havePKImported();
        this.pk = constraint;
    }

    public DBPrimaryKeyConstraint getPrimaryKeyConstraint() {
        this.havePKImported();
        return this.pk;
    }

    public String[] getPKColumnNames() {
        DBPrimaryKeyConstraint pk = this.getPrimaryKeyConstraint();
        return pk != null ? pk.getColumnNames() : EMPTY_ARRAY;
    }

    public boolean isPKImported() {
        return this.pkImported;
    }

    public void setPKImported(boolean pkImported) {
        this.pkImported = pkImported;
    }

    public void havePKImported() {
        if (!this.isPKImported()) {
            this.haveColumnsImported();
            if (this.importer != null) {
                this.importer.importPrimaryKeyOfTable(this, new PKRec());
            }
            this.pkImported = true;
        }
    }

    public Set<DBUniqueConstraint> getUniqueConstraints(boolean includePK) {
        this.haveIndexesImported();
        HashSet<DBUniqueConstraint> result = new HashSet<DBUniqueConstraint>((Collection<DBUniqueConstraint>)this.uniqueConstraints);
        if (includePK) {
            result.add(this.pk);
        }
        return result;
    }

    public DBUniqueConstraint getUniqueConstraint(String[] columnNames) {
        this.haveIndexesImported();
        if (this.pk != null && StringUtil.equalsIgnoreCase((String[])columnNames, (String[])this.pk.getColumnNames())) {
            return this.pk;
        }
        for (DBUniqueConstraint constraint : this.uniqueConstraints) {
            if (!StringUtil.equalsIgnoreCase((String[])columnNames, (String[])constraint.getColumnNames())) continue;
            return constraint;
        }
        return null;
    }

    public DBUniqueConstraint getUniqueConstraint(String name) {
        this.haveIndexesImported();
        if (name.equalsIgnoreCase(this.pk.getName())) {
            return this.pk;
        }
        for (DBUniqueConstraint constraint : this.uniqueConstraints) {
            if (!name.equals(constraint.getName())) continue;
            return constraint;
        }
        return null;
    }

    public void addUniqueConstraint(DBUniqueConstraint uk) {
        this.haveIndexesImported();
        uk.setTable(this);
        if (uk instanceof DBPrimaryKeyConstraint) {
            this.setPrimaryKey((DBPrimaryKeyConstraint)uk);
        }
        this.uniqueConstraints.add((Object)uk);
    }

    public void removeUniqueConstraint(DBUniqueConstraint constraint) {
        this.haveIndexesImported();
        this.uniqueConstraints.remove((Object)constraint.getName());
    }

    public List<DBIndex> getIndexes() {
        this.haveIndexesImported();
        return new ArrayList<DBIndex>(this.indexes.values());
    }

    public DBIndex getIndex(String indexName) {
        this.haveIndexesImported();
        return (DBIndex)this.indexes.get(indexName);
    }

    public void addIndex(DBIndex index) {
        this.haveIndexesImported();
        index.setTable(this);
        this.indexes.put(index.getName(), (Object)index);
    }

    public void removeIndex(DBIndex index) {
        this.haveIndexesImported();
        this.indexes.remove(index.getName());
    }

    private void haveIndexesImported() {
        if (!this.areIndexesImported()) {
            this.haveColumnsImported();
            this.uniqueConstraints = new OrderedSet();
            this.indexes = OrderedNameMap.createCaseIgnorantMap();
            IdxReceiver receiver = new IdxReceiver();
            if (this.importer != null) {
                this.importer.importIndexesOfTable(this, false, receiver);
            }
        }
    }

    public boolean areIndexesImported() {
        return this.indexes != null;
    }

    public void setIndexesImported(boolean indexesImported) {
        if (indexesImported) {
            this.uniqueConstraints = new OrderedSet();
            this.indexes = OrderedNameMap.createCaseIgnorantMap();
        } else {
            this.uniqueConstraints = null;
            this.indexes = null;
        }
    }

    public Set<DBForeignKeyConstraint> getForeignKeyConstraints() {
        this.haveFKsImported();
        return new HashSet<DBForeignKeyConstraint>((Collection<DBForeignKeyConstraint>)this.foreignKeyConstraints);
    }

    public DBForeignKeyConstraint getForeignKeyConstraint(String ... columnNames) {
        this.haveFKsImported();
        for (DBForeignKeyConstraint fk : this.foreignKeyConstraints) {
            if (!StringUtil.equalsIgnoreCase((String[])fk.getColumnNames(), (String[])columnNames)) continue;
            return fk;
        }
        throw new ObjectNotFoundException("Table '" + this.name + "' has no foreign key " + "with the columns (" + ArrayFormat.format((Object[])columnNames) + ")");
    }

    public void addForeignKey(DBForeignKeyConstraint constraint) {
        this.haveFKsImported();
        constraint.setTable(this);
        this.foreignKeyConstraints.add((Object)constraint);
    }

    public void removeForeignKeyConstraint(DBForeignKeyConstraint constraint) {
        this.haveFKsImported();
        this.foreignKeyConstraints.remove((Object)constraint);
    }

    private void haveFKsImported() {
        if (!this.areFKsImported()) {
            this.haveColumnsImported();
            this.havePKImported();
            this.foreignKeyConstraints = new OrderedSet();
            if (this.importer != null) {
                this.importer.importImportedKeys(this, new FKRec());
            }
        }
    }

    public boolean areFKsImported() {
        return this.foreignKeyConstraints != null;
    }

    public void setFKsImported(boolean fksImported) {
        this.foreignKeyConstraints = fksImported ? new OrderedSet() : null;
    }

    public List<DBCheckConstraint> getCheckConstraints() {
        this.haveChecksImported();
        if (this.checkConstraints != null) {
            return new ArrayList<DBCheckConstraint>(this.checkConstraints);
        }
        return new ArrayList<DBCheckConstraint>();
    }

    public void addCheckConstraint(DBCheckConstraint checkConstraint) {
        this.haveChecksImported();
        checkConstraint.setTable(this);
        this.receiveCheckConstraint(checkConstraint);
    }

    private void haveChecksImported() {
        if (!this.areChecksImported()) {
            this.getCatalog().getDatabase().haveChecksImported();
        }
    }

    public boolean areChecksImported() {
        return this.getCatalog().getDatabase().isChecksImported();
    }

    public void setChecksImported(boolean checksImported) {
        if (checksImported) {
            if (this.checkConstraints == null) {
                this.checkConstraints = new ArrayList<DBCheckConstraint>();
            }
        } else {
            this.checkConstraints = null;
        }
    }

    public void receiveCheckConstraint(DBCheckConstraint check) {
        if (this.checkConstraints == null) {
            this.checkConstraints = new ArrayList<DBCheckConstraint>();
        }
        this.checkConstraints.add(check);
    }

    public Collection<DBTable> getReferrers() {
        this.haveReferrersImported();
        return new HashSet<DBTable>(this.referrers);
    }

    public void addReferrer(DBTable referrer) {
        this.haveReferrersImported();
        this.receiveReferrer(referrer);
    }

    public void receiveReferrer(DBTable referrer) {
        if (this.referrers == null) {
            // empty if block
        }
        this.referrers = new OrderedSet();
        this.referrers.add(referrer);
    }

    private void haveReferrersImported() {
        if (!this.areReferrersImported()) {
            this.haveFKsImported();
            this.referrers = new OrderedSet();
            if (this.importer != null) {
                this.importer.importRefererTables(this, new RefReceiver());
            }
        }
    }

    public boolean areReferrersImported() {
        return this.referrers != null;
    }

    public void setReferrersImported(boolean referrersImported) {
        if (referrersImported) {
            if (this.referrers == null) {
                this.referrers = new OrderedSet();
            }
        } else {
            this.referrers = null;
        }
    }

    public int countProviders() {
        return this.getForeignKeyConstraints().size();
    }

    public DBTable getProvider(int index) {
        return ((DBForeignKeyConstraint)this.foreignKeyConstraints.get(index)).getRefereeTable();
    }

    public boolean requiresProvider(int index) {
        String firstFkColumnName = ((DBForeignKeyConstraint)this.foreignKeyConstraints.get(index)).getForeignKeyColumnNames()[0];
        return !this.getColumn(firstFkColumnName).isNullable();
    }

    public DBRowIterator allRows(Connection connection) throws SQLException {
        return new DBRowIterator(this, connection, null);
    }

    public DBRowIterator queryRows(String whereClause, Connection connection) throws SQLException {
        return new DBRowIterator(this, connection, whereClause);
    }

    public long getRowCount(Connection connection) {
        return DBUtil.countRows(this.name, connection);
    }

    public DBRow queryByPK(Object pk, Connection connection, DatabaseDialect dialect) throws SQLException {
        Object[] objectArray;
        String[] pkColumnNames = this.getPrimaryKeyConstraint().getColumnNames();
        if (pkColumnNames.length == 0) {
            throw new ObjectNotFoundException("Table " + this.name + " has no primary key");
        }
        if (pk.getClass().isArray()) {
            objectArray = (Object[])pk;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = pk;
        }
        Object[] pkComponents = objectArray;
        String whereClause = SQLUtil.renderWhereClause(pkColumnNames, pkComponents, dialect);
        DBRowIterator iterator = new DBRowIterator(this, connection, whereClause);
        if (!iterator.hasNext()) {
            throw new ObjectNotFoundException("No " + this.name + " row with id (" + pkComponents + ")");
        }
        DBRow result = iterator.next();
        iterator.close();
        return result;
    }

    public HeavyweightIterator<Object> queryPKValues(Connection connection) {
        StringBuilder query = new StringBuilder("select ");
        query.append(ArrayFormat.format((Object[])this.getPKColumnNames()));
        query.append(" from ").append(this.name);
        QueryIterator rawIterator = new QueryIterator(query.toString(), connection, 100);
        ResultSetConverter<Object> converter = new ResultSetConverter<Object>(Object.class, true);
        return new ConvertingIterator((Iterator)((Object)rawIterator), converter);
    }

    public TabularIterator query(String query, Connection connection) {
        Assert.notEmpty((String)query, (String)"query");
        return new ArrayResultSetIterator(connection, query);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.hashCode((Object[])new Object[]{this.owner, this.name});
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBTable)) {
            return false;
        }
        DBTable that = (DBTable)other;
        if (!NullSafeComparator.equals((Object)this.owner, (Object)that.getSchema())) {
            return false;
        }
        return NullSafeComparator.equals((Object)this.name, (Object)that.getName());
    }

    class RefReceiver
    implements JDBCDBImporter.ReferrerReceiver {
        RefReceiver() {
        }

        public void receiveReferrer(String fktable_name, DBTable table) {
            DBTable referrer = DBTable.this.getSchema().getCatalog().getTable(fktable_name);
            table.addReferrer(referrer);
        }
    }

    class FKRec
    implements JDBCDBImporter.FKReceiver {
        FKRec() {
        }

        public void receiveFK(DBForeignKeyConstraint fk, DBTable table) {
            DBTable.this.foreignKeyConstraints.add((Object)fk);
            fk.setTable(table);
        }
    }

    class IdxReceiver
    implements JDBCDBImporter.IndexReceiver {
        IdxReceiver() {
        }

        public void receiveIndex(DBIndexInfo indexInfo, boolean deterministicName, DBTable table, DBSchema schema) {
            DBIndex index = null;
            if (indexInfo.unique) {
                DBUniqueConstraint constraint;
                boolean isPK;
                DBPrimaryKeyConstraint pk = table.getPrimaryKeyConstraint();
                boolean bl = isPK = pk != null && StringUtil.equalsIgnoreCase((String[])indexInfo.columnNames, (String[])pk.getColumnNames());
                if (isPK) {
                    constraint = pk;
                } else {
                    constraint = new DBUniqueConstraint(table, indexInfo.name, deterministicName, indexInfo.columnNames);
                    table.addUniqueConstraint(constraint);
                }
                index = new DBUniqueIndex(indexInfo.name, deterministicName, constraint);
                table.addIndex(index);
            } else {
                index = new DBNonUniqueIndex(indexInfo.name, deterministicName, table, indexInfo.columnNames);
                table.addIndex(index);
            }
        }
    }

    class PKRec
    implements JDBCDBImporter.PKReceiver {
        PKRec() {
        }

        public void receivePK(String pkName, boolean deterministicName, String[] columnNames, DBTable table) {
            DBPrimaryKeyConstraint pk = new DBPrimaryKeyConstraint(null, pkName, deterministicName, columnNames);
            DBTable.this.pk = pk;
            pk.setTable(DBTable.this);
            for (String columnName : columnNames) {
                DBColumn column = table.getColumn(columnName);
                column.addUkConstraint(pk);
            }
        }
    }

    class ColReceiver
    implements JDBCDBImporter.ColumnReceiver {
        ColReceiver() {
        }

        public void receiveColumn(String columnName, DBDataType dataType, Integer columnSize, Integer fractionDigits, boolean nullable, String defaultValue, String comment, DBTable table) {
            DBColumn column = new DBColumn(columnName, null, dataType, columnSize, fractionDigits);
            column.setTable(DBTable.this);
            DBTable.this.columns.put(column.getName(), (Object)column);
            column.setDoc(comment);
            column.setNullable(nullable);
        }
    }
}

