/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.Arrays;
import org.databene.commons.ArrayUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.jdbacl.NameSpec;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.DBConstraint;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.MultiColumnObject;

public class DBUniqueConstraint
extends DBConstraint
implements MultiColumnObject {
    private static final long serialVersionUID = -8241121848879185421L;
    private String[] columnNames;

    public DBUniqueConstraint(DBTable owner, String name, boolean nameDeterministic, String ... columnNames) {
        super(name, nameDeterministic, "unique constraint", owner);
        this.columnNames = columnNames;
        if (this.getClass() == DBUniqueConstraint.class) {
            owner.addUniqueConstraint(this);
        }
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public void addColumnName(String columnName) {
        if (!ArrayUtil.contains((Object)columnName, (Object)this.columnNames)) {
            this.columnNames = (String[])ArrayUtil.append((Object)columnName, (Object[])this.columnNames);
        }
    }

    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBUniqueConstraint)) {
            return false;
        }
        DBUniqueConstraint that = (DBUniqueConstraint)other;
        return NullSafeComparator.equals((Object)this.name, (Object)that.name) && Arrays.equals(this.columnNames, that.columnNames) && NullSafeComparator.equals((Object)this.getTable().getName(), (Object)that.getTable().getName());
    }

    public String toString() {
        return SQLUtil.ukSpec(this, NameSpec.ALWAYS);
    }
}

