/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.jdbc;

import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;

public class DBIndexInfo {
    public String name;
    public String tableName;
    public boolean unique;
    public String catalogName;
    public short type;
    public Boolean ascending;
    public int cardinality;
    public int pages;
    public String filterCondition;
    public String[] columnNames;

    public DBIndexInfo(String name, String tableName, short type, String catalogName, boolean unique, short ordinalPosition, String columnName, Boolean ascending, int cardinality, int pages, String filterCondition) {
        this.name = name;
        this.tableName = tableName;
        this.unique = unique;
        this.catalogName = catalogName;
        this.type = type;
        this.ascending = ascending;
        this.cardinality = cardinality;
        this.pages = pages;
        this.filterCondition = filterCondition;
        this.columnNames = new String[]{columnName};
        if (ordinalPosition != 1) {
            throw new IllegalArgumentException("ordinalPosition is expected to be 1, found: " + ordinalPosition);
        }
    }

    public void addColumn(short ordinalPosition, String columnName) {
        int expectedPosition = this.columnNames.length + 1;
        if (ordinalPosition == expectedPosition) {
            this.columnNames = (String[])ArrayUtil.append((Object)columnName, (Object[])this.columnNames);
        } else if (ordinalPosition > expectedPosition || !this.columnNames[ordinalPosition - 1].equals(columnName)) {
            throw new IllegalArgumentException("ordinalPosition is expected to be " + expectedPosition + ", " + "found: " + ordinalPosition);
        }
    }

    public String toString() {
        return "[" + ArrayFormat.format((Object[])this.columnNames) + "]";
    }
}

