/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.jdbc;

import java.sql.Connection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.ImportFailedException;
import org.databene.jdbacl.model.DBMetaDataImporter;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.cache.CachingDBImporter;
import org.databene.jdbacl.model.jdbc.JDBCDBImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCMetaDataUtil {
    public static Future<Database> getFutureMetaData(String environment, boolean importUKs, boolean importIndexes, boolean importSequences, boolean importChecks, String tableInclusionPattern, String tableExclusionPattern, boolean lazy, boolean cached) throws ConnectFailedException, ImportFailedException {
        final DBMetaDataImporter importer = JDBCMetaDataUtil.getJDBCDBImporter(environment, importUKs, importIndexes, importSequences, importChecks, tableInclusionPattern, tableExclusionPattern, cached);
        Callable<Database> callable = new Callable<Database>(){

            @Override
            public Database call() throws Exception {
                return importer.importDatabase();
            }
        };
        return Executors.newSingleThreadExecutor().submit(callable);
    }

    public static Database getMetaData(String environment, boolean importUKs, boolean importIndexes, boolean importSequences, boolean importChecks, String tableInclusionPattern, String tableExclusionPattern, boolean lazy, boolean cached) throws ConnectFailedException, ImportFailedException {
        DBMetaDataImporter importer = JDBCMetaDataUtil.getJDBCDBImporter(environment, importUKs, importIndexes, importSequences, importChecks, tableInclusionPattern, tableExclusionPattern, cached);
        return importer.importDatabase();
    }

    public static DBMetaDataImporter getJDBCDBImporter(String environment, boolean importUKs, boolean importIndexes, boolean importSequences, boolean importChecks, String tableInclusionPattern, String tableExclusionPattern, boolean cached) {
        JDBCDBImporter dbImporter = new JDBCDBImporter(environment);
        dbImporter.setTableInclusionPattern(tableInclusionPattern);
        dbImporter.setTableExclusionPattern(tableExclusionPattern);
        DBMetaDataImporter importer = dbImporter;
        if (cached) {
            importer = new CachingDBImporter((JDBCDBImporter)importer, environment);
        }
        return importer;
    }

    public static Database getMetaData(Connection target, String user, String schema) throws ConnectFailedException, ImportFailedException {
        return JDBCMetaDataUtil.getMetaData(target, user, schema, true, true, true, true, ".*", null);
    }

    public static Database getMetaData(Connection connection, String user, String schemaName, boolean importUKs, boolean importIndexes, boolean importSequences, boolean importChecks, String tableInclusionPattern, String tableExclusionPattern) throws ConnectFailedException, ImportFailedException {
        JDBCDBImporter importer = JDBCMetaDataUtil.getJDBCDBImporter(connection, user, schemaName, importUKs, importIndexes, importSequences, importChecks, tableInclusionPattern, tableExclusionPattern);
        return importer.importDatabase();
    }

    public static JDBCDBImporter getJDBCDBImporter(Connection connection, String user, String schemaName, boolean importUKs, boolean importIndexes, boolean importSequences, boolean importChecks, String tableInclusionPattern, String tableExclusionPattern) {
        JDBCDBImporter importer = new JDBCDBImporter(connection, user, schemaName);
        importer.setTableInclusionPattern(tableInclusionPattern);
        importer.setTableExclusionPattern(tableExclusionPattern);
        return importer;
    }
}

