/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.ArrayConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.debug.Debug;
import org.databene.commons.debug.ResourceMonitor;
import org.databene.jdbacl.DBUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPreparedStatementHandler
implements InvocationHandler {
    private static final Logger SQL_LOGGER = LoggerFactory.getLogger((String)"org.databene.SQL");
    private static final Logger JDBC_LOGGER = LoggerFactory.getLogger((String)"org.databene.JDBC");
    private static volatile AtomicInteger openStatementCount = new AtomicInteger();
    private static ResourceMonitor openStatementMonitor;
    private static final Converter<Object[], String[]> toStringArrayConverter;
    private boolean closed;
    private String sql;
    private PreparedStatement realStatement;
    Object[] params;

    public LoggingPreparedStatementHandler(PreparedStatement realStatement, String sql) {
        this.sql = sql;
        this.realStatement = realStatement;
        this.closed = false;
        int paramCount = StringUtil.countChars((String)sql, (char)'?');
        this.params = new Object[paramCount];
        openStatementCount.incrementAndGet();
        if (openStatementMonitor != null) {
            openStatementMonitor.register((Object)this);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            Method localMethod = BeanUtil.findMethod(this.getClass(), (String)methodName, (Class[])method.getParameterTypes());
            if (localMethod != null) {
                return BeanUtil.invoke((Object)this, (Method)localMethod, (Object[])args);
            }
            if ("setNull".equals(methodName) && args != null && args.length >= 2) {
                this.params[((Integer)args[0]).intValue() - 1] = null;
            } else if (methodName.startsWith("set") && args != null && args.length >= 2 && args[0] instanceof Integer) {
                this.params[((Integer)args[0]).intValue() - 1] = args[1];
            }
            Object result = BeanUtil.invoke((Object)this.realStatement, (Method)method, (Object[])args);
            if (result instanceof ResultSet) {
                result = DBUtil.createLoggingResultSet((ResultSet)result, (PreparedStatement)proxy);
            }
            return result;
        }
        catch (ConfigurationError e) {
            if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof SQLException) {
                throw e.getCause().getCause();
            }
            throw e;
        }
    }

    public void addBatch() throws SQLException {
        this.logAll("addBatch", this.sql);
        this.realStatement.addBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this.logAll("addBatch", sql);
        this.realStatement.addBatch(sql);
    }

    public boolean execute() throws SQLException {
        this.logAll("execute", this.sql);
        this.clearParams();
        return this.realStatement.execute();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.logAll("execute", sql);
        return this.realStatement.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.logAll("execute", sql);
        return this.realStatement.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.logAll("execute", sql);
        return this.realStatement.execute(sql, columnNames);
    }

    public boolean execute(String sql) throws SQLException {
        this.logAll("execute", sql);
        return this.realStatement.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        JDBC_LOGGER.debug("executeBatch()");
        this.clearParams();
        return this.realStatement.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        this.logAll("executeQuery", this.sql);
        this.clearParams();
        return this.realStatement.executeQuery();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.logAll("executeQuery", sql);
        this.clearParams();
        return this.realStatement.executeQuery(sql);
    }

    public int executeUpdate() throws SQLException {
        this.logAll("executeUpdate", this.sql);
        this.clearParams();
        return this.realStatement.executeUpdate();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.logAll("executeUpdate", sql);
        return this.realStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.logAll("executeUpdate", sql);
        return this.realStatement.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.logAll("executeUpdate", sql);
        return this.realStatement.executeUpdate(sql, columnNames);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.logAll("executeUpdate", sql);
        return this.realStatement.executeUpdate(sql);
    }

    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.logAll("close", this.sql);
        this.closed = true;
        this.realStatement.close();
        openStatementCount.decrementAndGet();
        if (openStatementMonitor != null) {
            openStatementMonitor.unregister((Object)this);
        }
    }

    public static int getOpenStatementCount() {
        return openStatementCount.get();
    }

    public static void resetMonitors() {
        openStatementCount.set(0);
        if (openStatementMonitor != null) {
            openStatementMonitor.reset();
        }
    }

    public static boolean assertAllStatementsClosed(boolean critical) {
        return openStatementMonitor.assertNoRegistrations(critical);
    }

    private void clearParams() {
        this.params = new Object[this.params.length];
    }

    private void logAll(String method, String sql) {
        if (JDBC_LOGGER.isDebugEnabled()) {
            JDBC_LOGGER.debug(method + ": " + sql);
        }
        SQL_LOGGER.debug("{}", (Object)this);
    }

    public String toString() {
        String[] paramStrings = (String[])toStringArrayConverter.convert((Object)this.params);
        return "PreparedStatement (" + StringUtil.replaceTokens((String)this.sql, (String)"?", (String[])paramStrings) + ")";
    }

    static {
        if (Debug.active()) {
            openStatementMonitor = new ResourceMonitor();
        }
        ToStringConverter toStringConverter = new ToStringConverter("null");
        toStringConverter.setCharQuote("'");
        toStringConverter.setStringQuote("'");
        toStringArrayConverter = new ArrayConverter(Object.class, String.class, new Converter[]{toStringConverter});
    }
}

