/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.debug.Debug;
import org.databene.commons.debug.ResourceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingResultSetHandler
implements InvocationHandler {
    private static final Logger JDBC_LOGGER = LoggerFactory.getLogger((String)"org.databene.JDBC");
    private static volatile AtomicInteger openResultSetCount = new AtomicInteger();
    private static ResourceMonitor openResultSetMonitor;
    private ResultSet realResultSet;
    private Statement statement;

    public LoggingResultSetHandler(ResultSet realResultSet, Statement statement) {
        this.realResultSet = realResultSet;
        this.statement = statement;
        openResultSetCount.incrementAndGet();
        if (openResultSetMonitor != null) {
            openResultSetMonitor.register((Object)this);
        }
        JDBC_LOGGER.debug("created result set {}", (Object)this);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            if ("close".equals(methodName)) {
                openResultSetCount.decrementAndGet();
                if (openResultSetMonitor != null) {
                    openResultSetMonitor.unregister((Object)this);
                }
                JDBC_LOGGER.debug("closing result set {}", (Object)this);
            } else {
                if ("toString".equals(methodName)) {
                    return "ResultSet (" + this.statement + ")";
                }
                if ("getStatement".equals(methodName)) {
                    return this.statement;
                }
            }
            return BeanUtil.invoke((Object)this.realResultSet, (Method)method, (Object[])args);
        }
        catch (ConfigurationError e) {
            if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof SQLException) {
                throw e.getCause().getCause();
            }
            throw e;
        }
    }

    public static int getOpenResultSetCount() {
        return openResultSetCount.get();
    }

    public static void resetMonitors() {
        openResultSetCount.set(0);
        if (openResultSetMonitor != null) {
            openResultSetMonitor.reset();
        }
    }

    public static boolean assertAllResultSetsClosed(boolean critical) {
        return openResultSetMonitor.assertNoRegistrations(critical);
    }

    static {
        if (Debug.active()) {
            openResultSetMonitor = new ResourceMonitor();
        }
    }
}

