/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.ConnectionEventListener;
import org.databene.commons.BeanUtil;
import org.databene.commons.debug.Debug;
import org.databene.commons.debug.ResourceMonitor;
import org.databene.jdbacl.DBUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionHandler
implements InvocationHandler {
    private static final Logger jdbcLogger = LoggerFactory.getLogger((String)"org.databene.JDBC");
    private static long nextId = 0L;
    private static volatile AtomicInteger openConnectionCount = new AtomicInteger();
    private static ResourceMonitor openConnectionMonitor;
    private boolean readOnly;
    private Connection realConnection;
    private long id;
    private boolean closed;
    private List<ConnectionEventListener> listeners;

    public PooledConnectionHandler(Connection realConnection, boolean readOnly) {
        this.readOnly = readOnly;
        this.id = PooledConnectionHandler.nextId();
        this.realConnection = realConnection;
        this.listeners = new ArrayList<ConnectionEventListener>();
        this.closed = false;
        if (jdbcLogger.isDebugEnabled()) {
            jdbcLogger.debug("Created connection #" + this.id + ": " + realConnection);
        }
        openConnectionCount.incrementAndGet();
        if (openConnectionMonitor != null) {
            openConnectionMonitor.register((Object)this);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("close".equals(methodName)) {
            this.close();
        } else {
            if ("getConnection".equals(methodName) && (args == null || args.length == 0)) {
                return this.getConnection();
            }
            if ("addConnectionEventListener".equals(methodName)) {
                this.addConnectionEventListener((ConnectionEventListener)args[0]);
                return null;
            }
            if ("removeConnectionEventListener".equals(methodName)) {
                this.removeConnectionEventListener((ConnectionEventListener)args[0]);
                return null;
            }
            if ("prepareStatement".equals(methodName)) {
                switch (args.length) {
                    case 1: {
                        return DBUtil.prepareStatement(this.realConnection, (String)args[0], this.readOnly);
                    }
                    case 2: {
                        if (method.getParameterTypes()[1] != Integer.TYPE) break;
                        return DBUtil.prepareStatement(this.realConnection, (String)args[0], this.readOnly, (Integer)args[1], 1007, 1);
                    }
                    case 3: {
                        return DBUtil.prepareStatement(this.realConnection, (String)args[0], this.readOnly, (Integer)args[1], (Integer)args[2], 1);
                    }
                    case 4: {
                        return DBUtil.prepareStatement(this.realConnection, (String)args[0], this.readOnly, (Integer)args[1], (Integer)args[2], (Integer)args[3]);
                    }
                }
            } else if ("createStatement".equals(methodName)) {
                return this.createStatement(method, args);
            }
        }
        return BeanUtil.invoke((Object)this.realConnection, (Method)method, (Object[])args);
    }

    private Statement createStatement(Method method, Object[] args) {
        Statement statement = (Statement)BeanUtil.invoke((Object)this.realConnection, (Method)method, (Object[])args);
        return DBUtil.createLoggingStatementHandler(statement, this.readOnly);
    }

    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            this.realConnection.close();
            this.listeners.clear();
            openConnectionCount.decrementAndGet();
            if (openConnectionMonitor != null) {
                openConnectionMonitor.unregister((Object)this);
            }
            this.closed = true;
            if (jdbcLogger.isDebugEnabled()) {
                jdbcLogger.debug("Closed connection #" + this.id + ": " + this.realConnection);
            }
        }
        catch (SQLException e) {
            jdbcLogger.error("Error closing connection #" + this.id + ": " + this.realConnection, (Throwable)e);
            throw e;
        }
    }

    public Connection getConnection() {
        return this.realConnection;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public static int getOpenConnectionCount() {
        return openConnectionCount.get();
    }

    public static void resetMonitors() {
        openConnectionCount.set(0);
        if (openConnectionMonitor != null) {
            openConnectionMonitor.reset();
        }
    }

    public static boolean assertAllConnectionsClosed(boolean critical) {
        return openConnectionMonitor.assertNoRegistrations(critical);
    }

    private static synchronized long nextId() {
        return ++nextId;
    }

    static {
        if (Debug.active()) {
            openConnectionMonitor = new ResourceMonitor();
        }
    }
}

