/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.sql;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.CollectionUtil;

public class Query {
    private List<String> selectConditions = new ArrayList<String>();
    private List<String> selections;
    private List<String> tablesWithAliases;
    private StringBuilder whereClause;
    private List<String> options;

    public Query(String selection, String table) {
        this(selection, table, null);
    }

    public Query(String selection, String table, String whereClause) {
        this.selections = CollectionUtil.toList((Object[])new String[]{selection});
        this.tablesWithAliases = new ArrayList<String>();
        if (table != null) {
            this.tablesWithAliases.add(table);
        }
        this.whereClause = new StringBuilder();
        if (whereClause != null) {
            this.whereClause.append(whereClause);
        }
        this.options = new ArrayList<String>();
    }

    public static Query select(String selection) {
        return new Query(selection, null);
    }

    public void addSelectCondition(String selectCondition) {
        this.selectConditions.add(selectCondition);
    }

    public Query from(String tableName) {
        this.tablesWithAliases.add(tableName);
        return this;
    }

    public Query where(String where) {
        if (this.whereClause.length() > 0) {
            throw new IllegalArgumentException("Tried to set where clause to '" + where + "' " + "but there already exists one: " + this.whereClause);
        }
        this.whereClause.append(where);
        return this;
    }

    public Query and(String condition) {
        if (this.whereClause.length() > 0) {
            this.whereClause.append(" AND ");
        }
        this.whereClause.append(condition);
        return this;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder("SELECT ");
        for (String selectCondition : this.selectConditions) {
            builder.append(selectCondition).append(' ');
        }
        for (i = 0; i < this.selections.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.selections.get(i));
        }
        builder.append(" FROM ");
        for (i = 0; i < this.tablesWithAliases.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.tablesWithAliases.get(i));
        }
        if (this.whereClause.length() > 0) {
            builder.append(" WHERE ").append((CharSequence)this.whereClause);
        }
        for (String option : this.options) {
            builder.append(' ').append(option);
        }
        return builder.toString();
    }
}

