/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.sql;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ParseException;
import org.databene.commons.StringUtil;
import org.databene.commons.SyntaxError;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.model.DBColumn;
import org.databene.jdbacl.model.DBDataType;
import org.databene.jdbacl.model.DBPrimaryKeyConstraint;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.sql.BetweenExpression;
import org.databene.jdbacl.sql.ColumnExpression;
import org.databene.jdbacl.sql.FunctionInvocation;
import org.databene.jdbacl.sql.LikeExpression;
import org.databene.jdbacl.sql.parser.SQLLexer;
import org.databene.jdbacl.sql.parser.SQLParser;
import org.databene.jdbacl.sql.parser.TextHolder;
import org.databene.script.Expression;
import org.databene.script.expression.ConcatExpression;
import org.databene.script.expression.ConditionalAndExpression;
import org.databene.script.expression.ConditionalOrExpression;
import org.databene.script.expression.DivisionExpression;
import org.databene.script.expression.EqualsExpression;
import org.databene.script.expression.ExclusiveOrExpression;
import org.databene.script.expression.ExpressionUtil;
import org.databene.script.expression.GreaterExpression;
import org.databene.script.expression.GreaterOrEqualsExpression;
import org.databene.script.expression.LessExpression;
import org.databene.script.expression.LessOrEqualsExpression;
import org.databene.script.expression.LogicalComplementExpression;
import org.databene.script.expression.ModuloExpression;
import org.databene.script.expression.MultiplicationExpression;
import org.databene.script.expression.NotEqualsExpression;
import org.databene.script.expression.NullExpression;
import org.databene.script.expression.SubtractionExpression;
import org.databene.script.expression.SumExpression;
import org.databene.script.expression.UnaryMinusExpression;
import org.databene.script.expression.ValueCollectionContainsExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLParserUtil {
    static final Logger LOGGER = LoggerFactory.getLogger(SQLParserUtil.class);

    public static Object parse(CharStream in, DatabaseDialect dialect) throws ParseException {
        String text = null;
        if (in instanceof TextHolder) {
            text = ((TextHolder)in).getText();
        }
        try {
            SQLParser parser = SQLParserUtil.parser(in);
            SQLParser.commands_return r = parser.commands();
            SQLParserUtil.checkForSyntaxErrors(text, "weightedLiteralList", parser, r);
            if (r != null) {
                return SQLParserUtil.convertNode((CommonTree)r.getTree(), dialect);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw SQLParserUtil.mapToParseException((RecognitionException)e.getCause(), text);
            }
            throw e;
        }
        catch (RecognitionException e) {
            throw SQLParserUtil.mapToParseException(e, text);
        }
    }

    public static Expression<?> parseExpression(CharStream in) throws ParseException {
        String text = null;
        if (in instanceof TextHolder) {
            text = ((TextHolder)in).getText();
        }
        try {
            SQLParser parser = SQLParserUtil.parser(in);
            SQLParser.expression_return r = parser.expression();
            SQLParserUtil.checkForSyntaxErrors(text, "expression", parser, r);
            if (r != null) {
                return SQLParserUtil.convertExpressionNode((CommonTree)r.getTree());
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw SQLParserUtil.mapToParseException((RecognitionException)e.getCause(), text);
            }
            throw e;
        }
        catch (RecognitionException e) {
            throw SQLParserUtil.mapToParseException(e, text);
        }
    }

    private static Object convertNode(CommonTree node, DatabaseDialect dialect) {
        switch (node.getType()) {
            case 12: {
                return SQLParserUtil.convertCreateTable(node, dialect);
            }
            case 13: {
                return SQLParserUtil.convertDropTable(node);
            }
            case 14: {
                return SQLParserUtil.convertAlterTable(node);
            }
            case 18: {
                return SQLParserUtil.convertCreateSequence(node);
            }
            case 19: {
                return SQLParserUtil.convertDropSequence(node);
            }
            case 21: {
                return SQLParserUtil.convertCreateIndex(node);
            }
            case 26: {
                return SQLParserUtil.convertTableComment(node);
            }
            case 27: {
                return SQLParserUtil.convertColumnComment(node);
            }
        }
        if (node.isNil()) {
            List<Object> nodes = SQLParserUtil.convertNodes(SQLParserUtil.getChildNodes(node), dialect);
            return nodes.toArray();
        }
        throw new ParseException("Unknown token type", "'" + node.getText() + "'");
    }

    private static Expression convertExpressionNode(CommonTree node) {
        switch (node.getType()) {
            case 31: {
                return SQLParserUtil.convertOr(node);
            }
            case 32: {
                return SQLParserUtil.convertAnd(node);
            }
            case 33: {
                return SQLParserUtil.convertXor(node);
            }
            case 34: {
                return SQLParserUtil.convertEq(node);
            }
            case 35: {
                return SQLParserUtil.convertBangEq(node);
            }
            case 36: {
                return SQLParserUtil.convertBangEq(node);
            }
            case 37: {
                return SQLParserUtil.convertGt(node);
            }
            case 38: {
                return SQLParserUtil.convertGe(node);
            }
            case 39: {
                return SQLParserUtil.convertLt(node);
            }
            case 40: {
                return SQLParserUtil.convertLe(node);
            }
            case 42: {
                return SQLParserUtil.convertIs(node);
            }
            case 5: {
                return SQLParserUtil.convertNot(node);
            }
            case 43: {
                return SQLParserUtil.convertNull(node);
            }
            case 41: {
                return SQLParserUtil.convertLike(node);
            }
            case 44: {
                return SQLParserUtil.convertIn(node);
            }
            case 45: {
                return SQLParserUtil.convertBetween(node);
            }
            case 46: {
                return SQLParserUtil.convertPlus(node);
            }
            case 47: {
                return SQLParserUtil.convertSub(node);
            }
            case 48: {
                return SQLParserUtil.convertStar(node);
            }
            case 49: {
                return SQLParserUtil.convertSlash(node);
            }
            case 50: {
                return SQLParserUtil.convertPercent(node);
            }
            case 51: {
                return SQLParserUtil.convertBarBar(node);
            }
            case 28: {
                return SQLParserUtil.convertInvocation(node);
            }
            case 8: {
                return SQLParserUtil.convertQuotedName(node);
            }
            case 6: {
                return SQLParserUtil.convertIdentifier(node);
            }
            case 7: {
                return SQLParserUtil.convertStringToExpression(node);
            }
            case 4: {
                return SQLParserUtil.convertInt(node);
            }
        }
        throw new ParseException("Unknown token type (" + node.getType() + ")", "'" + node.getText() + "'");
    }

    private static Expression<Boolean> convertOr(CommonTree node) {
        ConditionalOrExpression result = new ConditionalOrExpression("OR", new Expression[0]);
        for (CommonTree childNode : SQLParserUtil.getChildNodes(node)) {
            result.addTerm(SQLParserUtil.convertExpressionNode(childNode));
        }
        return result;
    }

    private static Expression<Boolean> convertAnd(CommonTree node) {
        ConditionalAndExpression result = new ConditionalAndExpression("AND", new Expression[0]);
        for (CommonTree childNode : SQLParserUtil.getChildNodes(node)) {
            result.addTerm(SQLParserUtil.convertExpressionNode(childNode));
        }
        return result;
    }

    private static Expression<Boolean> convertXor(CommonTree node) {
        return new ExclusiveOrExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)));
    }

    private static Expression<Boolean> convertEq(CommonTree node) {
        return new EqualsExpression("=", SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)));
    }

    private static Expression<Boolean> convertBangEq(CommonTree node) {
        return new NotEqualsExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)));
    }

    private static Expression<Boolean> convertGt(CommonTree node) {
        return new GreaterExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)));
    }

    private static Expression<Boolean> convertGe(CommonTree node) {
        return new GreaterOrEqualsExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)));
    }

    private static Expression<Boolean> convertLt(CommonTree node) {
        return new LessExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)));
    }

    private static Expression<Boolean> convertLe(CommonTree node) {
        return new LessOrEqualsExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)));
    }

    private static Expression<Boolean> convertIs(CommonTree node) {
        if (node.getChildCount() > 1) {
            return new NotEqualsExpression("IS NOT", SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), (Expression)new NullExpression());
        }
        return new EqualsExpression("IS", SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), (Expression)new NullExpression());
    }

    private static Expression<?> convertNot(CommonTree node) {
        return new LogicalComplementExpression("NOT ", SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)));
    }

    private static Expression<?> convertNull(CommonTree node) {
        return new NullExpression();
    }

    private static Expression<?> convertLike(CommonTree node) {
        Expression valueEx = SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node));
        CommonTree child1 = SQLParserUtil.childAt(1, node);
        boolean not = child1.getType() == 5;
        int collectionIndex = not ? 2 : 1;
        Expression refEx = SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(collectionIndex, node));
        LikeExpression result = new LikeExpression(valueEx, refEx);
        if (not) {
            result = new LogicalComplementExpression((Expression)result);
        }
        return result;
    }

    private static Expression<?> convertIn(CommonTree node) {
        Expression valueEx = SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node));
        CommonTree child1 = SQLParserUtil.childAt(1, node);
        boolean not = child1.getType() == 5;
        int collectionIndex = not ? 2 : 1;
        Expression<? extends Collection<?>> collEx = SQLParserUtil.convertValueList(SQLParserUtil.childAt(collectionIndex, node));
        ValueCollectionContainsExpression result = new ValueCollectionContainsExpression("IN", valueEx, collEx);
        if (not) {
            result = new LogicalComplementExpression((Expression)result);
        }
        return result;
    }

    private static Expression<? extends Collection<?>> convertValueList(CommonTree node) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (CommonTree child : SQLParserUtil.getChildNodes(node)) {
            result.add(SQLParserUtil.convertExpressionNode(child));
        }
        return ExpressionUtil.constant(result);
    }

    private static Expression<?> convertBetween(CommonTree node) {
        return new BetweenExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(2, node)));
    }

    private static Expression<?> convertPlus(CommonTree node) {
        SumExpression result = new SumExpression();
        for (CommonTree child : SQLParserUtil.getChildNodes(node)) {
            result.addTerm(SQLParserUtil.convertExpressionNode(child));
        }
        return result;
    }

    private static Expression<?> convertSub(CommonTree node) {
        if (node.getChildCount() == 1) {
            return new UnaryMinusExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)));
        }
        SubtractionExpression result = new SubtractionExpression();
        for (CommonTree child : SQLParserUtil.getChildNodes(node)) {
            result.addTerm(SQLParserUtil.convertExpressionNode(child));
        }
        return result;
    }

    private static Expression<?> convertStar(CommonTree node) {
        MultiplicationExpression result = new MultiplicationExpression();
        for (CommonTree child : SQLParserUtil.getChildNodes(node)) {
            result.addTerm(SQLParserUtil.convertExpressionNode(child));
        }
        return result;
    }

    private static Expression<?> convertSlash(CommonTree node) {
        DivisionExpression result = new DivisionExpression();
        for (CommonTree child : SQLParserUtil.getChildNodes(node)) {
            result.addTerm(SQLParserUtil.convertExpressionNode(child));
        }
        return result;
    }

    private static Expression<?> convertPercent(CommonTree node) {
        return new ModuloExpression(SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node)));
    }

    private static Expression<String> convertBarBar(CommonTree node) {
        return new ConcatExpression("||", new Expression[]{SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(0, node)), SQLParserUtil.convertExpressionNode(SQLParserUtil.childAt(1, node))});
    }

    private static Expression<?> convertInvocation(CommonTree node) {
        String functionName = (String)SQLParserUtil.convertIdentifier(SQLParserUtil.childAt(0, node)).evaluate(null);
        Expression<?>[] arguments = SQLParserUtil.convertArguments(SQLParserUtil.childAt(1, node));
        return new FunctionInvocation(functionName, arguments);
    }

    private static Expression<?>[] convertArguments(CommonTree node) {
        ArrayBuilder result = new ArrayBuilder(Expression.class);
        for (CommonTree child : SQLParserUtil.getChildNodes(node)) {
            result.add((Object)SQLParserUtil.convertExpressionNode(child));
        }
        return (Expression[])result.toArray();
    }

    private static Expression<String> convertIdentifier(CommonTree node) {
        return new ColumnExpression(node.getText(), false);
    }

    private static Expression<String> convertQuotedName(CommonTree node) {
        String quotedColName = node.getText().trim();
        String colName = quotedColName.substring(1, quotedColName.length() - 1);
        return new ColumnExpression(colName, true);
    }

    private static Expression<?> convertStringToExpression(CommonTree node) {
        return ExpressionUtil.constant((Object)node.getText());
    }

    private static Expression<?> convertInt(CommonTree node) {
        return ExpressionUtil.constant((Object)new BigInteger(node.getText()));
    }

    private static Object convertTableComment(CommonTree node) {
        return null;
    }

    private static Object convertColumnComment(CommonTree node) {
        return null;
    }

    private static Object convertAlterTable(CommonTree node) {
        return null;
    }

    private static Object convertDropTable(CommonTree node) {
        return null;
    }

    private static Object convertCreateSequence(CommonTree node) {
        return null;
    }

    private static Object convertCreateIndex(CommonTree node) {
        return null;
    }

    private static Object convertDropSequence(CommonTree node) {
        return null;
    }

    private static List<Object> convertNodes(List<CommonTree> nodes, DatabaseDialect dialect) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (CommonTree node : nodes) {
            result.add(SQLParserUtil.convertNode(node, dialect));
        }
        return result;
    }

    private static DBTable convertCreateTable(CommonTree node, DatabaseDialect dialect) {
        String tableName = SQLParserUtil.convertString(SQLParserUtil.childAt(0, node));
        DBTable table = new DBTable(tableName);
        SQLParserUtil.convertTableDetails(SQLParserUtil.childAt(1, node), table, dialect);
        return table;
    }

    private static void convertTableDetails(CommonTree node, DBTable table, DatabaseDialect dialect) {
        for (CommonTree subNode : SQLParserUtil.getChildNodes(node)) {
            SQLParserUtil.convertTableDetail(subNode, table, dialect);
        }
    }

    private static void convertTableDetail(CommonTree node, DBTable table, DatabaseDialect dialect) {
        switch (node.getType()) {
            case 24: {
                SQLParserUtil.convertColumnSpec(node, table);
                break;
            }
            case 9: {
                SQLParserUtil.convertInlinePK(node, table, dialect);
                break;
            }
            default: {
                throw new ParseException("Unknown table detail token type", String.valueOf(node.getText()), node.getLine(), node.getCharPositionInLine());
            }
        }
    }

    private static void convertInlinePK(CommonTree node, DBTable table, DatabaseDialect dialect) {
        String constraintName = SQLParserUtil.convertString(SQLParserUtil.childAt(0, node));
        String[] pkColumnNames = SQLParserUtil.convertNameList(SQLParserUtil.childAt(1, node));
        DBPrimaryKeyConstraint pk = new DBPrimaryKeyConstraint(table, constraintName, dialect.isDeterministicPKName(constraintName), pkColumnNames);
        table.setPrimaryKey(pk);
    }

    private static String[] convertNameList(CommonTree node) {
        String[] result = new String[node.getChildCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SQLParserUtil.convertString(SQLParserUtil.childAt(i, node));
        }
        return result;
    }

    private static void convertColumnSpec(CommonTree node, DBTable table) {
        String columnName = SQLParserUtil.convertString(SQLParserUtil.childAt(0, node));
        Integer size = null;
        Integer fractionDigits = null;
        int detailOffset = 2;
        String columnTypeName = SQLParserUtil.convertString(SQLParserUtil.childAt(1, node));
        if (node.getChildCount() > 2 && SQLParserUtil.childAt(2, node).getType() == 17) {
            CommonTree subNode2;
            ++detailOffset;
            CommonTree sizeNode = SQLParserUtil.childAt(2, node);
            size = SQLParserUtil.convertInteger(SQLParserUtil.childAt(0, sizeNode));
            if (sizeNode.getChildCount() > 1 && (subNode2 = SQLParserUtil.childAt(1, sizeNode)).getType() == 4) {
                fractionDigits = SQLParserUtil.convertInteger(subNode2);
            }
        }
        DBColumn column = new DBColumn(columnName, table, DBDataType.getInstance(columnTypeName), size, fractionDigits);
        table.addColumn(column);
        for (int i = detailOffset; i < node.getChildCount(); ++i) {
            SQLParserUtil.convertColumnDetail(SQLParserUtil.childAt(i, node), column);
        }
    }

    private static Integer convertInteger(CommonTree node) {
        return Integer.parseInt(node.getText());
    }

    private static void convertColumnDetail(CommonTree node, DBColumn column) {
        switch (node.getType()) {
            case 5: {
                column.setNullable(false);
                break;
            }
            case 10: {
                column.setNullable(false);
                break;
            }
            default: {
                throw new ParseException("Unknown column detail token type", String.valueOf(node.getText()), node.getLine(), node.getCharPositionInLine());
            }
        }
    }

    private static String convertString(CommonTree node) {
        return node.getText();
    }

    private static SQLParser parser(CharStream in) {
        SQLLexer lex = new SQLLexer(in);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        SQLParser parser = new SQLParser((TokenStream)tokens);
        return parser;
    }

    private static ParseException mapToParseException(RecognitionException cause, String text) {
        return new ParseException("Error parsing SQL", (Throwable)cause, text, cause.line, cause.charPositionInLine);
    }

    private static List<CommonTree> getChildNodes(CommonTree node) {
        return node.getChildren();
    }

    private static CommonTree childAt(int index, CommonTree node) {
        return (CommonTree)node.getChild(index);
    }

    private static void checkForSyntaxErrors(String text, String type, SQLParser parser, ParserRuleReturnScope r) {
        if (parser.getNumberOfSyntaxErrors() > 0) {
            throw new SyntaxError("Illegal " + type, text, -1, -1);
        }
        CommonToken stop = (CommonToken)r.stop;
        if (text != null && stop.getStopIndex() < StringUtil.trimRight((String)text).length() - 1) {
            if (stop.getStopIndex() == 0) {
                throw new SyntaxError("Syntax error after " + stop.getText(), text);
            }
            throw new SyntaxError("Syntax error at the beginning ", text);
        }
    }
}

