/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.FileUtil;
import org.databene.commons.IOUtil;
import org.databene.commons.ImportFailedException;
import org.databene.commons.OrderedMap;
import org.databene.commons.SystemInfo;
import org.databene.commons.ui.ApplicationUtil;
import org.databene.commons.ui.JavaApplication;
import org.databene.jdbacl.swing.DatabasePane;
import org.databene.jdbacl.swing.EnvironmentSelector;
import org.databene.jdbacl.swing.TextFieldValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbaclGUI
extends JFrame
implements JavaApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbaclGUI.class);
    private static final String DATABENE_DIRECTORY_NAME = SystemInfo.getUserHome() + File.separator + "databene";
    private static final String GUI_PROPERTIES_FILE_NAME = DATABENE_DIRECTORY_NAME + File.separator + "JdbaclGUI.properties";
    private EnvironmentSelector environmentSelector;
    private DatabasePane databasePane;
    private JTextField exclusionField = new JTextField();

    public static void main(String[] args) throws IOException {
        ApplicationUtil.prepareNativeLAF((String)"jdbacl");
        JdbaclGUI appAndFrame = new JdbaclGUI();
        ApplicationUtil.configureApplication((JavaApplication)appAndFrame);
        appAndFrame.setVisible(true);
    }

    public JdbaclGUI() {
        this.environmentSelector = new EnvironmentSelector();
        this.databasePane = new DatabasePane(new TextFieldValueProvider(this.exclusionField));
        this.environmentSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String environment = JdbaclGUI.this.environmentSelector.getSelectedItem();
                try {
                    JdbaclGUI.this.databasePane.setEnvironment(environment);
                }
                catch (ConnectFailedException ex) {
                    LOGGER.error("Error importing environment " + environment, (Throwable)ex);
                }
                catch (ImportFailedException ex) {
                    LOGGER.error("Error importing environment " + environment, (Throwable)ex);
                }
            }
        });
        this.createMenuBar();
        this.createToolBar();
        this.getContentPane().add((Component)this.databasePane, "Center");
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.restoreState();
    }

    private void createToolBar() {
        JToolBar toolBar = new JToolBar();
        this.add((Component)toolBar, "North");
        toolBar.add(new JLabel("Exclusion:"));
        toolBar.add(this.exclusionField);
        toolBar.add(Box.createHorizontalStrut(8));
        toolBar.add(new JLabel("Environment:"));
        toolBar.add(this.environmentSelector);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.setFloatable(false);
    }

    private void createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        menubar.add(fileMenu);
        if (!SystemInfo.isMacOsx()) {
            fileMenu.add(new AbstractAction("Exit"){

                public void actionPerformed(ActionEvent evt) {
                    JdbaclGUI.this.exit();
                }
            });
        }
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        menubar.add(editMenu);
        JMenu helpMenu = new JMenu("Help");
        editMenu.setMnemonic('H');
        menubar.add(helpMenu);
        if (!SystemInfo.isMacOsx()) {
            helpMenu.add(new AbstractAction("About"){

                public void actionPerformed(ActionEvent evt) {
                    JdbaclGUI.this.about();
                }
            });
        }
        this.setJMenuBar(menubar);
    }

    public void about() {
        JOptionPane.showMessageDialog(this, "DB Sanity GUI " + SystemInfo.getLineSeparator() + "(c) 2011 by Volker Bergmann");
    }

    public void exit() {
        this.saveState();
        System.exit(0);
    }

    private void saveState() {
        try {
            FileUtil.ensureDirectoryExists((File)new File(DATABENE_DIRECTORY_NAME));
            OrderedMap props = new OrderedMap();
            props.put("exclusionPattern", this.exclusionField.getText());
            IOUtil.writeProperties((Map)props, (String)GUI_PROPERTIES_FILE_NAME);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void restoreState() {
        try {
            Map props = IOUtil.readProperties((String)GUI_PROPERTIES_FILE_NAME);
            this.exclusionField.setText((String)props.get("exclusionPattern"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String iconPath() {
        return null;
    }
}

