/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;

public class ValueGenerationStrategy
implements Serializable {
    private static final long serialVersionUID = -6851202349718961853L;
    public static final ValueGenerationStrategy NATIVE = new ValueGenerationStrategy(1);
    public static final ValueGenerationStrategy SEQUENCE = new ValueGenerationStrategy(2);
    public static final ValueGenerationStrategy IDENTITY = new ValueGenerationStrategy(3);
    public static final ValueGenerationStrategy INCREMENT = new ValueGenerationStrategy(4);
    public static final ValueGenerationStrategy UUIDSTRING = new ValueGenerationStrategy(5);
    public static final ValueGenerationStrategy UUIDHEX = new ValueGenerationStrategy(6);
    public static final ValueGenerationStrategy AUID = new ValueGenerationStrategy(7);
    public static final ValueGenerationStrategy UUID = new ValueGenerationStrategy(8);
    public static final ValueGenerationStrategy UUID_OBJECT = new ValueGenerationStrategy(9);
    public static final ValueGenerationStrategy TIMESTAMP = new ValueGenerationStrategy(10);
    public static final ValueGenerationStrategy TIMESTAMP_VALUE = new ValueGenerationStrategy(11);
    public static final ValueGenerationStrategy CUSTOM = new ValueGenerationStrategy(12);
    private final int typeId;
    private String customName;

    private ValueGenerationStrategy(int i) {
        this.typeId = i;
    }

    public String getCustomName() {
        return this.customName;
    }

    public int hashCode() {
        return this.typeId;
    }

    public boolean equals(Object o) {
        if (o instanceof ValueGenerationStrategy) {
            return ((ValueGenerationStrategy)o).typeId == this.typeId;
        }
        return false;
    }

    public String toString() {
        switch (this.typeId) {
            case 1: {
                return "native";
            }
            case 2: {
                return "sequence";
            }
            case 3: {
                return "identity";
            }
            case 4: {
                return "increment";
            }
            case 5: {
                return "uuid-string";
            }
            case 6: {
                return "uuid-hex";
            }
            case 7: {
                return "auid";
            }
            case 8: {
                return "uuid";
            }
            case 9: {
                return "uuid-object";
            }
            case 10: {
                return "timestamp";
            }
            case 11: {
                return "timestamp-value";
            }
            case 12: {
                return "custom";
            }
        }
        return "";
    }

    public int getType() {
        return this.typeId;
    }

    public static ValueGenerationStrategy getIdentityStrategy(String value) {
        if (value == null) {
            return NATIVE;
        }
        if (NATIVE.toString().equals(value)) {
            return NATIVE;
        }
        if (SEQUENCE.toString().equals(value)) {
            return SEQUENCE;
        }
        if (IDENTITY.toString().equals(value)) {
            return IDENTITY;
        }
        if (INCREMENT.toString().equals(value)) {
            return INCREMENT;
        }
        if ("TABLE".equalsIgnoreCase(value)) {
            return INCREMENT;
        }
        if (UUIDSTRING.toString().equals(value)) {
            return UUIDSTRING;
        }
        if (UUIDHEX.toString().equals(value)) {
            return UUIDHEX;
        }
        ValueGenerationStrategy strategy = new ValueGenerationStrategy(12);
        strategy.customName = value;
        return strategy;
    }
}

