/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.arrow.recordreader;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.batch.AbstractTimeSeriesWritableRecordBatch;
import org.datavec.arrow.recordreader.ArrowWritableRecordBatch;

public class ArrowWritableRecordTimeSeriesBatch
extends AbstractTimeSeriesWritableRecordBatch
implements Closeable {
    private List<FieldVector> list;
    private int size;
    private Schema schema;
    private ArrowRecordBatch arrowRecordBatch;
    private VectorSchemaRoot vectorLoader;
    private VectorUnloader unloader;
    private int timeSeriesStride;

    public ArrowWritableRecordTimeSeriesBatch(List<FieldVector> list, Schema schema, int timeSeriesStride) {
        this.list = list;
        this.schema = schema;
        this.timeSeriesStride = timeSeriesStride;
        this.size = list.size() * list.get(0).getValueCount() / timeSeriesStride;
    }

    public List<List<List<Writable>>> toArrayList() {
        ArrayList<List<List<Writable>>> ret = new ArrayList<List<List<Writable>>>();
        for (int i = 0; i < this.size(); ++i) {
            Object timeStep = this.get(i);
            ArrayList addTimeStep = new ArrayList();
            for (int j = 0; j < timeStep.size(); ++j) {
                List addingFrom = (List)timeStep.get(j);
                ArrayList currRecord = new ArrayList(addingFrom);
                addTimeStep.add(currRecord);
            }
            ret.add(addTimeStep);
        }
        return ret;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    public Iterator<List<List<Writable>>> iterator() {
        return new ArrowListIterator();
    }

    public Object[] toArray() {
        Object[] ret = new Object[this.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.get(i);
        }
        return ret;
    }

    public <T> T[] toArray(T[] ts) {
        throw new UnsupportedOperationException();
    }

    public boolean add(List<List<Writable>> writable) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> collection) {
        return false;
    }

    public boolean addAll(Collection<? extends List<List<Writable>>> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int i, Collection<? extends List<List<Writable>>> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
    }

    public List<List<Writable>> get(int i) {
        ArrowWritableRecordBatch ret = new ArrowWritableRecordBatch(this.list, this.schema, i, this.timeSeriesStride / this.schema.numColumns());
        return ret;
    }

    public List<List<Writable>> set(int i, List<List<Writable>> writable) {
        ArrowWritableRecordBatch arrowWritableRecordBatch = (ArrowWritableRecordBatch)this.get(i);
        for (int batch = 0; batch < writable.size(); ++batch) {
            arrowWritableRecordBatch.set(batch, writable.get(i));
        }
        return arrowWritableRecordBatch;
    }

    public void add(int i, List<List<Writable>> writable) {
        throw new UnsupportedOperationException();
    }

    public List<List<Writable>> remove(int i) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public ListIterator<List<List<Writable>>> listIterator() {
        return new ArrowListIterator();
    }

    public ListIterator<List<List<Writable>>> listIterator(int i) {
        throw new UnsupportedOperationException();
    }

    public List<List<List<Writable>>> subList(int i, int i1) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrowWritableRecordTimeSeriesBatch lists = (ArrowWritableRecordTimeSeriesBatch)o;
        return this.size == lists.size && Objects.equals(this.list, lists.list) && Objects.equals(this.schema, lists.schema);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.list, this.size, this.schema);
    }

    @Override
    public void close() throws IOException {
        if (this.arrowRecordBatch != null) {
            this.arrowRecordBatch.close();
        }
        if (this.vectorLoader != null) {
            this.vectorLoader.close();
        }
        this.list.forEach(ValueVector::close);
    }

    public List<FieldVector> getList() {
        return this.list;
    }

    public int getSize() {
        return this.size;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ArrowRecordBatch getArrowRecordBatch() {
        return this.arrowRecordBatch;
    }

    public VectorSchemaRoot getVectorLoader() {
        return this.vectorLoader;
    }

    public VectorUnloader getUnloader() {
        return this.unloader;
    }

    public int getTimeSeriesStride() {
        return this.timeSeriesStride;
    }

    public void setList(List<FieldVector> list) {
        this.list = list;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setArrowRecordBatch(ArrowRecordBatch arrowRecordBatch) {
        this.arrowRecordBatch = arrowRecordBatch;
    }

    public void setVectorLoader(VectorSchemaRoot vectorLoader) {
        this.vectorLoader = vectorLoader;
    }

    public void setUnloader(VectorUnloader unloader) {
        this.unloader = unloader;
    }

    public void setTimeSeriesStride(int timeSeriesStride) {
        this.timeSeriesStride = timeSeriesStride;
    }

    public String toString() {
        return "ArrowWritableRecordTimeSeriesBatch(list=" + this.getList() + ", size=" + this.getSize() + ", schema=" + this.getSchema() + ", arrowRecordBatch=" + this.getArrowRecordBatch() + ", vectorLoader=" + this.getVectorLoader() + ", unloader=" + this.getUnloader() + ", timeSeriesStride=" + this.getTimeSeriesStride() + ")";
    }

    public ArrowWritableRecordTimeSeriesBatch(List<FieldVector> list, int size, Schema schema, ArrowRecordBatch arrowRecordBatch, VectorSchemaRoot vectorLoader, VectorUnloader unloader, int timeSeriesStride) {
        this.list = list;
        this.size = size;
        this.schema = schema;
        this.arrowRecordBatch = arrowRecordBatch;
        this.vectorLoader = vectorLoader;
        this.unloader = unloader;
        this.timeSeriesStride = timeSeriesStride;
    }

    private class ArrowListIterator
    implements ListIterator<List<List<Writable>>> {
        private int index;

        private ArrowListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrowWritableRecordTimeSeriesBatch.this.size;
        }

        @Override
        public List<List<Writable>> next() {
            return ArrowWritableRecordTimeSeriesBatch.this.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public List<List<Writable>> previous() {
            return ArrowWritableRecordTimeSeriesBatch.this.get(this.index - 1);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(List<List<Writable>> writables) {
            ArrowWritableRecordTimeSeriesBatch.this.set(this.index, writables);
        }

        @Override
        public void add(List<List<Writable>> writables) {
            throw new UnsupportedOperationException();
        }
    }
}

