/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FlipImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private int flipMode;

    public FlipImageTransform() {
        this(null);
    }

    public FlipImageTransform(int flipMode) {
        this(null);
        this.flipMode = flipMode;
    }

    public FlipImageTransform(Random random) {
        super(random);
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        int mode = random != null ? random.nextInt(4) - 2 : this.flipMode;
        opencv_core.Mat result = new opencv_core.Mat();
        if (mode < -1) {
            mat.copyTo(result);
        } else {
            opencv_core.flip((opencv_core.Mat)mat, (opencv_core.Mat)result, (int)mode);
        }
        return new ImageWritable(this.converter.convert((Object)result));
    }
}

