/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"interMode", "borderMode", "borderValue", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WarpImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private float[] deltas;
    int interMode = 1;
    int borderMode = 0;
    opencv_core.Scalar borderValue = opencv_core.Scalar.ZERO;

    public WarpImageTransform(float delta) {
        this(null, delta, delta, delta, delta, delta, delta, delta, delta);
    }

    public WarpImageTransform(Random random, float delta) {
        this(random, delta, delta, delta, delta, delta, delta, delta, delta);
    }

    public WarpImageTransform(@JsonProperty(value="deltas[0]") float dx1, @JsonProperty(value="deltas[1]") float dy1, @JsonProperty(value="deltas[2]") float dx2, @JsonProperty(value="deltas[3]") float dy2, @JsonProperty(value="deltas[4]") float dx3, @JsonProperty(value="deltas[5]") float dy3, @JsonProperty(value="deltas[6]") float dx4, @JsonProperty(value="deltas[7]") float dy4) {
        this(null, dx1, dy1, dx2, dy2, dx3, dy3, dx4, dy4);
    }

    public WarpImageTransform(Random random, float dx1, float dy1, float dx2, float dy2, float dx3, float dy3, float dx4, float dy4) {
        super(random);
        this.deltas = new float[8];
        this.deltas[0] = dx1;
        this.deltas[1] = dy1;
        this.deltas[2] = dx2;
        this.deltas[3] = dy2;
        this.deltas[4] = dx3;
        this.deltas[5] = dy3;
        this.deltas[6] = dx4;
        this.deltas[7] = dy4;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Point2f src = new opencv_core.Point2f(4L);
        opencv_core.Point2f dst = new opencv_core.Point2f(4L);
        src.put(new float[]{0.0f, 0.0f, mat.cols(), 0.0f, mat.cols(), mat.rows(), 0.0f, mat.rows()});
        for (int i = 0; i < 8; ++i) {
            dst.put((long)i, src.get((long)i) + this.deltas[i] * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f));
        }
        opencv_core.Mat result = new opencv_core.Mat();
        opencv_core.Mat M = opencv_imgproc.getPerspectiveTransform((opencv_core.Point2f)src, (opencv_core.Point2f)dst);
        opencv_imgproc.warpPerspective((opencv_core.Mat)mat, (opencv_core.Mat)result, (opencv_core.Mat)M, (opencv_core.Size)mat.size(), (int)this.interMode, (int)this.borderMode, (opencv_core.Scalar)this.borderValue);
        return new ImageWritable(this.converter.convert((Object)result));
    }

    public int interMode() {
        return this.interMode;
    }

    public WarpImageTransform interMode(int interMode) {
        this.interMode = interMode;
        return this;
    }

    public int borderMode() {
        return this.borderMode;
    }

    public WarpImageTransform borderMode(int borderMode) {
        this.borderMode = borderMode;
        return this;
    }

    public opencv_core.Scalar borderValue() {
        return this.borderValue;
    }

    public WarpImageTransform borderValue(opencv_core.Scalar borderValue) {
        this.borderValue = borderValue;
        return this;
    }
}

