/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.misc;

import java.util.Arrays;
import java.util.List;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.common.function.Function;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class WritablesToNDArrayFunction
implements Function<List<Writable>, INDArray> {
    public INDArray apply(List<Writable> c) {
        int length = 0;
        for (Writable w : c) {
            if (w instanceof NDArrayWritable) {
                INDArray a = ((NDArrayWritable)w).get();
                if (a.isRowVector()) {
                    length += a.columns();
                    continue;
                }
                throw new UnsupportedOperationException("NDArrayWritable is not a row vector. Can only concat row vectors with other writables. Shape: " + Arrays.toString(a.shape()));
            }
            ++length;
        }
        INDArray arr = Nd4j.zeros((int[])new int[]{1, length});
        int idx = 0;
        for (Writable w : c) {
            if (w instanceof NDArrayWritable) {
                INDArray subArr = ((NDArrayWritable)w).get();
                int subLength = subArr.columns();
                arr.get(new INDArrayIndex[]{NDArrayIndex.point((long)0L), NDArrayIndex.interval((int)idx, (int)(idx + subLength))}).assign(subArr);
                idx += subLength;
                continue;
            }
            arr.putScalar((long)idx++, w.toDouble());
        }
        return arr;
    }
}

