/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.DefaultHadoopConfig;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.nd4j.linalg.dataset.MultiDataSet;

public class PathToMultiDataSetFunction
implements Function<String, org.nd4j.linalg.dataset.api.MultiDataSet> {
    public static final int BUFFER_SIZE = 0x400000;
    private transient FileSystem fileSystem;
    private final Broadcast<SerializableHadoopConfig> conf;

    public PathToMultiDataSetFunction() {
        this(null);
    }

    public PathToMultiDataSetFunction(Broadcast<SerializableHadoopConfig> configuration) {
        this.conf = configuration;
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet call(String path) throws Exception {
        if (this.fileSystem == null) {
            try {
                Configuration c = this.conf == null ? DefaultHadoopConfig.get() : ((SerializableHadoopConfig)this.conf.getValue()).getConfiguration();
                this.fileSystem = FileSystem.get((URI)new URI(path), (Configuration)c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        MultiDataSet ds = new MultiDataSet();
        try (FSDataInputStream inputStream = this.fileSystem.open(new Path(path), 0x400000);){
            ds.load((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ds;
    }
}

