/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.data.shuffle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.nd4j.linalg.dataset.DataSet;
import scala.Tuple2;

public class SplitDataSetExamplesPairFlatMapFunction
implements PairFlatMapFunction<DataSet, Integer, DataSet> {
    private transient Random r;
    private int maxKeyIndex;

    public SplitDataSetExamplesPairFlatMapFunction(int maxKeyIndex) {
        this.maxKeyIndex = maxKeyIndex;
    }

    public Iterator<Tuple2<Integer, DataSet>> call(DataSet dataSet) throws Exception {
        if (this.r == null) {
            this.r = new Random();
        }
        List singleExamples = dataSet.asList();
        ArrayList<Tuple2> out = new ArrayList<Tuple2>(singleExamples.size());
        for (DataSet ds : singleExamples) {
            out.add(new Tuple2((Object)this.r.nextInt(this.maxKeyIndex), (Object)ds));
        }
        return out.iterator();
    }
}

