/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.spark.api.java.function.Function2;
import scala.Tuple2;

public class SplitPartitionsFunction2<T, U>
implements Function2<Integer, Iterator<Tuple2<T, U>>, Iterator<Tuple2<T, U>>> {
    private final int splitIndex;
    private final int numSplits;
    private final long baseRngSeed;

    public Iterator<Tuple2<T, U>> call(Integer v1, Iterator<Tuple2<T, U>> iter) throws Exception {
        long thisRngSeed = this.baseRngSeed + (long)v1.intValue();
        Random r = new Random(thisRngSeed);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.numSplits; ++i) {
            list.add(i);
        }
        ArrayList<Tuple2<T, U>> outputList = new ArrayList<Tuple2<T, U>>();
        int i = 0;
        while (iter.hasNext()) {
            if (i % this.numSplits == 0) {
                Collections.shuffle(list, r);
            }
            Tuple2<T, U> next = iter.next();
            if ((Integer)list.get(i % this.numSplits) == this.splitIndex) {
                outputList.add(next);
            }
            ++i;
        }
        return outputList.iterator();
    }

    public SplitPartitionsFunction2(int splitIndex, int numSplits, long baseRngSeed) {
        this.splitIndex = splitIndex;
        this.numSplits = numSplits;
        this.baseRngSeed = baseRngSeed;
    }
}

