/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.paramavg.aggregator;

import java.io.Serializable;
import java.util.Collection;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StorageMetaData;
import org.deeplearning4j.spark.api.stats.SparkTrainingStats;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ParameterAveragingAggregationTuple
implements Serializable {
    private final INDArray parametersSum;
    private final INDArray updaterStateSum;
    private final double scoreSum;
    private final int aggregationsCount;
    private final SparkTrainingStats sparkTrainingStats;
    private final Collection<StorageMetaData> listenerMetaData;
    private final Collection<Persistable> listenerStaticInfo;
    private final Collection<Persistable> listenerUpdates;

    public static ParameterAveragingAggregationTupleBuilder builder() {
        return new ParameterAveragingAggregationTupleBuilder();
    }

    public ParameterAveragingAggregationTuple(INDArray parametersSum, INDArray updaterStateSum, double scoreSum, int aggregationsCount, SparkTrainingStats sparkTrainingStats, Collection<StorageMetaData> listenerMetaData, Collection<Persistable> listenerStaticInfo, Collection<Persistable> listenerUpdates) {
        this.parametersSum = parametersSum;
        this.updaterStateSum = updaterStateSum;
        this.scoreSum = scoreSum;
        this.aggregationsCount = aggregationsCount;
        this.sparkTrainingStats = sparkTrainingStats;
        this.listenerMetaData = listenerMetaData;
        this.listenerStaticInfo = listenerStaticInfo;
        this.listenerUpdates = listenerUpdates;
    }

    public INDArray getParametersSum() {
        return this.parametersSum;
    }

    public INDArray getUpdaterStateSum() {
        return this.updaterStateSum;
    }

    public double getScoreSum() {
        return this.scoreSum;
    }

    public int getAggregationsCount() {
        return this.aggregationsCount;
    }

    public SparkTrainingStats getSparkTrainingStats() {
        return this.sparkTrainingStats;
    }

    public Collection<StorageMetaData> getListenerMetaData() {
        return this.listenerMetaData;
    }

    public Collection<Persistable> getListenerStaticInfo() {
        return this.listenerStaticInfo;
    }

    public Collection<Persistable> getListenerUpdates() {
        return this.listenerUpdates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterAveragingAggregationTuple)) {
            return false;
        }
        ParameterAveragingAggregationTuple other = (ParameterAveragingAggregationTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$parametersSum = this.getParametersSum();
        INDArray other$parametersSum = other.getParametersSum();
        if (this$parametersSum == null ? other$parametersSum != null : !this$parametersSum.equals(other$parametersSum)) {
            return false;
        }
        INDArray this$updaterStateSum = this.getUpdaterStateSum();
        INDArray other$updaterStateSum = other.getUpdaterStateSum();
        if (this$updaterStateSum == null ? other$updaterStateSum != null : !this$updaterStateSum.equals(other$updaterStateSum)) {
            return false;
        }
        if (Double.compare(this.getScoreSum(), other.getScoreSum()) != 0) {
            return false;
        }
        if (this.getAggregationsCount() != other.getAggregationsCount()) {
            return false;
        }
        SparkTrainingStats this$sparkTrainingStats = this.getSparkTrainingStats();
        SparkTrainingStats other$sparkTrainingStats = other.getSparkTrainingStats();
        if (this$sparkTrainingStats == null ? other$sparkTrainingStats != null : !this$sparkTrainingStats.equals(other$sparkTrainingStats)) {
            return false;
        }
        Collection<StorageMetaData> this$listenerMetaData = this.getListenerMetaData();
        Collection<StorageMetaData> other$listenerMetaData = other.getListenerMetaData();
        if (this$listenerMetaData == null ? other$listenerMetaData != null : !((Object)this$listenerMetaData).equals(other$listenerMetaData)) {
            return false;
        }
        Collection<Persistable> this$listenerStaticInfo = this.getListenerStaticInfo();
        Collection<Persistable> other$listenerStaticInfo = other.getListenerStaticInfo();
        if (this$listenerStaticInfo == null ? other$listenerStaticInfo != null : !((Object)this$listenerStaticInfo).equals(other$listenerStaticInfo)) {
            return false;
        }
        Collection<Persistable> this$listenerUpdates = this.getListenerUpdates();
        Collection<Persistable> other$listenerUpdates = other.getListenerUpdates();
        return !(this$listenerUpdates == null ? other$listenerUpdates != null : !((Object)this$listenerUpdates).equals(other$listenerUpdates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterAveragingAggregationTuple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $parametersSum = this.getParametersSum();
        result = result * 59 + ($parametersSum == null ? 43 : $parametersSum.hashCode());
        INDArray $updaterStateSum = this.getUpdaterStateSum();
        result = result * 59 + ($updaterStateSum == null ? 43 : $updaterStateSum.hashCode());
        long $scoreSum = Double.doubleToLongBits(this.getScoreSum());
        result = result * 59 + (int)($scoreSum >>> 32 ^ $scoreSum);
        result = result * 59 + this.getAggregationsCount();
        SparkTrainingStats $sparkTrainingStats = this.getSparkTrainingStats();
        result = result * 59 + ($sparkTrainingStats == null ? 43 : $sparkTrainingStats.hashCode());
        Collection<StorageMetaData> $listenerMetaData = this.getListenerMetaData();
        result = result * 59 + ($listenerMetaData == null ? 43 : ((Object)$listenerMetaData).hashCode());
        Collection<Persistable> $listenerStaticInfo = this.getListenerStaticInfo();
        result = result * 59 + ($listenerStaticInfo == null ? 43 : ((Object)$listenerStaticInfo).hashCode());
        Collection<Persistable> $listenerUpdates = this.getListenerUpdates();
        result = result * 59 + ($listenerUpdates == null ? 43 : ((Object)$listenerUpdates).hashCode());
        return result;
    }

    public String toString() {
        return "ParameterAveragingAggregationTuple(parametersSum=" + this.getParametersSum() + ", updaterStateSum=" + this.getUpdaterStateSum() + ", scoreSum=" + this.getScoreSum() + ", aggregationsCount=" + this.getAggregationsCount() + ", sparkTrainingStats=" + this.getSparkTrainingStats() + ", listenerMetaData=" + this.getListenerMetaData() + ", listenerStaticInfo=" + this.getListenerStaticInfo() + ", listenerUpdates=" + this.getListenerUpdates() + ")";
    }

    public static class ParameterAveragingAggregationTupleBuilder {
        private INDArray parametersSum;
        private INDArray updaterStateSum;
        private double scoreSum;
        private int aggregationsCount;
        private SparkTrainingStats sparkTrainingStats;
        private Collection<StorageMetaData> listenerMetaData;
        private Collection<Persistable> listenerStaticInfo;
        private Collection<Persistable> listenerUpdates;

        ParameterAveragingAggregationTupleBuilder() {
        }

        public ParameterAveragingAggregationTupleBuilder parametersSum(INDArray parametersSum) {
            this.parametersSum = parametersSum;
            return this;
        }

        public ParameterAveragingAggregationTupleBuilder updaterStateSum(INDArray updaterStateSum) {
            this.updaterStateSum = updaterStateSum;
            return this;
        }

        public ParameterAveragingAggregationTupleBuilder scoreSum(double scoreSum) {
            this.scoreSum = scoreSum;
            return this;
        }

        public ParameterAveragingAggregationTupleBuilder aggregationsCount(int aggregationsCount) {
            this.aggregationsCount = aggregationsCount;
            return this;
        }

        public ParameterAveragingAggregationTupleBuilder sparkTrainingStats(SparkTrainingStats sparkTrainingStats) {
            this.sparkTrainingStats = sparkTrainingStats;
            return this;
        }

        public ParameterAveragingAggregationTupleBuilder listenerMetaData(Collection<StorageMetaData> listenerMetaData) {
            this.listenerMetaData = listenerMetaData;
            return this;
        }

        public ParameterAveragingAggregationTupleBuilder listenerStaticInfo(Collection<Persistable> listenerStaticInfo) {
            this.listenerStaticInfo = listenerStaticInfo;
            return this;
        }

        public ParameterAveragingAggregationTupleBuilder listenerUpdates(Collection<Persistable> listenerUpdates) {
            this.listenerUpdates = listenerUpdates;
            return this;
        }

        public ParameterAveragingAggregationTuple build() {
            return new ParameterAveragingAggregationTuple(this.parametersSum, this.updaterStateSum, this.scoreSum, this.aggregationsCount, this.sparkTrainingStats, this.listenerMetaData, this.listenerStaticInfo, this.listenerUpdates);
        }

        public String toString() {
            return "ParameterAveragingAggregationTuple.ParameterAveragingAggregationTupleBuilder(parametersSum=" + this.parametersSum + ", updaterStateSum=" + this.updaterStateSum + ", scoreSum=" + this.scoreSum + ", aggregationsCount=" + this.aggregationsCount + ", sparkTrainingStats=" + this.sparkTrainingStats + ", listenerMetaData=" + this.listenerMetaData + ", listenerStaticInfo=" + this.listenerStaticInfo + ", listenerUpdates=" + this.listenerUpdates + ")";
        }
    }
}

