/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.util.data.validation;

import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.DefaultHadoopConfig;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.deeplearning4j.spark.util.data.ValidationResult;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;

public class ValidateDataSetFn
implements Function<String, ValidationResult> {
    public static final int BUFFER_SIZE = 0x400000;
    private final boolean deleteInvalid;
    private final int[] featuresShape;
    private final int[] labelsShape;
    private final Broadcast<SerializableHadoopConfig> conf;
    private transient FileSystem fileSystem;

    public ValidateDataSetFn(boolean deleteInvalid, int[] featuresShape, int[] labelsShape) {
        this(deleteInvalid, featuresShape, labelsShape, null);
    }

    public ValidateDataSetFn(boolean deleteInvalid, int[] featuresShape, int[] labelsShape, Broadcast<SerializableHadoopConfig> configuration) {
        this.deleteInvalid = deleteInvalid;
        this.featuresShape = featuresShape;
        this.labelsShape = labelsShape;
        this.conf = configuration;
    }

    public ValidationResult call(String path) throws Exception {
        if (this.fileSystem == null) {
            Configuration c = this.conf == null ? DefaultHadoopConfig.get() : ((SerializableHadoopConfig)this.conf.getValue()).getConfiguration();
            try {
                this.fileSystem = FileSystem.get((URI)new URI(path), (Configuration)c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ValidationResult ret = new ValidationResult();
        ret.setCountTotal(1L);
        boolean shouldDelete = false;
        boolean loadSuccessful = false;
        DataSet ds = new DataSet();
        Path p = new Path(path);
        if (this.fileSystem.isDirectory(p)) {
            ret.setCountTotal(0L);
            return ret;
        }
        if (!this.fileSystem.exists(p)) {
            ret.setCountMissingFile(1L);
            return ret;
        }
        try (FSDataInputStream inputStream = this.fileSystem.open(p, 0x400000);){
            ds.load((InputStream)inputStream);
            loadSuccessful = true;
        }
        catch (RuntimeException t) {
            shouldDelete = this.deleteInvalid;
            ret.setCountLoadingFailure(1L);
        }
        boolean isValid = loadSuccessful;
        if (loadSuccessful) {
            if (ds.getFeatures() == null) {
                ret.setCountMissingFeatures(1L);
                isValid = false;
            } else if (this.featuresShape != null && !ValidateDataSetFn.validateArrayShape(this.featuresShape, ds.getFeatures())) {
                ret.setCountInvalidFeatures(1L);
                isValid = false;
            }
            if (ds.getLabels() == null) {
                ret.setCountMissingLabels(1L);
                isValid = false;
            } else if (this.labelsShape != null && !ValidateDataSetFn.validateArrayShape(this.labelsShape, ds.getLabels())) {
                ret.setCountInvalidLabels(1L);
                isValid = false;
            }
            if (!isValid && this.deleteInvalid) {
                shouldDelete = true;
            }
        }
        if (isValid) {
            ret.setCountTotalValid(1L);
        } else {
            ret.setCountTotalInvalid(1L);
        }
        if (shouldDelete) {
            this.fileSystem.delete(p, false);
            ret.setCountInvalidDeleted(1L);
        }
        return ret;
    }

    protected static boolean validateArrayShape(int[] featuresShape, INDArray array) {
        if (featuresShape == null) {
            return true;
        }
        if (featuresShape.length != array.rank()) {
            return false;
        }
        for (int i = 0; i < featuresShape.length; ++i) {
            if (featuresShape[i] <= 0 || (long)featuresShape[i] == array.size(i)) continue;
            return false;
        }
        return true;
    }
}

