/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractASiCContainerExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractASiCContainerExtractor.class);
    private static final int MAXIMAL_ALLOWED_FILE_AMOUNT = 1024;
    private final DSSDocument asicContainer;

    protected AbstractASiCContainerExtractor(DSSDocument asicContainer) {
        this.asicContainer = asicContainer;
    }

    public ASiCExtractResult extract() {
        ASiCExtractResult result = new ASiCExtractResult();
        long containerSize = DSSUtils.getFileByteSize((DSSDocument)this.asicContainer);
        List<String> fileNames = ASiCUtils.getFileNames(this.asicContainer);
        if (Utils.isCollectionEmpty(fileNames)) {
            throw new DSSException("The provided file does not contain documents inside. Probably file has an unsupported format or has been corrupted. The signature validation is not possible");
        }
        if (fileNames.size() > 1024) {
            throw new DSSException("Too many files detected. Cannot extract ASiC content");
        }
        try (InputStream is = this.asicContainer.openStream();
             ZipInputStream asicInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = ASiCUtils.getNextValidEntry(asicInputStream)) != null) {
                String entryName = entry.getName();
                if (this.isMetaInfFolder(entryName)) {
                    if (this.isAllowedSignature(entryName)) {
                        result.getSignatureDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream, containerSize));
                        continue;
                    }
                    if (this.isAllowedManifest(entryName)) {
                        result.getManifestDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream, containerSize));
                        continue;
                    }
                    if (this.isAllowedArchiveManifest(entryName)) {
                        result.getArchiveManifestDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream, containerSize));
                        continue;
                    }
                    if (this.isAllowedTimestamp(entryName)) {
                        result.getTimestampDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream, containerSize));
                        continue;
                    }
                    if (this.isFolder(entryName)) continue;
                    result.getUnsupportedDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream, containerSize));
                    continue;
                }
                if (this.isFolder(entryName)) continue;
                if (this.isMimetype(entryName)) {
                    result.setMimeTypeDocument(ASiCUtils.getCurrentDocument(entryName, asicInputStream, containerSize));
                    continue;
                }
                result.getSignedDocuments().add(ASiCUtils.getCurrentDocument(entryName, asicInputStream, containerSize));
            }
            if (Utils.isCollectionNotEmpty(result.getUnsupportedDocuments())) {
                LOG.warn("Unsupported files : {}", result.getUnsupportedDocuments());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to parse the container {}", (Object)e.getMessage());
        }
        result.setZipComment(this.getZipComment());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getZipComment() {
        try (InputStream is = this.asicContainer.openStream();){
            byte[] buffer = Utils.toByteArray((InputStream)is);
            int len = buffer.length;
            byte[] magicDirEnd = new byte[]{80, 75, 5, 6};
            int ii = len - magicDirEnd.length - 22;
            while (ii >= 0) {
                boolean isMagicStart = true;
                for (int jj = 0; jj < magicDirEnd.length; ++jj) {
                    if (buffer[ii + jj] == magicDirEnd[jj]) continue;
                    isMagicStart = false;
                    break;
                }
                if (isMagicStart) {
                    int commentLen = buffer[ii + 20] + buffer[ii + 21] * 256;
                    int realLen = len - ii - 22;
                    if (commentLen != realLen) {
                        LOG.warn("WARNING! ZIP comment size mismatch: directory says len is {}, but file ends after {} bytes!", (Object)commentLen, (Object)realLen);
                    }
                    String string = new String(buffer, ii + 22, realLen);
                    return string;
                }
                --ii;
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Unable to extract the ZIP comment : {}", (Object)e.getMessage());
        }
        return null;
    }

    private boolean isMimetype(String entryName) {
        return "mimetype".equals(entryName);
    }

    private boolean isMetaInfFolder(String entryName) {
        return entryName.startsWith("META-INF/");
    }

    private boolean isFolder(String entryName) {
        return entryName.endsWith("/");
    }

    protected abstract boolean isAllowedManifest(String var1);

    protected abstract boolean isAllowedArchiveManifest(String var1);

    protected abstract boolean isAllowedTimestamp(String var1);

    protected abstract boolean isAllowedSignature(String var1);
}

