/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTokenProxy
implements TokenProxy {
    protected abstract XmlBasicSignature getCurrentBasicSignature();

    protected abstract List<XmlChainItem> getCurrentCertificateChain();

    protected abstract XmlSigningCertificate getCurrentSigningCertificate();

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateWrapper> getCertificateChain() {
        ArrayList<CertificateWrapper> result = new ArrayList<CertificateWrapper>();
        List<XmlChainItem> certificateChain = this.getCurrentCertificateChain();
        if (certificateChain != null) {
            for (XmlChainItem xmlChainCertificate : certificateChain) {
                result.add(new CertificateWrapper(xmlChainCertificate.getCertificate()));
            }
        }
        return result;
    }

    @Override
    public boolean isSignatureIntact() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        return basicSignature != null && basicSignature.isSignatureIntact();
    }

    @Override
    public boolean isSignatureValid() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        return basicSignature != null && basicSignature.isSignatureValid();
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getEncryptionAlgoUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getDigestAlgoUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public MaskGenerationFunction getMaskGenerationFunction() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getMaskGenerationFunctionUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public String getKeyLengthUsedToSignThisToken() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getKeyLengthUsedToSignThisToken();
        }
        return "";
    }

    @Override
    public boolean isIssuerSerialMatch() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        return currentSigningCertificate != null && currentSigningCertificate.isIssuerSerialMatch() != null && currentSigningCertificate.isIssuerSerialMatch() != false;
    }

    @Override
    public boolean isAttributePresent() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        return currentSigningCertificate != null && currentSigningCertificate.isAttributePresent() != null && currentSigningCertificate.isAttributePresent() != false;
    }

    @Override
    public boolean isDigestValueMatch() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        return currentSigningCertificate != null && currentSigningCertificate.isDigestValueMatch() != null && currentSigningCertificate.isDigestValueMatch() != false;
    }

    @Override
    public boolean isDigestValuePresent() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        return currentSigningCertificate != null && currentSigningCertificate.isDigestValuePresent() != null && currentSigningCertificate.isDigestValuePresent() != false;
    }

    @Override
    public CertificateWrapper getSigningCertificate() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        if (currentSigningCertificate != null && currentSigningCertificate.getCertificate() != null) {
            return new CertificateWrapper(currentSigningCertificate.getCertificate());
        }
        return null;
    }

    @Override
    public byte[] getSigningCertificatePublicKey() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        if (currentSigningCertificate != null) {
            return currentSigningCertificate.getPublicKey();
        }
        return null;
    }

    @Override
    public boolean isTrustedChain() {
        List<CertificateWrapper> certificateChain = this.getCertificateChain();
        for (CertificateWrapper certificate : certificateChain) {
            List<CertificateSourceType> currentCertSources = certificate.getSources();
            if (!currentCertSources.contains(CertificateSourceType.TRUSTED_STORE) && !currentCertSources.contains(CertificateSourceType.TRUSTED_LIST)) continue;
            return true;
        }
        return false;
    }

    public boolean isCertificateChainFromTrustedStore() {
        for (CertificateWrapper certificate : this.getCertificateChain()) {
            if (!certificate.getSources().contains(CertificateSourceType.TRUSTED_STORE)) continue;
            return true;
        }
        return false;
    }

    public abstract byte[] getBinaries();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTokenProxy other = (AbstractTokenProxy)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

