/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundCertificates;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureDictionary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocationRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureDigestReference;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerDocumentRepresentations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlStructuralValidation;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignatureWrapper
extends AbstractTokenProxy {
    private final XmlSignature signature;

    public SignatureWrapper(XmlSignature signature) {
        this.signature = signature;
    }

    @Override
    public String getId() {
        return this.signature.getId();
    }

    public String getDAIdentifier() {
        return this.signature.getDAIdentifier();
    }

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return this.signature.getDigestMatchers();
    }

    public XmlDigestMatcher getMessageDigest() {
        List<XmlDigestMatcher> digestMatchers = this.signature.getDigestMatchers();
        for (XmlDigestMatcher xmlDigestMatcher : digestMatchers) {
            if (DigestMatcherType.MESSAGE_DIGEST != xmlDigestMatcher.getType()) continue;
            return xmlDigestMatcher;
        }
        return null;
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.signature.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.signature.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.signature.getSigningCertificate();
    }

    public String getSignatureFilename() {
        return this.signature.getSignatureFilename();
    }

    public boolean isStructuralValidationValid() {
        return this.signature.getStructuralValidation() != null && this.signature.getStructuralValidation().isValid() != false;
    }

    public String getStructuralValidationMessage() {
        XmlStructuralValidation structuralValidation = this.signature.getStructuralValidation();
        if (structuralValidation != null) {
            return structuralValidation.getMessage();
        }
        return "";
    }

    public Date getDateTime() {
        return this.signature.getDateTime();
    }

    public String getContentType() {
        return this.signature.getContentType();
    }

    public String getMimeType() {
        return this.signature.getMimeType();
    }

    public String getContentHints() {
        return this.signature.getContentHints();
    }

    public String getContentIdentifier() {
        return this.signature.getContentIdentifier();
    }

    public boolean isCounterSignature() {
        return this.signature.isCounterSignature() != null && this.signature.isCounterSignature() != false;
    }

    public XmlSignatureDigestReference getSignatureDigestReference() {
        return this.signature.getSignatureDigestReference();
    }

    public List<TimestampWrapper> getTimestampList() {
        ArrayList<TimestampWrapper> tsps = new ArrayList<TimestampWrapper>();
        List<XmlFoundTimestamp> foundTimestamps = this.signature.getFoundTimestamps();
        for (XmlFoundTimestamp xmlFoundTimestamp : foundTimestamps) {
            tsps.add(new TimestampWrapper(xmlFoundTimestamp.getTimestamp()));
        }
        return tsps;
    }

    public List<TimestampWrapper> getTimestampListByType(TimestampType timestampType) {
        ArrayList<TimestampWrapper> result = new ArrayList<TimestampWrapper>();
        List<TimestampWrapper> all = this.getTimestampList();
        for (TimestampWrapper tsp : all) {
            if (!timestampType.equals((Object)tsp.getType())) continue;
            result.add(tsp);
        }
        return result;
    }

    public List<TimestampWrapper> getTimestampListByLocation(TimestampLocation timestampLocation) {
        ArrayList<TimestampWrapper> tsps = new ArrayList<TimestampWrapper>();
        List<XmlFoundTimestamp> foundTimestamps = this.signature.getFoundTimestamps();
        for (XmlFoundTimestamp xmlFoundTimestamp : foundTimestamps) {
            if (xmlFoundTimestamp.getLocation() == null || !xmlFoundTimestamp.getLocation().name().equals(timestampLocation.name())) continue;
            tsps.add(new TimestampWrapper(xmlFoundTimestamp.getTimestamp()));
        }
        return tsps;
    }

    public boolean isSignatureProductionPlacePresent() {
        return this.signature.getSignatureProductionPlace() != null;
    }

    public String getAddress() {
        return this.signature.getSignatureProductionPlace().getAddress();
    }

    public String getCity() {
        return this.signature.getSignatureProductionPlace().getCity();
    }

    public String getCountryName() {
        return this.signature.getSignatureProductionPlace().getCountryName();
    }

    public String getPostalCode() {
        return this.signature.getSignatureProductionPlace().getPostalCode();
    }

    public String getStateOrProvince() {
        return this.signature.getSignatureProductionPlace().getStateOrProvince();
    }

    public SignatureLevel getSignatureFormat() {
        return this.signature.getSignatureFormat();
    }

    public String getErrorMessage() {
        return this.signature.getErrorMessage();
    }

    public boolean isSigningCertificateIdentified() {
        XmlSigningCertificate signingCertificate = this.signature.getSigningCertificate();
        if (signingCertificate != null) {
            return signingCertificate.isDigestValueMatch() != false && signingCertificate.isIssuerSerialMatch() != false;
        }
        return false;
    }

    public String getPolicyId() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getId();
        }
        return "";
    }

    public boolean isZeroHashPolicy() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isZeroHash() != null && policy.isZeroHash() != false;
        }
        return false;
    }

    public boolean isBLevelTechnicallyValid() {
        return this.signature.getBasicSignature() != null && this.signature.getBasicSignature().isSignatureValid();
    }

    public boolean isThereXLevel() {
        List<TimestampWrapper> timestampLevelX = this.getTimestampLevelX();
        return timestampLevelX != null && timestampLevelX.size() > 0;
    }

    public boolean isXLevelTechnicallyValid() {
        List<TimestampWrapper> timestamps = this.getTimestampLevelX();
        return this.isTimestampValid(timestamps);
    }

    private List<TimestampWrapper> getTimestampLevelX() {
        List<TimestampWrapper> timestamps = this.getTimestampListByType(TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP);
        timestamps.addAll(this.getTimestampListByType(TimestampType.VALIDATION_DATA_TIMESTAMP));
        return timestamps;
    }

    public boolean isThereALevel() {
        List<TimestampWrapper> timestampList = this.getArchiveTimestamps();
        return timestampList != null && timestampList.size() > 0;
    }

    public boolean isALevelTechnicallyValid() {
        List<TimestampWrapper> timestampList = this.getArchiveTimestamps();
        return this.isTimestampValid(timestampList);
    }

    private List<TimestampWrapper> getArchiveTimestamps() {
        return this.getTimestampListByType(TimestampType.ARCHIVE_TIMESTAMP);
    }

    public boolean isThereTLevel() {
        List<TimestampWrapper> timestamps = this.getSignatureTimestamps();
        return timestamps != null && timestamps.size() > 0;
    }

    public boolean isTLevelTechnicallyValid() {
        List<TimestampWrapper> timestampList = this.getSignatureTimestamps();
        return this.isTimestampValid(timestampList);
    }

    private List<TimestampWrapper> getSignatureTimestamps() {
        return this.getTimestampListByType(TimestampType.SIGNATURE_TIMESTAMP);
    }

    private boolean isTimestampValid(List<TimestampWrapper> timestampList) {
        for (TimestampWrapper timestamp : timestampList) {
            boolean messageImprintIntact;
            boolean signatureValid = timestamp.isSignatureValid();
            XmlDigestMatcher messageImprint = timestamp.getMessageImprint();
            boolean bl = messageImprintIntact = messageImprint.isDataFound() && messageImprint.isDataIntact();
            if (!signatureValid || !messageImprintIntact) continue;
            return true;
        }
        return false;
    }

    public List<String> getTimestampIdsList() {
        ArrayList<String> result = new ArrayList<String>();
        List<TimestampWrapper> timestamps = this.getTimestampList();
        if (timestamps != null) {
            for (TimestampWrapper tsp : timestamps) {
                result.add(tsp.getId());
            }
        }
        return result;
    }

    public SignatureWrapper getParent() {
        XmlSignature parent = this.signature.getParent();
        if (parent != null) {
            return new SignatureWrapper(parent);
        }
        return null;
    }

    public List<XmlSignatureScope> getSignatureScopes() {
        return this.signature.getSignatureScopes();
    }

    public List<XmlSignerRole> getSignerRoles() {
        return this.signature.getSignerRole();
    }

    public List<XmlSignerRole> getClaimedRoles() {
        return this.getSignerRolesByCategory(EndorsementType.CLAIMED);
    }

    public List<XmlSignerRole> getCertifiedRoles() {
        return this.getSignerRolesByCategory(EndorsementType.CERTIFIED);
    }

    public List<String> getSignerRoleDetails(List<XmlSignerRole> listOfSignerRoles) {
        ArrayList<String> roles = new ArrayList<String>();
        for (XmlSignerRole xmlSignerRole : listOfSignerRoles) {
            roles.add(xmlSignerRole.getRole());
        }
        return roles;
    }

    private List<XmlSignerRole> getSignerRolesByCategory(EndorsementType category) {
        ArrayList<XmlSignerRole> roles = new ArrayList<XmlSignerRole>();
        for (XmlSignerRole xmlSignerRole : this.getSignerRoles()) {
            if (!category.equals((Object)xmlSignerRole.getCategory())) continue;
            roles.add(xmlSignerRole);
        }
        return roles;
    }

    public List<String> getCommitmentTypeIdentifiers() {
        List<String> commitmentTypeIndications = this.signature.getCommitmentTypeIndication();
        if (commitmentTypeIndications != null) {
            return commitmentTypeIndications;
        }
        return Collections.emptyList();
    }

    public boolean isPolicyPresent() {
        return this.signature.getPolicy() != null;
    }

    public String getPolicyProcessingError() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getProcessingError();
        }
        return "";
    }

    public boolean getPolicyStatus() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isStatus();
        }
        return false;
    }

    public String getPolicyDescription() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDescription() != null) {
            return policy.getDescription();
        }
        return "";
    }

    public String getPolicyNotice() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getNotice();
        }
        return "";
    }

    public String getPolicyUrl() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getUrl();
        }
        return "";
    }

    public boolean isPolicyAsn1Processable() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isAsn1Processable() != null && policy.isAsn1Processable() != false;
        }
        return false;
    }

    public boolean isPolicyIdentified() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isIdentified() != null && policy.isIdentified() != false;
        }
        return false;
    }

    public boolean isPolicyStatus() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isStatus() != null && policy.isStatus() != false;
        }
        return false;
    }

    public String getSignatureFieldName() {
        XmlPDFSignatureDictionary pdfSignatureDictionary = this.signature.getPDFSignatureDictionary();
        if (pdfSignatureDictionary != null) {
            return pdfSignatureDictionary.getSignatureFieldName();
        }
        return null;
    }

    public String getSignerName() {
        XmlPDFSignatureDictionary pdfSignatureDictionary = this.signature.getPDFSignatureDictionary();
        if (pdfSignatureDictionary != null) {
            return pdfSignatureDictionary.getSignerName();
        }
        return null;
    }

    public String getFilter() {
        XmlPDFSignatureDictionary pdfSignatureDictionary = this.signature.getPDFSignatureDictionary();
        if (pdfSignatureDictionary != null) {
            return pdfSignatureDictionary.getFilter();
        }
        return null;
    }

    public String getSubFilter() {
        XmlPDFSignatureDictionary pdfSignatureDictionary = this.signature.getPDFSignatureDictionary();
        if (pdfSignatureDictionary != null) {
            return pdfSignatureDictionary.getSubFilter();
        }
        return null;
    }

    public String getContactInfo() {
        XmlPDFSignatureDictionary pdfSignatureDictionary = this.signature.getPDFSignatureDictionary();
        if (pdfSignatureDictionary != null) {
            return pdfSignatureDictionary.getContactInfo();
        }
        return null;
    }

    public String getReason() {
        XmlPDFSignatureDictionary pdfSignatureDictionary = this.signature.getPDFSignatureDictionary();
        if (pdfSignatureDictionary != null) {
            return pdfSignatureDictionary.getReason();
        }
        return null;
    }

    public List<BigInteger> getSignatureByteRange() {
        XmlPDFSignatureDictionary pdfSignatureDictionary = this.signature.getPDFSignatureDictionary();
        if (pdfSignatureDictionary != null) {
            return pdfSignatureDictionary.getSignatureByteRange();
        }
        return null;
    }

    public byte[] getSignatureValue() {
        return this.signature.getSignatureValue();
    }

    public boolean isDocHashOnly() {
        XmlSignerDocumentRepresentations signerDocumentRepresentation = this.signature.getSignerDocumentRepresentations();
        if (signerDocumentRepresentation != null) {
            return signerDocumentRepresentation.isDocHashOnly();
        }
        return false;
    }

    public boolean isHashOnly() {
        XmlSignerDocumentRepresentations signerDocumentRepresentation = this.signature.getSignerDocumentRepresentations();
        if (signerDocumentRepresentation != null) {
            return signerDocumentRepresentation.isHashOnly();
        }
        return false;
    }

    public List<XmlFoundCertificate> getAllFoundCertificates() {
        ArrayList<XmlFoundCertificate> foundCertificates = new ArrayList<XmlFoundCertificate>();
        for (XmlFoundCertificate xmlFoundCertificate : this.getRelatedCertificates()) {
            foundCertificates.add(xmlFoundCertificate);
        }
        for (XmlFoundCertificate xmlFoundCertificate : this.getOrphanCertificates()) {
            foundCertificates.add(xmlFoundCertificate);
        }
        return foundCertificates;
    }

    public List<XmlRelatedCertificate> getRelatedCertificates() {
        return this.signature.getFoundCertificates().getRelatedCertificates();
    }

    public List<XmlOrphanCertificate> getOrphanCertificates() {
        return this.signature.getFoundCertificates().getOrphanCertificates();
    }

    public List<XmlFoundRevocation> getAllFoundRevocations() {
        ArrayList<XmlFoundRevocation> foundRevocations = new ArrayList<XmlFoundRevocation>();
        foundRevocations.addAll(this.getRelatedRevocations());
        foundRevocations.addAll(this.getOrphanRevocations());
        return foundRevocations;
    }

    public List<XmlRelatedRevocation> getRelatedRevocations() {
        return this.signature.getFoundRevocations().getRelatedRevocations();
    }

    public List<XmlOrphanRevocation> getOrphanRevocations() {
        return this.signature.getFoundRevocations().getOrphanRevocations();
    }

    public List<XmlRevocationRef> getAllFoundRevocationRefs() {
        List<XmlRevocationRef> revocationRefs = this.getAllRelatedRevocationRefs();
        revocationRefs.addAll(this.getAllOrphanRevocationRefs());
        return revocationRefs;
    }

    public List<XmlRevocationRef> getAllRelatedRevocationRefs() {
        return this.getRevocationRefsFromListOfRevocations(this.getRelatedRevocations());
    }

    public List<XmlRevocationRef> getAllOrphanRevocationRefs() {
        return this.getRevocationRefsFromListOfRevocations(this.getOrphanRevocations());
    }

    private <T extends XmlFoundRevocation> List<XmlRevocationRef> getRevocationRefsFromListOfRevocations(Collection<T> foundRevocations) {
        ArrayList<XmlRevocationRef> revocationRefs = new ArrayList<XmlRevocationRef>();
        if (foundRevocations != null) {
            for (XmlFoundRevocation revocation : foundRevocations) {
                revocationRefs.addAll(revocation.getRevocationRefs());
            }
        }
        return revocationRefs;
    }

    public List<XmlRevocationRef> getFoundRevocationRefsByOrigin(RevocationRefOrigin origin) {
        ArrayList<XmlRevocationRef> revocationRefs = new ArrayList<XmlRevocationRef>();
        for (XmlRevocationRef ref : this.getAllFoundRevocationRefs()) {
            if (!ref.getOrigins().contains(origin)) continue;
            revocationRefs.add(ref);
        }
        return revocationRefs;
    }

    public Set<XmlRelatedRevocation> getRelatedRevocationsByOrigin(RevocationOrigin originType) {
        return this.filterRevocationsByOrigin(this.getRelatedRevocations(), originType);
    }

    public Set<XmlOrphanRevocation> getOrphanRevocationsByOrigin(RevocationOrigin originType) {
        return this.filterRevocationsByOrigin(this.getOrphanRevocations(), originType);
    }

    private <T extends XmlFoundRevocation> Set<T> filterRevocationsByOrigin(List<T> revocations, RevocationOrigin originType) {
        HashSet<XmlFoundRevocation> revocationsWithOrigin = new HashSet<XmlFoundRevocation>();
        if (revocations != null) {
            for (XmlFoundRevocation relatedRevocation : revocations) {
                if (!relatedRevocation.getOrigins().contains(originType)) continue;
                revocationsWithOrigin.add(relatedRevocation);
            }
        }
        return revocationsWithOrigin;
    }

    public Set<XmlRelatedRevocation> getRelatedRevocationsByType(RevocationType type) {
        return this.filterRevocationsByType(this.getRelatedRevocations(), type);
    }

    public Set<XmlOrphanRevocation> getOrphanRevocationsByType(RevocationType type) {
        return this.filterRevocationsByType(this.getOrphanRevocations(), type);
    }

    public <T extends XmlFoundRevocation> Set<T> filterRevocationsByType(List<T> revocations, RevocationType type) {
        HashSet<XmlFoundRevocation> revocationWithType = new HashSet<XmlFoundRevocation>();
        if (revocations != null) {
            for (XmlFoundRevocation revocation : revocations) {
                if (!revocation.getType().equals((Object)type)) continue;
                revocationWithType.add(revocation);
            }
        }
        return revocationWithType;
    }

    public List<String> getRevocationIds() {
        ArrayList<String> revocationIds = new ArrayList<String>();
        List<XmlFoundRevocation> foundRevocations = this.getAllFoundRevocations();
        for (XmlFoundRevocation foundRevocation : foundRevocations) {
            if (foundRevocation instanceof XmlRelatedRevocation) {
                revocationIds.add(((XmlRelatedRevocation)foundRevocation).getRevocation().getId());
                continue;
            }
            revocationIds.add(((XmlOrphanRevocation)foundRevocation).getToken().getId());
        }
        return revocationIds;
    }

    public List<String> getRevocationIdsByType(RevocationType type) {
        ArrayList<String> revocationIds = new ArrayList<String>();
        for (XmlRelatedRevocation xmlRelatedRevocation : this.getRelatedRevocationsByType(type)) {
            revocationIds.add(xmlRelatedRevocation.getRevocation().getId());
        }
        for (XmlOrphanRevocation xmlOrphanRevocation : this.getOrphanRevocationsByType(type)) {
            revocationIds.add(xmlOrphanRevocation.getToken().getId());
        }
        return revocationIds;
    }

    public List<String> getRevocationIdsByOrigin(RevocationOrigin origin) {
        ArrayList<String> revocationIds = new ArrayList<String>();
        for (XmlRelatedRevocation xmlRelatedRevocation : this.getRelatedRevocationsByOrigin(origin)) {
            revocationIds.add(xmlRelatedRevocation.getRevocation().getId());
        }
        for (XmlOrphanRevocation xmlOrphanRevocation : this.getOrphanRevocationsByOrigin(origin)) {
            revocationIds.add(xmlOrphanRevocation.getToken().getId());
        }
        return revocationIds;
    }

    public List<String> getRevocationIdsByTypeAndOrigin(RevocationType type, RevocationOrigin origin) {
        List<String> revocationIds = this.getRevocationIdsByType(type);
        revocationIds.retainAll(this.getRevocationIdsByOrigin(origin));
        return revocationIds;
    }

    public List<String> getFoundCertificateIds(CertificateOrigin origin) {
        ArrayList<String> result = new ArrayList<String>();
        XmlFoundCertificates foundCertificates = this.signature.getFoundCertificates();
        if (foundCertificates != null) {
            for (XmlRelatedCertificate xmlRelatedCertificate : foundCertificates.getRelatedCertificates()) {
                if (!xmlRelatedCertificate.getOrigins().contains(origin)) continue;
                result.add(xmlRelatedCertificate.getCertificate().getId());
            }
            for (XmlOrphanCertificate xmlOrphanCertificate : foundCertificates.getOrphanCertificates()) {
                if (!xmlOrphanCertificate.getOrigins().contains(origin)) continue;
                result.add(xmlOrphanCertificate.getToken().getId());
            }
        }
        return result;
    }

    public List<XmlRelatedCertificate> getRelatedCertificatesByOrigin(CertificateOrigin origin) {
        ArrayList<XmlRelatedCertificate> certificatesByOrigin = new ArrayList<XmlRelatedCertificate>();
        XmlFoundCertificates foundCertificates = this.signature.getFoundCertificates();
        if (foundCertificates != null) {
            for (XmlRelatedCertificate foundCertificate : foundCertificates.getRelatedCertificates()) {
                if (!foundCertificate.getOrigins().contains(origin)) continue;
                certificatesByOrigin.add(foundCertificate);
            }
        }
        return certificatesByOrigin;
    }

    public List<XmlFoundCertificate> getFoundCertificatesByRefOrigin(CertificateRefOrigin origin) {
        ArrayList<XmlFoundCertificate> certificatesByLocation = new ArrayList<XmlFoundCertificate>();
        for (XmlFoundCertificate foundCertificate : this.getAllFoundCertificates()) {
            for (XmlCertificateRef certificateRef : foundCertificate.getCertificateRefs()) {
                if (!origin.equals((Object)certificateRef.getOrigin())) continue;
                certificatesByLocation.add(foundCertificate);
            }
        }
        return certificatesByLocation;
    }

    @Override
    public byte[] getBinaries() {
        return this.signature.getSignatureValue();
    }
}

