/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.OrphanTokenType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TimestampWrapper
extends AbstractTokenProxy {
    private final XmlTimestamp timestamp;

    public TimestampWrapper(XmlTimestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getId() {
        return this.timestamp.getId();
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.timestamp.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.timestamp.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.timestamp.getSigningCertificate();
    }

    public TimestampType getType() {
        return this.timestamp.getType();
    }

    public ArchiveTimestampType getArchiveTimestampType() {
        return this.timestamp.getArchiveTimestampType();
    }

    public Date getProductionTime() {
        return this.timestamp.getProductionTime();
    }

    public XmlDigestMatcher getMessageImprint() {
        return this.timestamp.getDigestMatcher();
    }

    public boolean isMessageImprintDataFound() {
        return this.getMessageImprint().isDataFound();
    }

    public boolean isMessageImprintDataIntact() {
        return this.getMessageImprint().isDataIntact();
    }

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return Collections.singletonList(this.getMessageImprint());
    }

    public List<XmlTimestampedObject> getTimestampedObjects() {
        return this.timestamp.getTimestampedObjects();
    }

    public List<String> getTimestampedSignatureIds() {
        return this.getTimestampedObjectByCategory(TimestampedObjectType.SIGNATURE);
    }

    public List<String> getTimestampedCertificateIds() {
        List<String> timestampedObjectIds = this.getTimestampedObjectByCategory(TimestampedObjectType.CERTIFICATE);
        timestampedObjectIds.addAll(this.getTimestampedOrphanTokenIdsByType(OrphanTokenType.CERTIFICATE));
        return timestampedObjectIds;
    }

    public List<String> getTimestampedRevocationIds() {
        List<String> timestampedObjectIds = this.getTimestampedObjectByCategory(TimestampedObjectType.REVOCATION);
        timestampedObjectIds.addAll(this.getTimestampedOrphanTokenIdsByType(OrphanTokenType.REVOCATION));
        return timestampedObjectIds;
    }

    public List<String> getTimestampedTimestampIds() {
        return this.getTimestampedObjectByCategory(TimestampedObjectType.TIMESTAMP);
    }

    public List<String> getTimestampedSignedDataIds() {
        return this.getTimestampedObjectByCategory(TimestampedObjectType.SIGNED_DATA);
    }

    private List<String> getTimestampedObjectByCategory(TimestampedObjectType category) {
        ArrayList<String> timestampedObjectIds = new ArrayList<String>();
        for (XmlTimestampedObject timestampedObject : this.getTimestampedObjects()) {
            if (category != timestampedObject.getCategory()) continue;
            timestampedObjectIds.add(timestampedObject.getToken().getId());
        }
        return timestampedObjectIds;
    }

    public List<String> getAllTimestampedOrphanTokenIds() {
        return this.getTimestampedOrphanTokenIdsByType(null);
    }

    public List<String> getTimestampedOrphanTokenIdsByType(OrphanTokenType tokenType) {
        ArrayList<String> timestampedObjectIds = new ArrayList<String>();
        for (XmlTimestampedObject timestampedObject : this.getTimestampedObjects()) {
            if (TimestampedObjectType.ORPHAN != timestampedObject.getCategory()) continue;
            XmlOrphanToken orphanToken = (XmlOrphanToken)timestampedObject.getToken();
            if (tokenType != null && !tokenType.equals((Object)orphanToken.getType())) continue;
            timestampedObjectIds.add(orphanToken.getId());
        }
        return timestampedObjectIds;
    }

    @Override
    public byte[] getBinaries() {
        return this.timestamp.getBase64Encoded();
    }

    public XmlDigestAlgoAndValue getDigestAlgoAndValue() {
        return this.timestamp.getDigestAlgoAndValue();
    }
}

