/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaselineBCertificateSelector {
    private static final Logger LOG = LoggerFactory.getLogger(BaselineBCertificateSelector.class);
    private final CertificateVerifier certificateVerifier;
    private final AbstractSignatureParameters parameters;

    public BaselineBCertificateSelector(CertificateVerifier certificateVerifier, AbstractSignatureParameters parameters) {
        this.certificateVerifier = certificateVerifier;
        this.parameters = parameters;
    }

    public List<CertificateToken> getCertificates() {
        List<CertificateToken> orderedCertificates = this.order(this.getAllCertificatesOnce());
        CertificateSource trustedCertSource = this.certificateVerifier.getTrustedCertSource();
        if (this.parameters.bLevel().isTrustAnchorBPPolicy() && trustedCertSource != null) {
            LinkedList<CertificateToken> result = new LinkedList<CertificateToken>();
            for (CertificateToken certificateToken : orderedCertificates) {
                if (!trustedCertSource.get(certificateToken.getSubjectX500Principal()).isEmpty()) break;
                result.add(certificateToken);
            }
            return result;
        }
        return orderedCertificates;
    }

    private List<CertificateToken> getAllCertificatesOnce() {
        List<CertificateToken> certificateChain;
        ArrayList<CertificateToken> result = new ArrayList<CertificateToken>();
        CertificateToken signingCertificate = this.parameters.getSigningCertificate();
        if (signingCertificate != null) {
            result.add(signingCertificate);
        }
        if (Utils.isCollectionNotEmpty(certificateChain = this.parameters.getCertificateChain())) {
            for (CertificateToken certificateToken : certificateChain) {
                if (certificateToken == null || result.contains(certificateToken)) continue;
                result.add(certificateToken);
            }
        }
        return result;
    }

    private List<CertificateToken> order(List<CertificateToken> certificates) {
        for (CertificateToken token : certificates) {
            if (token.isSelfSigned() || token.getIssuerToken() != null) continue;
            for (CertificateToken signer : certificates) {
                if (!token.isSignedBy(signer)) continue;
                LOG.debug("{} is signed by {}", (Object)token.getDSSIdAsString(), (Object)signer.getDSSIdAsString());
                break;
            }
            if (token.isSelfSigned() || token.getIssuerToken() != null) continue;
            LOG.warn("Issuer not found for certificate {}", (Object)token.getDSSIdAsString());
        }
        LinkedList<CertificateToken> result = new LinkedList<CertificateToken>();
        for (CertificateToken certToAdd = this.getSigningCertificate(certificates); certToAdd != null; certToAdd = certToAdd.getIssuerToken()) {
            result.add(certToAdd);
        }
        if (certificates.size() != result.size()) {
            LOG.warn("Some certificates are ignored");
            LOG.warn("Before : {}", certificates);
            LOG.warn("After : {}", result);
        }
        return result;
    }

    private CertificateToken getSigningCertificate(List<CertificateToken> certificates) {
        ArrayList<CertificateToken> potentialSigners = new ArrayList<CertificateToken>();
        for (CertificateToken signer : certificates) {
            boolean isSigner = false;
            for (CertificateToken token : certificates) {
                if (!signer.equals((Object)token.getIssuerToken())) continue;
                isSigner = true;
                break;
            }
            if (isSigner) continue;
            potentialSigners.add(signer);
        }
        if (Utils.isCollectionEmpty(potentialSigners)) {
            throw new DSSException("No signing certificate found");
        }
        if (Utils.collectionSize(potentialSigners) == 1) {
            CertificateToken signer = (CertificateToken)potentialSigners.get(0);
            CertificateToken signingCertificateParam = this.parameters.getSigningCertificate();
            if (signingCertificateParam != null && !signingCertificateParam.equals((Object)signer)) {
                LOG.warn("Identified signer is different than parameter");
            }
            return signer;
        }
        LOG.warn("More than one identified signers");
        CertificateToken signingCertificateParam = this.parameters.getSigningCertificate();
        if (signingCertificateParam != null && potentialSigners.contains(signingCertificateParam)) {
            return signingCertificateParam;
        }
        return (CertificateToken)potentialSigners.get(0);
    }
}

