/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AbstractSignaturePolicyValidator;
import eu.europa.esig.dss.x509.SignaturePolicy;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicASNSignaturePolicyValidator
extends AbstractSignaturePolicyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(BasicASNSignaturePolicyValidator.class);

    @Override
    public void validate() {
        SignaturePolicy signaturePolicy = this.getSignaturePolicy();
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        byte[] policyBytes = DSSUtils.toByteArray((DSSDocument)policyContent);
        String digestValue = signaturePolicy.getDigestValue();
        DigestAlgorithm signPolicyHashAlgFromSignature = signaturePolicy.getDigestAlgorithm();
        this.setStatus(true);
        this.setIdentified(true);
        try {
            ASN1Sequence asn1Sequence = (ASN1Sequence)DSSASN1Utils.toASN1Primitive((byte[])policyBytes);
            if (asn1Sequence != null) {
                this.setAsn1Processable(true);
                ASN1Sequence signPolicyHashAlgObject = (ASN1Sequence)asn1Sequence.getObjectAt(0);
                AlgorithmIdentifier signPolicyHashAlgIdentifier = AlgorithmIdentifier.getInstance((Object)signPolicyHashAlgObject);
                DigestAlgorithm signPolicyHashAlgFromPolicy = DigestAlgorithm.forOID((String)signPolicyHashAlgIdentifier.getAlgorithm().getId());
                if (!signPolicyHashAlgFromPolicy.equals((Object)signPolicyHashAlgFromSignature)) {
                    this.addError("general", "The digest algorithm indicated in the SignPolicyHashAlg from the resulting document (" + signPolicyHashAlgFromPolicy + ") is not equal to the digest " + "algorithm (" + signPolicyHashAlgFromSignature + ").");
                    this.setDigestAlgorithmsEqual(false);
                    this.setStatus(false);
                    return;
                }
                this.setDigestAlgorithmsEqual(true);
                String recalculatedDigestValue = Utils.toBase64((byte[])DSSASN1Utils.getAsn1SignaturePolicyDigest((DigestAlgorithm)signPolicyHashAlgFromPolicy, (byte[])policyBytes));
                boolean equal = Utils.areStringsEqual((String)digestValue, (String)recalculatedDigestValue);
                this.setStatus(equal);
                if (!equal) {
                    this.addError("general", "The policy digest value (" + digestValue + ") does not match the re-calculated digest value (" + recalculatedDigestValue + ").");
                    return;
                }
                ASN1OctetString signPolicyHash = (ASN1OctetString)asn1Sequence.getObjectAt(2);
                String policyDigestValueFromPolicy = Utils.toBase64((byte[])signPolicyHash.getOctets());
                equal = Utils.areStringsEqual((String)digestValue, (String)policyDigestValueFromPolicy);
                this.setStatus(equal);
                if (!equal) {
                    this.addError("general", "The policy digest value (" + digestValue + ") does not match the digest value from the policy file (" + policyDigestValueFromPolicy + ").");
                }
            }
        }
        catch (Exception e) {
            this.setStatus(false);
            this.addError("general", e.getMessage());
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean canValidate() {
        SignaturePolicy policy = this.getSignaturePolicy();
        if (policy.getPolicyContent() != null) {
            byte firstByte = DSSUtils.readFirstByte((DSSDocument)policy.getPolicyContent());
            return DSSASN1Utils.isASN1SequenceTag((byte)firstByte);
        }
        return false;
    }
}

