/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb;

import eu.europa.esig.dss.jaxb.SchemaFactoryBuilder;
import eu.europa.esig.dss.jaxb.TransformerFactoryBuilder;
import eu.europa.esig.dss.jaxb.ValidatorConfigurator;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public final class XmlDefinerUtils {
    private static XmlDefinerUtils singleton;
    private TransformerFactoryBuilder secureTransformerFactoryBuilder = TransformerFactoryBuilder.getSecureTransformerBuilder();
    private SchemaFactoryBuilder secureSchemaFactoryBuilder = SchemaFactoryBuilder.getSecureSchemaBuilder();
    private ValidatorConfigurator secureValidatorConfigurator = ValidatorConfigurator.getSecureValidatorConfigurator();

    public static XmlDefinerUtils getInstance() {
        if (singleton == null) {
            singleton = new XmlDefinerUtils();
        }
        return singleton;
    }

    public Schema getSchema(List<Source> xsdSources) throws SAXException {
        Objects.requireNonNull(xsdSources, "XSD Source(s) must be provided");
        SchemaFactory sf = this.getSecureSchemaFactory();
        return sf.newSchema(xsdSources.toArray(new Source[xsdSources.size()]));
    }

    public void setSchemaFactoryBuilder(SchemaFactoryBuilder schemaFactoryBuilder) {
        this.secureSchemaFactoryBuilder = schemaFactoryBuilder;
    }

    public SchemaFactory getSecureSchemaFactory() throws SAXException {
        return this.secureSchemaFactoryBuilder.build();
    }

    public void setTransformerFactoryBuilder(TransformerFactoryBuilder transformerFactoryBuilder) {
        this.secureTransformerFactoryBuilder = transformerFactoryBuilder;
    }

    public TransformerFactory getSecureTransformerFactory() {
        return this.secureTransformerFactoryBuilder.build();
    }

    public void setValidatorConfigurator(ValidatorConfigurator validatorConfigurator) {
        this.secureValidatorConfigurator = validatorConfigurator;
    }

    public void configure(Validator validator) throws SAXException {
        this.secureValidatorConfigurator.configure(validator);
    }
}

