/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy;

import eu.europa.esig.dss.jaxb.parsers.AbstractJaxbFacade;
import eu.europa.esig.dss.policy.EtsiValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyXmlDefiner;
import eu.europa.esig.dss.policy.jaxb.ConstraintsParameters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;

public class ValidationPolicyFacade
extends AbstractJaxbFacade<ConstraintsParameters> {
    public static final String DEFAULT_VALIDATION_POLICY_LOCATION = "/policy/constraint.xml";
    public static final String TRUSTED_LIST_VALIDATION_POLICY_LOCATION = "/policy/tsl-constraint.xml";

    public static ValidationPolicyFacade newFacade() {
        return new ValidationPolicyFacade();
    }

    protected JAXBContext getJAXBContext() throws JAXBException {
        return ValidationPolicyXmlDefiner.getJAXBContext();
    }

    protected Schema getSchema() throws IOException, SAXException {
        return ValidationPolicyXmlDefiner.getSchema();
    }

    protected JAXBElement<ConstraintsParameters> wrap(ConstraintsParameters jaxbObject) {
        return ValidationPolicyXmlDefiner.OBJECT_FACTORY.createConstraintsParameters(jaxbObject);
    }

    public ValidationPolicy getDefaultValidationPolicy() throws JAXBException, XMLStreamException, IOException, SAXException {
        return this.getValidationPolicy((InputStream)null);
    }

    public ValidationPolicy getTrustedListValidationPolicy() throws JAXBException, XMLStreamException, IOException, SAXException {
        try (InputStream is = ValidationPolicyFacade.class.getResourceAsStream(TRUSTED_LIST_VALIDATION_POLICY_LOCATION);){
            ValidationPolicy validationPolicy = this.getValidationPolicy(is);
            return validationPolicy;
        }
    }

    public ValidationPolicy getValidationPolicy(String path) throws JAXBException, XMLStreamException, IOException, SAXException {
        try (InputStream is = ValidationPolicyFacade.class.getResourceAsStream(path);){
            ValidationPolicy validationPolicy = this.getValidationPolicy(is);
            return validationPolicy;
        }
    }

    public ValidationPolicy getValidationPolicy(InputStream is) throws JAXBException, XMLStreamException, IOException, SAXException {
        if (is == null) {
            return this.loadDefault();
        }
        return new EtsiValidationPolicy((ConstraintsParameters)this.unmarshall(is));
    }

    public ValidationPolicy getValidationPolicy(File file) throws JAXBException, XMLStreamException, IOException, SAXException {
        if (file == null) {
            return this.loadDefault();
        }
        return new EtsiValidationPolicy((ConstraintsParameters)this.unmarshall(file));
    }

    private ValidationPolicy loadDefault() throws JAXBException, XMLStreamException, IOException, SAXException {
        try (InputStream defaultIs = ValidationPolicyFacade.class.getResourceAsStream(DEFAULT_VALIDATION_POLICY_LOCATION);){
            ValidationPolicy validationPolicy = this.getValidationPolicy(defaultIs);
            return validationPolicy;
        }
    }
}

