/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.ResourceLoader;
import eu.europa.esig.dss.xades.NamespaceContextMap;
import eu.europa.esig.dss.xades.XAdESNamespaces;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class DSSXMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSXMLUtils.class);
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String XAD_ESV141_XSD = "/XAdESv141.xsd";
    private static DocumentBuilderFactory dbFactory;
    private static final XPathFactory factory;
    private static NamespaceContextMap namespacePrefixMapper;
    private static final Map<String, String> namespaces;
    private static final Set<String> transforms;
    private static final Set<String> canonicalizers;
    private static Schema schema;

    private static void registerDefaultNamespaces() {
        DSSXMLUtils.registerNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        DSSXMLUtils.registerNamespace("dsig", "http://www.w3.org/2000/09/xmldsig#");
        DSSXMLUtils.registerNamespace("xades", XAdESNamespaces.XAdES);
        DSSXMLUtils.registerNamespace("xades141", "http://uri.etsi.org/01903/v1.4.1#");
        DSSXMLUtils.registerNamespace("xades122", "http://uri.etsi.org/01903/v1.2.2#");
        DSSXMLUtils.registerNamespace("xades111", "http://uri.etsi.org/01903/v1.1.1#");
        DSSXMLUtils.registerNamespace("asic", "http://uri.etsi.org/02918/v1.2.1#");
    }

    private static void registerDefaultTransforms() {
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#base64");
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransform("http://www.w3.org/2002/06/xmldsig-filter2");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/2001/WD-xptr-20010108");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xslt-19991116");
    }

    private static void registerDefaultCanonicalizers() {
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11");
        DSSXMLUtils.registerCanonicalizer("http://santuario.apache.org/c14n/physical");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11#WithComments");
    }

    private DSSXMLUtils() {
    }

    public static boolean registerNamespace(String prefix, String namespace) {
        String put = namespaces.put(prefix, namespace);
        namespacePrefixMapper.registerNamespace(prefix, namespace);
        return put == null;
    }

    public static boolean registerTransform(String transformURI) {
        boolean added = transforms.add(transformURI);
        return added;
    }

    public static boolean registerCanonicalizer(String c14nAlgorithmURI) {
        boolean added = canonicalizers.add(c14nAlgorithmURI);
        return added;
    }

    private static XPathExpression createXPathExpression(String xpathString) {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(namespacePrefixMapper);
        try {
            XPathExpression expr = xpath.compile(xpathString);
            return expr;
        }
        catch (XPathExpressionException ex) {
            throw new DSSException((Throwable)ex);
        }
    }

    public static Element getElement(Node xmlNode, String xPathString) {
        return (Element)DSSXMLUtils.getNode(xmlNode, xPathString);
    }

    public static Node getNode(Node xmlNode, String xPathString) {
        NodeList list = DSSXMLUtils.getNodeList(xmlNode, xPathString);
        if (list.getLength() > 1) {
            throw new DSSException("More than one result for XPath: " + xPathString);
        }
        return list.item(0);
    }

    public static List<String> getChildrenNames(Node xmlNode, String xPathString) {
        ArrayList<String> childrenNames = new ArrayList<String>();
        Element element = DSSXMLUtils.getElement(xmlNode, xPathString);
        if (element != null) {
            NodeList unsignedProperties = element.getChildNodes();
            for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
                Node node = unsignedProperties.item(ii);
                childrenNames.add(node.getLocalName());
            }
        }
        return childrenNames;
    }

    public static NodeList getNodeList(Node xmlNode, String xPathString) {
        try {
            XPathExpression expr = DSSXMLUtils.createXPathExpression(xPathString);
            NodeList evaluated = (NodeList)expr.evaluate(xmlNode, XPathConstants.NODESET);
            return evaluated;
        }
        catch (XPathExpressionException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static String getValue(Node xmlNode, String xPathString) {
        try {
            XPathExpression xPathExpression = DSSXMLUtils.createXPathExpression(xPathString);
            String string = (String)xPathExpression.evaluate(xmlNode, XPathConstants.STRING);
            return string.trim();
        }
        catch (XPathExpressionException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static boolean isNotEmpty(Node xmlNode, String xPathString) {
        NodeList nodeList = DSSXMLUtils.getNodeList(xmlNode, xPathString + "/child::node()[not(self::text())]");
        return nodeList != null && nodeList.getLength() > 0;
    }

    public static byte[] serializeNode(Node xmlNode) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(buffer);
            writer.write(xmlNode, output);
            byte[] bytes = buffer.toByteArray();
            return bytes;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static void recursiveIdBrowse(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            DSSXMLUtils.setIDIdentifier(childElement);
            DSSXMLUtils.recursiveIdBrowse(childElement);
        }
    }

    public static String getIDIdentifier(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String id;
            Node item = attributes.item(jj);
            String localName = item.getNodeName();
            if (localName == null || !ID_ATTRIBUTE_NAME.equals(id = localName.toLowerCase())) continue;
            return item.getTextContent();
        }
        return null;
    }

    public static void setIDIdentifier(DOMValidateContext context, Element childElement) {
        NamedNodeMap attributes = childElement.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String id;
            Node item = attributes.item(jj);
            String localName = item.getNodeName();
            if (localName == null || !ID_ATTRIBUTE_NAME.equals(id = localName.toLowerCase())) continue;
            context.setIdAttributeNS(childElement, null, localName);
            break;
        }
    }

    public static void setIDIdentifier(Element childElement) {
        NamedNodeMap attributes = childElement.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String id;
            Node item = attributes.item(jj);
            String localName = item.getNodeName();
            if (localName == null || !ID_ATTRIBUTE_NAME.equals(id = localName.toLowerCase())) continue;
            childElement.setIdAttribute(localName, true);
            break;
        }
    }

    private static void ensureDocumentBuilder() throws DSSException {
        if (dbFactory != null) {
            return;
        }
        dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        try {
            dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbFactory.setXIncludeAware(false);
            dbFactory.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static TransformerFactory getSecureTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            throw new DSSException((Throwable)e);
        }
        return transformerFactory;
    }

    public static Document buildDOM() {
        DSSXMLUtils.ensureDocumentBuilder();
        try {
            return dbFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static Document buildDOM(String xmlString) throws DSSException {
        ByteArrayInputStream input = new ByteArrayInputStream(DSSUtils.getUtf8Bytes((String)xmlString));
        return DSSXMLUtils.buildDOM(input);
    }

    public static Document buildDOM(byte[] bytes) throws DSSException {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return DSSXMLUtils.buildDOM(input);
    }

    public static Document buildDOM(InputStream inputStream) throws DSSException {
        try {
            Document rootElement;
            DSSXMLUtils.ensureDocumentBuilder();
            Document document = rootElement = dbFactory.newDocumentBuilder().parse(inputStream);
            return document;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildDOM(DSSDocument dssDocument) throws DSSException {
        InputStream input = dssDocument.openStream();
        try {
            Document doc;
            Document document = doc = DSSXMLUtils.buildDOM(input);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static boolean canCanonicalize(String canonicalizationMethod) {
        if (transforms.contains(canonicalizationMethod)) {
            return false;
        }
        boolean contains = canonicalizers.contains(canonicalizationMethod);
        return contains;
    }

    public static byte[] canonicalize(String canonicalizationMethod, byte[] toCanonicalizeBytes) throws DSSException {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)canonicalizationMethod);
            return c14n.canonicalize(toCanonicalizeBytes);
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static byte[] canonicalizeSubtree(String canonicalizationMethod, Node node) {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)canonicalizationMethod);
            byte[] canonicalized = c14n.canonicalizeSubtree(node);
            return canonicalized;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static byte[] canonicalizeXPathNodeSet(String canonicalizationMethod, Set<Node> nodeList) {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)canonicalizationMethod);
            byte[] canonicalized = c14n.canonicalizeXPathNodeSet(nodeList);
            return canonicalized;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static Element addTextElement(Document document, Element parentDom, String namespace, String name, String value) {
        Element dom = document.createElementNS(namespace, name);
        parentDom.appendChild(dom);
        Text valueNode = document.createTextNode(value);
        dom.appendChild(valueNode);
        return dom;
    }

    public static Element addElement(Document document, Element parentDom, String namespace, String name) {
        Element dom = document.createElementNS(namespace, name);
        parentDom.appendChild(dom);
        return dom;
    }

    public static byte[] transformDomToByteArray(Document documentDom) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            String xmlEncoding = documentDom.getXmlEncoding();
            if (StringUtils.isNotBlank((String)xmlEncoding)) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            DOMSource source = new DOMSource(documentDom);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform(source, streamResult);
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            return byteArray;
        }
        catch (TransformerException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static void setTextNode(Document document, Element parentDom, String text) {
        Text textNode = document.createTextNode(text);
        parentDom.appendChild(textNode);
    }

    public static Document createDocument(String namespaceURI, String qualifiedName) {
        DOMImplementation domImpl;
        DSSXMLUtils.ensureDocumentBuilder();
        try {
            domImpl = dbFactory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException e) {
            throw new DSSException((Throwable)e);
        }
        return domImpl.createDocument(namespaceURI, qualifiedName, null);
    }

    public static Document createDocument(String namespaceURI, String qualifiedName, Element element) {
        DOMImplementation domImpl;
        DSSXMLUtils.ensureDocumentBuilder();
        try {
            domImpl = dbFactory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException e) {
            throw new DSSException((Throwable)e);
        }
        Document newDocument = domImpl.createDocument(namespaceURI, qualifiedName, null);
        Element newElement = newDocument.getDocumentElement();
        newDocument.adoptNode(element);
        newElement.appendChild(element);
        return newDocument;
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        try {
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            xmlGregorianCalendar.setFractionalSecond(null);
            xmlGregorianCalendar = xmlGregorianCalendar.normalize();
            return xmlGregorianCalendar;
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("Unable to properly convert a Date to an XMLGregorianCalendar " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date getDate(String text) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(text);
            return xmlGregorianCalendar.toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            return null;
        }
    }

    public static String validateAgainstXSD(StreamSource streamSource) {
        try {
            if (schema == null) {
                schema = DSSXMLUtils.getSchema();
            }
            Validator validator = schema.newValidator();
            validator.validate(streamSource);
            return "";
        }
        catch (Exception e) {
            LOG.warn("Error during the XML schema validation!", (Throwable)e);
            return e.getMessage();
        }
    }

    private static Schema getSchema() throws SAXException {
        ResourceLoader resourceLoader = new ResourceLoader();
        InputStream xadesXsd = resourceLoader.getResource(XAD_ESV141_XSD);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return factory.newSchema(new StreamSource(xadesXsd));
    }

    public static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    static {
        factory = XPathFactory.newInstance();
        Init.init();
        namespacePrefixMapper = new NamespaceContextMap();
        namespaces = new HashMap<String, String>();
        DSSXMLUtils.registerDefaultNamespaces();
        transforms = new HashSet<String>();
        DSSXMLUtils.registerDefaultTransforms();
        canonicalizers = new HashSet<String>();
        DSSXMLUtils.registerDefaultCanonicalizers();
        schema = null;
    }
}

