/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.EncryptionAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.BigIntegers;

public final class DSSSignatureUtils {
    private DSSSignatureUtils() {
    }

    public static byte[] convertToXmlDSig(EncryptionAlgorithm algorithm, byte[] signatureValue) {
        if (EncryptionAlgorithm.ECDSA == algorithm) {
            return DSSSignatureUtils.convertECDSAASN1toXMLDSIG(signatureValue);
        }
        if (EncryptionAlgorithm.DSA == algorithm) {
            return DSSSignatureUtils.convertDSAASN1toXMLDSIG(signatureValue);
        }
        return signatureValue;
    }

    private static byte[] convertECDSAASN1toXMLDSIG(byte[] binaries) {
        byte[] byArray;
        ASN1InputStream is = null;
        try {
            is = new ASN1InputStream(binaries);
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            if (seq.size() != 2) {
                throw new IllegalArgumentException("ASN1 Sequence size should be 2 !");
            }
            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
            byte[] rBytes = r.getValue().toByteArray();
            int rSize = rBytes.length;
            byte[] sBytes = s.getValue().toByteArray();
            int sSize = sBytes.length;
            int max = Math.max(rSize, sSize);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(max * 2);
            if (sSize > rSize) {
                buffer.write(0);
            }
            buffer.write(rBytes);
            if (rSize > sSize) {
                buffer.write(0);
            }
            buffer.write(sBytes);
            byArray = buffer.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new DSSException("Unable to convert to xmlDsig : " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return byArray;
    }

    private static byte[] convertDSAASN1toXMLDSIG(byte[] binaries) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ASN1InputStream is = null;
        try {
            is = new ASN1InputStream(binaries);
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            if (seq.size() != 2) {
                throw new IllegalArgumentException("ASN1 Sequence size should be 2 !");
            }
            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
            buffer.write(BigIntegers.asUnsignedByteArray((BigInteger)r.getValue()));
            buffer.write(BigIntegers.asUnsignedByteArray((BigInteger)s.getValue()));
        }
        catch (Exception e) {
            try {
                throw new DSSException("Unable to convert to xmlDsig : " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return buffer.toByteArray();
    }
}

