/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.xades.DSSTransform;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DSSTransformXPath {
    private Document document;
    private DSSTransform dssTransform;

    public DSSTransformXPath(DSSTransform dssTransform) {
        this.dssTransform = dssTransform;
        this.document = DSSXMLUtils.buildDOM();
        Element transformDom = this.document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        this.document.appendChild(transformDom);
        XAdESSignatureBuilder.createTransform(this.document, dssTransform, transformDom);
    }

    public byte[] transform(DSSDocument input) throws DSSException {
        try {
            String dssTransformAlgorithm = this.dssTransform.getAlgorithm();
            NodeList childNodes = this.document.getFirstChild().getChildNodes();
            Transform transformObject = new Transform(this.document, dssTransformAlgorithm, childNodes);
            byte[] bytes = DSSUtils.toByteArray((DSSDocument)input);
            XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(bytes);
            XMLSignatureInput xmlSignatureInputOut = transformObject.performTransform(xmlSignatureInput);
            return xmlSignatureInputOut.getBytes();
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public byte[] transform(Node input) throws DSSException {
        try {
            String dssTransformAlgorithm = this.dssTransform.getAlgorithm();
            NodeList childNodes = this.document.getFirstChild().getChildNodes();
            Transform transformObject = new Transform(this.document, dssTransformAlgorithm, childNodes);
            XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(input);
            XMLSignatureInput xmlSignatureInputOut = transformObject.performTransform(xmlSignatureInput);
            return xmlSignatureInputOut.getBytes();
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }
}

