/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSReference;
import eu.europa.esig.dss.xades.DSSTransform;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.DSSTransformXPath;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class EnvelopedSignatureBuilder
extends XAdESSignatureBuilder {
    public EnvelopedSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
        this.setCanonicalizationMethods(params, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    @Override
    protected Document buildRootDocumentDom() {
        return DSSXMLUtils.buildDOM(this.detachedDocument);
    }

    @Override
    protected Node getParentNodeOfSignature() {
        String xPathLocationString = this.params.getXPathLocationString();
        if (StringUtils.isNotEmpty((String)xPathLocationString)) {
            return DSSXMLUtils.getElement(this.documentDom, xPathLocationString);
        }
        return this.documentDom.getDocumentElement();
    }

    @Override
    protected List<DSSReference> createDefaultReferences() {
        ArrayList<DSSReference> dssReferences = new ArrayList<DSSReference>();
        DSSReference dssReference = new DSSReference();
        dssReference.setId("r-id-1");
        dssReference.setUri("");
        dssReference.setContents(this.detachedDocument);
        dssReference.setDigestMethodAlgorithm(this.params.getDigestAlgorithm());
        ArrayList<DSSTransform> dssTransformList = new ArrayList<DSSTransform>();
        DSSTransform dssTransform = new DSSTransform();
        dssTransform.setAlgorithm("http://www.w3.org/TR/1999/REC-xpath-19991116");
        dssTransform.setElementName("ds:XPath");
        dssTransform.setNamespace("http://www.w3.org/2000/09/xmldsig#");
        dssTransform.setTextContent("not(ancestor-or-self::ds:Signature)");
        dssTransformList.add(dssTransform);
        dssTransform = new DSSTransform();
        dssTransform.setAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        dssTransformList.add(dssTransform);
        dssReference.setTransforms(dssTransformList);
        dssReferences.add(dssReference);
        return dssReferences;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        DSSDocument dssDocument = reference.getContents();
        List<DSSTransform> transforms = reference.getTransforms();
        if (CollectionUtils.isEmpty(transforms)) {
            return dssDocument;
        }
        Element nodeToTransform = null;
        String uri = reference.getUri();
        if (StringUtils.isNotBlank((String)uri) && uri.startsWith("#") && !EnvelopedSignatureBuilder.isXPointer(uri)) {
            Document document = DSSXMLUtils.buildDOM(dssDocument);
            DSSXMLUtils.recursiveIdBrowse(document.getDocumentElement());
            String uri_id = uri.substring(1);
            nodeToTransform = document.getElementById(uri_id);
        }
        byte[] transformedReferenceBytes = this.applyTransformations(dssDocument, transforms, nodeToTransform);
        return new InMemoryDocument(transformedReferenceBytes);
    }

    private byte[] applyTransformations(DSSDocument dssDocument, List<DSSTransform> transforms, Node nodeToTransform) {
        byte[] transformedReferenceBytes = null;
        for (DSSTransform transform : transforms) {
            String transformAlgorithm = transform.getAlgorithm();
            if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(transformAlgorithm)) {
                DSSTransformXPath transformXPath = new DSSTransformXPath(transform);
                byte[] transformedBytes = nodeToTransform == null ? transformXPath.transform(dssDocument) : transformXPath.transform(nodeToTransform);
                dssDocument = new InMemoryDocument(transformedBytes);
                nodeToTransform = DSSXMLUtils.buildDOM(dssDocument);
                continue;
            }
            if (DSSXMLUtils.canCanonicalize(transformAlgorithm)) {
                if (nodeToTransform == null) {
                    nodeToTransform = DSSXMLUtils.buildDOM(dssDocument);
                }
                transformedReferenceBytes = DSSXMLUtils.canonicalizeSubtree(transformAlgorithm, nodeToTransform);
                break;
            }
            if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(transformAlgorithm)) continue;
            throw new DSSException("The transformation is not implemented yet, please transform the reference before signing!");
        }
        return transformedReferenceBytes;
    }

    private static boolean isXPointer(String uri) {
        boolean xPointer = uri.startsWith("#xpointer(") || uri.startsWith("#xmlns(");
        return xPointer;
    }

    protected void removeExistingSignatures(Document domDoc) {
        NodeList signatureNodeList = domDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        for (int ii = signatureNodeList.getLength() - 1; ii >= 0; --ii) {
            Element signatureDOM = (Element)signatureNodeList.item(ii);
            signatureDOM.getParentNode().removeChild(signatureDOM);
        }
    }
}

