/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSReference;
import eu.europa.esig.dss.xades.DSSTransform;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.DSSSignatureUtils;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class EnvelopingSignatureBuilder
extends XAdESSignatureBuilder {
    public EnvelopingSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
        this.setCanonicalizationMethods(params, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    @Override
    protected List<DSSReference> createDefaultReferences() {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        ArrayList<DSSTransform> transforms = new ArrayList<DSSTransform>();
        DSSTransform transform = new DSSTransform();
        transform.setAlgorithm("http://www.w3.org/2000/09/xmldsig#base64");
        transforms.add(transform);
        DSSDocument document = this.detachedDocument;
        int referenceId = 1;
        do {
            DSSReference reference = new DSSReference();
            reference.setId("r-id-" + referenceId);
            reference.setType("http://www.w3.org/2000/09/xmldsig#Object");
            reference.setUri("#o-id-" + referenceId);
            reference.setContents(document);
            reference.setDigestMethodAlgorithm(this.params.getDigestAlgorithm());
            reference.setTransforms(transforms);
            references.add(reference);
            ++referenceId;
        } while ((document = document.getNextDocument()) != null);
        return references;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        return reference.getContents();
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) throws DSSException {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSSignatureUtils.convertToXmlDSig(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Base64.encodeBase64String((byte[])signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            String base64EncodedOriginalDocument = Base64.encodeBase64String((byte[])DSSUtils.toByteArray((DSSDocument)reference.getContents()));
            Element objectDom = DSSXMLUtils.addTextElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Object", base64EncodedOriginalDocument);
            String id = reference.getUri().substring(1);
            objectDom.setAttribute("Id", id);
        }
        byte[] documentBytes = DSSXMLUtils.transformDomToByteArray(this.documentDom);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }
}

