/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESNamespaces;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.math.BigInteger;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class XAdESBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESBuilder.class);
    public static final String DS_CANONICALIZATION_METHOD = "ds:CanonicalizationMethod";
    public static final String DS_DIGEST_METHOD = "ds:DigestMethod";
    public static final String DS_DIGEST_VALUE = "ds:DigestValue";
    public static final String DS_KEY_INFO = "ds:KeyInfo";
    public static final String DS_OBJECT = "ds:Object";
    public static final String DS_REFERENCE = "ds:Reference";
    public static final String DS_SIGNATURE = "ds:Signature";
    public static final String DS_SIGNATURE_METHOD = "ds:SignatureMethod";
    public static final String DS_SIGNATURE_VALUE = "ds:SignatureValue";
    public static final String DS_SIGNED_INFO = "ds:SignedInfo";
    public static final String DS_TRANSFORM = "ds:Transform";
    public static final String DS_TRANSFORMS = "ds:Transforms";
    public static final String DS_X509_CERTIFICATE = "ds:X509Certificate";
    public static final String DS_X509_DATA = "ds:X509Data";
    public static final String DS_X509_ISSUER_NAME = "ds:X509IssuerName";
    public static final String DS_X509_SERIAL_NUMBER = "ds:X509SerialNumber";
    public static final String DS_XPATH = "ds:XPath";
    public static final String XADES_ALL_DATA_OBJECTS_TIME_STAMP = "xades:AllDataObjectsTimeStamp";
    public static final String XADES_ALL_SIGNED_DATA_OBJECTS = "xades:AllSignedDataObjects";
    public static final String XADES_COUNTER_SIGNATURE = "xades:CounterSignature";
    public static final String XADES_CERT = "xades:Cert";
    public static final String XADES_CERT_DIGEST = "xades:CertDigest";
    public static final String XADES_CERTIFICATE_VALUES = "xades:CertificateValues";
    public static final String XADES_CERTIFIED_ROLES = "xades:CertifiedRoles";
    public static final String XADES_CERTIFIED_ROLES_V2 = "xades:CertifiedRolesV2";
    public static final String XADES_CERTIFIED_ROLE = "xades:CertifiedRole";
    public static final String XADES_CITY = "xades:City";
    public static final String XADES_CLAIMED_ROLES = "xades:ClaimedRoles";
    public static final String XADES_CLAIMED_ROLE = "xades:ClaimedRole";
    public static final String XADES_COMMITMENT_TYPE_ID = "xades:CommitmentTypeId";
    public static final String XADES_COMMITMENT_TYPE_INDICATION = "xades:CommitmentTypeIndication";
    public static final String XADES_COUNTRY_NAME = "xades:CountryName";
    public static final String XADES_DATA_OBJECT_FORMAT = "xades:DataObjectFormat";
    public static final String XADES_ENCAPSULATED_TIME_STAMP = "xades:EncapsulatedTimeStamp";
    public static final String XADES_ENCAPSULATED_X509_CERTIFICATE = "xades:EncapsulatedX509Certificate";
    public static final String XADES_IDENTIFIER = "xades:Identifier";
    public static final String XADES_DESCRIPTION = "xades:Description";
    public static final String XADES_INCLUDE = "xades:Include";
    public static final String XADES_INDIVIDUAL_DATA_OBJECTS_TIME_STAMP = "xades:IndividualDataObjectsTimeStamp";
    public static final String XADES_ISSUER_SERIAL = "xades:IssuerSerial";
    public static final String XADES_ISSUER_SERIAL_V2 = "xades:IssuerSerialV2";
    public static final String XADES_MIME_TYPE = "xades:MimeType";
    public static final String XADES_POSTAL_CODE = "xades:PostalCode";
    public static final String XADES_QUALIFYING_PROPERTIES = "xades:QualifyingProperties";
    public static final String XADES_SIG_AND_REFS_TIME_STAMP = "xades:SigAndRefsTimeStamp";
    public static final String XADES_SIG_AND_REFS_TIME_STAMP_V2 = "xades:SigAndRefsTimeStampV2";
    public static final String XADES_SIG_POLICY_HASH = "xades:SigPolicyHash";
    public static final String XADES_SIG_POLICY_ID = "xades:SigPolicyId";
    public static final String XADES_SIGNATURE_POLICY_ID = "xades:SignaturePolicyId";
    public static final String XADES_SIGNATURE_POLICY_IDENTIFIER = "xades:SignaturePolicyIdentifier";
    public static final String XADES_SIGNATURE_POLICY_IMPLIED = "xades:SignaturePolicyImplied";
    public static final String XADES_SIGNATURE_POLICY_QUALIFIERS = "xades:SigPolicyQualifiers";
    public static final String XADES_SIGNATURE_POLICY_QUALIFIER = "xades:SigPolicyQualifier";
    public static final String XADES_SPURI = "xades:SPURI";
    public static final String XADES_SIGNATURE_PRODUCTION_PLACE = "xades:SignatureProductionPlace";
    public static final String XADES_SIGNATURE_PRODUCTION_PLACE_V2 = "xades:SignatureProductionPlaceV2";
    public static final String XADES_SIGNATURE_TIME_STAMP = "xades:SignatureTimeStamp";
    public static final String XADES_SIGNED_DATA_OBJECT_PROPERTIES = "xades:SignedDataObjectProperties";
    public static final String XADES_SIGNED_PROPERTIES = "xades:SignedProperties";
    public static final String XADES_SIGNED_SIGNATURE_PROPERTIES = "xades:SignedSignatureProperties";
    public static final String XADES_STREET_ADDRESS = "xades:StreetAddress";
    public static final String XADES_UNSIGNED_PROPERTIES = "xades:UnsignedProperties";
    public static final String XADES_UNSIGNED_SIGNATURE_PROPERTIES = "xades:UnsignedSignatureProperties";
    public static final String XADES_SIGNER_ROLE = "xades:SignerRole";
    public static final String XADES_SIGNER_ROLE_V2 = "xades:SignerRoleV2";
    public static final String XADES_SIGNING_TIME = "xades:SigningTime";
    public static final String XADES_STATE_OR_PROVINCE = "xades:StateOrProvince";
    public static final String XADES141_ARCHIVE_TIME_STAMP = "xades141:ArchiveTimeStamp";
    public static final String ALGORITHM = "Algorithm";
    public static final String ID = "Id";
    public static final String OBJECT_REFERENCE = "ObjectReference";
    public static final String REFERENCED_DATA = "referencedData";
    public static final String SIGNATURE = "Signature";
    public static final String TARGET = "Target";
    public static final String TYPE = "Type";
    public static final String URI = "URI";
    public static final String XMLNS_DS = "xmlns:ds";
    public static final String XMLNS_XADES = "xmlns:xades";
    public static final String HTTP_WWW_W3_ORG_2000_09_XMLDSIG_OBJECT = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String NOT_ANCESTOR_OR_SELF_DS_SIGNATURE = "not(ancestor-or-self::ds:Signature)";
    protected final XPathQueryHolder xPathQueryHolder = new XPathQueryHolder();
    protected XAdESSignatureParameters params;
    protected Document documentDom;
    protected CertificateVerifier certificateVerifier;

    public XAdESBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    protected CertificatePool getCertificatePool() {
        CertificateSource trustedCertSource = this.certificateVerifier.getTrustedCertSource();
        if (trustedCertSource != null) {
            return trustedCertSource.getCertificatePool();
        }
        return null;
    }

    protected void incorporateDigestMethod(Element parentDom, DigestAlgorithm digestAlgorithm) {
        Element digestMethodDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", DS_DIGEST_METHOD);
        String digestAlgorithmXmlId = digestAlgorithm.getXmlId();
        digestMethodDom.setAttribute(ALGORITHM, digestAlgorithmXmlId);
        parentDom.appendChild(digestMethodDom);
    }

    protected void incorporateDigestValue(Element parentDom, DigestAlgorithm digestAlgorithm, DSSDocument originalDocument) {
        Element digestValueDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", DS_DIGEST_VALUE);
        String base64EncodedDigestBytes = originalDocument.getDigest(digestAlgorithm);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Digest value {} --> {}", (Object)parentDom.getNodeName(), (Object)base64EncodedDigestBytes);
        }
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        parentDom.appendChild(digestValueDom);
    }

    protected void incorporateCertificateRef(Element signingCertificateDom, Set<CertificateToken> certificates) {
        for (CertificateToken certificate : certificates) {
            Element certDom = DSSXMLUtils.addElement(this.documentDom, signingCertificateDom, XAdESNamespaces.XAdES, XADES_CERT);
            Element certDigestDom = DSSXMLUtils.addElement(this.documentDom, certDom, XAdESNamespaces.XAdES, XADES_CERT_DIGEST);
            DigestAlgorithm signingCertificateDigestMethod = this.params.getSigningCertificateDigestMethod();
            this.incorporateDigestMethod(certDigestDom, signingCertificateDigestMethod);
            InMemoryDocument inMemoryCertificate = new InMemoryDocument(certificate.getEncoded());
            this.incorporateDigestValue(certDigestDom, signingCertificateDigestMethod, (DSSDocument)inMemoryCertificate);
            Element issuerSerialDom = DSSXMLUtils.addElement(this.documentDom, certDom, XAdESNamespaces.XAdES, XADES_ISSUER_SERIAL);
            Element x509IssuerNameDom = DSSXMLUtils.addElement(this.documentDom, issuerSerialDom, "http://www.w3.org/2000/09/xmldsig#", DS_X509_ISSUER_NAME);
            String issuerX500PrincipalName = certificate.getIssuerX500Principal().getName();
            DSSXMLUtils.setTextNode(this.documentDom, x509IssuerNameDom, issuerX500PrincipalName);
            Element x509SerialNumberDom = DSSXMLUtils.addElement(this.documentDom, issuerSerialDom, "http://www.w3.org/2000/09/xmldsig#", DS_X509_SERIAL_NUMBER);
            BigInteger serialNumber = certificate.getSerialNumber();
            String serialNumberString = new String(serialNumber.toString());
            DSSXMLUtils.setTextNode(this.documentDom, x509SerialNumberDom, serialNumberString);
        }
    }
}

