/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignaturePackaging;
import eu.europa.esig.dss.TimestampParameters;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.XAdESNamespaces;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.tsp.TimeStampToken;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESLevelBaselineT
extends ExtensionBuilder
implements SignatureExtension<XAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelBaselineT.class);
    protected TSPSource tspSource;

    public XAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateC14nMethod(Element parentDom, String signedInfoC14nMethod) {
        Element canonicalizationMethodDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodDom.setAttribute("Algorithm", signedInfoC14nMethod);
        parentDom.appendChild(canonicalizationMethodDom);
    }

    public InMemoryDocument extendSignatures(DSSDocument dssDocument, XAdESSignatureParameters params) throws DSSException {
        if (dssDocument == null) {
            throw new NullPointerException();
        }
        if (this.tspSource == null) {
            throw new NullPointerException();
        }
        this.params = params;
        ProfileParameters context = params.getContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("====> Extending: " + (dssDocument.getName() == null ? "IN MEMORY DOCUMENT" : dssDocument.getName()));
        }
        this.documentDom = DSSXMLUtils.buildDOM(dssDocument);
        NodeList signatureNodeList = this.documentDom.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodeList.getLength() == 0) {
            throw new DSSException("There is no signature to extend!");
        }
        String signatureId = null;
        SignaturePackaging signaturePackaging = params.getSignaturePackaging();
        ProfileParameters.Operation operationKind = context.getOperationKind();
        if (ProfileParameters.Operation.SIGNING.equals((Object)operationKind) && SignaturePackaging.ENVELOPED.equals((Object)signaturePackaging)) {
            signatureId = params.getDeterministicId();
        }
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            this.currentSignatureDom = (Element)signatureNodeList.item(ii);
            String currentSignatureId = this.currentSignatureDom.getAttribute("Id");
            if (signatureId != null && !signatureId.equals(currentSignatureId)) continue;
            CertificatePool certPool = new CertificatePool();
            this.xadesSignature = new XAdESSignature(this.currentSignatureDom, certPool);
            this.xadesSignature.setDetachedContents(new DSSDocument[]{params.getDetachedContent()});
            this.extendSignatureTag();
        }
        byte[] documentBytes = DSSXMLUtils.serializeNode(this.documentDom);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected void extendSignatureTag() throws DSSException {
        this.assertExtendSignaturePossible();
        this.ensureUnsignedProperties();
        this.ensureUnsignedSignatureProperties();
        this.ensureSignedDataObjectProperties();
        if (BDocTmSupport.isBdocTmSignatureProfile(this.params)) {
            return;
        }
        if (!this.xadesSignature.hasTProfile() || SignatureLevel.XAdES_BASELINE_T.equals((Object)this.params.getSignatureLevel())) {
            TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] canonicalisedValue = this.xadesSignature.getSignatureTimestampData(null, canonicalizationMethod);
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])canonicalisedValue);
            this.createXAdESTimeStampType(TimestampType.SIGNATURE_TIMESTAMP, canonicalizationMethod, digestValue);
        }
    }

    private void assertExtendSignaturePossible() throws DSSException {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_T.equals((Object)signatureLevel) && (this.xadesSignature.hasLTProfile() || this.xadesSignature.hasLTAProfile())) {
            String exceptionMessage = "Cannot extend signature. The signedData is already extended with [%s].";
            throw new DSSException(String.format("Cannot extend signature. The signedData is already extended with [%s].", "XAdES LT"));
        }
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected void incorporateCertificateValues(Element parentDom, List<CertificateToken> toIncludeCertificates) {
        if (!toIncludeCertificates.isEmpty()) {
            Element certificateValuesDom = DSSXMLUtils.addElement(this.documentDom, parentDom, XAdESNamespaces.XAdES, "xades:CertificateValues");
            CertificatePool certificatePool = this.getCertificatePool();
            boolean trustAnchorBPPolicy = this.params.bLevel().isTrustAnchorBPPolicy();
            boolean trustAnchorIncluded = false;
            int responderCertCounter = 0;
            for (CertificateToken certificateToken : toIncludeCertificates) {
                boolean isCaCert;
                List certificateTokens;
                if (trustAnchorBPPolicy && certificatePool != null && (certificateTokens = certificatePool.get(certificateToken.getSubjectX500Principal())).size() > 0) {
                    trustAnchorIncluded = true;
                }
                byte[] bytes = certificateToken.getEncoded();
                String base64EncodeCertificate = Base64.encodeBase64String((byte[])bytes);
                Element element = DSSXMLUtils.addElement(this.documentDom, certificateValuesDom, XAdESNamespaces.XAdES, "xades:EncapsulatedX509Certificate");
                boolean bl = isCaCert = certificateToken.getCertificate().getBasicConstraints() != -1;
                if (DSSASN1Utils.isOCSPSigning((CertificateToken)certificateToken) && !isCaCert) {
                    element.setAttribute("Id", this.xadesSignature.getId() + "-RESPONDER_CERT-" + responderCertCounter);
                    ++responderCertCounter;
                }
                DSSXMLUtils.setTextNode(this.documentDom, element, base64EncodeCertificate);
            }
            if (trustAnchorBPPolicy && !trustAnchorIncluded) {
                LOG.warn("The trust anchor is missing but its inclusion is required by the signature policy!");
            }
        }
    }

    public Set<CertificateToken> getCertificatesForInclusion(ValidationContext validationContext) {
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        List<CertificateToken> certWithinSignatures = this.xadesSignature.getCertificates();
        for (CertificateToken certificateToken : validationContext.getProcessedCertificates()) {
            if (certWithinSignatures.contains(certificateToken)) continue;
            certificates.add(certificateToken);
        }
        return certificates;
    }

    protected void createXAdESTimeStampType(TimestampType timestampType, String timestampC14nMethod, byte[] digestValue) throws DSSException {
        try {
            Element timeStampDom = null;
            TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            switch (timestampType) {
                case SIGNATURE_TIMESTAMP: {
                    timeStampDom = DSSXMLUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignatureTimeStamp");
                    break;
                }
                case VALIDATION_DATA_REFSONLY_TIMESTAMP: {
                    break;
                }
                case VALIDATION_DATA_TIMESTAMP: {
                    if (this.params.isEn319132()) {
                        timeStampDom = DSSXMLUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SigAndRefsTimeStampV2");
                        break;
                    }
                    timeStampDom = DSSXMLUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SigAndRefsTimeStamp");
                    break;
                }
                case ARCHIVE_TIMESTAMP: {
                    timeStampDom = DSSXMLUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, "http://uri.etsi.org/01903/v1.4.1#", "xades141:ArchiveTimeStamp");
                    timestampDigestAlgorithm = this.params.getArchiveTimestampParameters().getDigestAlgorithm();
                    break;
                }
                case ALL_DATA_OBJECTS_TIMESTAMP: {
                    timeStampDom = DSSXMLUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:AllDataObjectsTimeStamp");
                    break;
                }
                case INDIVIDUAL_DATA_OBJECTS_TIMESTAMP: {
                    timeStampDom = DSSXMLUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:IndividualDataObjectsTimeStamp");
                    break;
                }
                default: {
                    LOG.error("Unsupported timestamp type : " + timestampType);
                }
            }
            if (LOG.isDebugEnabled()) {
                String encodedDigestValue = Base64.encodeBase64String((byte[])digestValue);
                LOG.debug("Timestamp generation: " + timestampDigestAlgorithm.getName() + " / " + timestampC14nMethod + " / " + encodedDigestValue);
            }
            TimeStampToken timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, digestValue);
            byte[] timeStampTokenBytes = timeStampToken.getEncoded();
            String base64EncodedTimeStampToken = Base64.encodeBase64String((byte[])timeStampTokenBytes);
            String timestampId = UUID.randomUUID().toString();
            timeStampDom.setAttribute("Id", "TS-" + timestampId);
            this.incorporateC14nMethod(timeStampDom, timestampC14nMethod);
            Element encapsulatedTimeStampDom = DSSXMLUtils.addElement(this.documentDom, timeStampDom, XAdESNamespaces.XAdES, "xades:EncapsulatedTimeStamp");
            encapsulatedTimeStampDom.setAttribute("Id", "ETS-" + timestampId);
            DSSXMLUtils.setTextNode(this.documentDom, encapsulatedTimeStampDom, base64EncodedTimeStampToken);
        }
        catch (IOException e) {
            throw new DSSException("Error during the creation of the XAdES timestamp!", (Throwable)e);
        }
    }

    protected List<CertificateToken> getToIncludeCertificateTokens(ValidationContext valContext) {
        Set processedCertificates = valContext.getProcessedCertificates();
        List<CertificateToken> keyInfoCertificates = this.xadesSignature.getKeyInfoCertificates();
        ArrayList<CertificateToken> toIncludeCertificates = new ArrayList<CertificateToken>();
        for (CertificateToken processedCertificate : processedCertificates) {
            if (keyInfoCertificates.contains(processedCertificate)) continue;
            toIncludeCertificates.add(processedCertificate);
        }
        return toIncludeCertificates;
    }
}

