/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESNamespaces;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.w3c.dom.Element;

public class XAdESLevelC
extends XAdESLevelBaselineT {
    public XAdESLevelC(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateCRLRefs(Element completeRevocationRefsDom, Set<RevocationToken> processedRevocationTokens) throws DSSException {
        RevocationToken revocationToken;
        if (processedRevocationTokens.isEmpty()) {
            return;
        }
        boolean containsCrlToken = false;
        Iterator<RevocationToken> iterator = processedRevocationTokens.iterator();
        while (iterator.hasNext() && !(containsCrlToken = (revocationToken = iterator.next()) instanceof CRLToken)) {
        }
        if (!containsCrlToken) {
            return;
        }
        Element crlRefsDom = DSSXMLUtils.addElement(this.documentDom, completeRevocationRefsDom, XAdESNamespaces.XAdES, "xades:CRLRefs");
        for (RevocationToken revocationToken2 : processedRevocationTokens) {
            if (!(revocationToken2 instanceof CRLToken)) continue;
            X509CRL crl = ((CRLToken)revocationToken2).getX509crl();
            Element crlRefDom = DSSXMLUtils.addElement(this.documentDom, crlRefsDom, XAdESNamespaces.XAdES, "xades:CRLRef");
            Element digestAlgAndValueDom = DSSXMLUtils.addElement(this.documentDom, crlRefDom, XAdESNamespaces.XAdES, "xades:DigestAlgAndValue");
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA1;
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            InMemoryDocument inMemoryDocument = new InMemoryDocument(revocationToken2.getEncoded());
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, (DSSDocument)inMemoryDocument);
            Element crlIdentifierDom = DSSXMLUtils.addElement(this.documentDom, crlRefDom, XAdESNamespaces.XAdES, "xades:CRLIdentifier");
            String issuerX500PrincipalName = crl.getIssuerX500Principal().getName();
            DSSXMLUtils.addTextElement(this.documentDom, crlIdentifierDom, XAdESNamespaces.XAdES, "xades:Issuer", issuerX500PrincipalName);
            Date thisUpdate = crl.getThisUpdate();
            XMLGregorianCalendar xmlGregorianCalendar = DSSXMLUtils.createXMLGregorianCalendar(thisUpdate);
            String thisUpdateAsXmlFormat = xmlGregorianCalendar.toXMLFormat();
            DSSXMLUtils.addTextElement(this.documentDom, crlIdentifierDom, XAdESNamespaces.XAdES, "xades:IssueTime", thisUpdateAsXmlFormat);
        }
    }

    private void incorporateOCSPRefs(Element completeRevocationRefsDom, Set<RevocationToken> processedRevocationTokens) throws DSSException {
        RevocationToken revocationToken;
        if (processedRevocationTokens.isEmpty()) {
            return;
        }
        boolean containsOCSPToken = false;
        Iterator<RevocationToken> iterator = processedRevocationTokens.iterator();
        while (iterator.hasNext() && !(containsOCSPToken = (revocationToken = iterator.next()) instanceof OCSPToken)) {
        }
        if (!containsOCSPToken) {
            return;
        }
        Element ocspRefsDom = DSSXMLUtils.addElement(this.documentDom, completeRevocationRefsDom, XAdESNamespaces.XAdES, "xades:OCSPRefs");
        for (RevocationToken revocationToken2 : processedRevocationTokens) {
            if (!(revocationToken2 instanceof OCSPToken)) continue;
            BasicOCSPResp basicOcspResp = ((OCSPToken)revocationToken2).getBasicOCSPResp();
            Element ocspRefDom = DSSXMLUtils.addElement(this.documentDom, ocspRefsDom, XAdESNamespaces.XAdES, "xades:OCSPRef");
            Element ocspIdentifierDom = DSSXMLUtils.addElement(this.documentDom, ocspRefDom, XAdESNamespaces.XAdES, "xades:OCSPIdentifier");
            Element responderIDDom = DSSXMLUtils.addElement(this.documentDom, ocspIdentifierDom, XAdESNamespaces.XAdES, "xades:ResponderID");
            RespID responderId = basicOcspResp.getResponderId();
            ResponderID responderIdAsASN1Object = responderId.toASN1Primitive();
            DERTaggedObject derTaggedObject = (DERTaggedObject)responderIdAsASN1Object.toASN1Primitive();
            if (2 == derTaggedObject.getTagNo()) {
                ASN1OctetString keyHashOctetString = (ASN1OctetString)derTaggedObject.getObject();
                byte[] keyHashOctetStringBytes = keyHashOctetString.getOctets();
                String base65EncodedKeyHashOctetStringBytes = Base64.encodeBase64String((byte[])keyHashOctetStringBytes);
                DSSXMLUtils.addTextElement(this.documentDom, responderIDDom, XAdESNamespaces.XAdES, "xades:ByKey", base65EncodedKeyHashOctetStringBytes);
            } else {
                ASN1Primitive derObject = derTaggedObject.getObject();
                X500Name name = X500Name.getInstance((Object)derObject);
                DSSXMLUtils.addTextElement(this.documentDom, responderIDDom, XAdESNamespaces.XAdES, "xades:ByName", name.toString());
            }
            Date producedAt = basicOcspResp.getProducedAt();
            XMLGregorianCalendar xmlGregorianCalendar = DSSXMLUtils.createXMLGregorianCalendar(producedAt);
            String producedAtXmlEncoded = xmlGregorianCalendar.toXMLFormat();
            DSSXMLUtils.addTextElement(this.documentDom, ocspIdentifierDom, XAdESNamespaces.XAdES, "xades:ProducedAt", producedAtXmlEncoded);
            Element digestAlgAndValueDom = DSSXMLUtils.addElement(this.documentDom, ocspRefDom, XAdESNamespaces.XAdES, "xades:DigestAlgAndValue");
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA1;
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            InMemoryDocument inMemoryDocument = new InMemoryDocument(revocationToken2.getEncoded());
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, (DSSDocument)inMemoryDocument);
        }
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (!this.xadesSignature.hasCProfile() || SignatureLevel.XAdES_C.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel)) {
            ValidationContext validationContext = this.xadesSignature.getSignatureValidationContext(this.certificateVerifier);
            Element toRemove = this.xadesSignature.getCompleteCertificateRefs();
            if (toRemove != null) {
                this.unsignedSignaturePropertiesDom.removeChild(toRemove);
            }
            Element completeCertificateRefsDom = DSSXMLUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:CompleteCertificateRefs");
            Element certRefsDom = DSSXMLUtils.addElement(this.documentDom, completeCertificateRefsDom, XAdESNamespaces.XAdES, "xades:CertRefs");
            CertificateToken certificateToken = this.xadesSignature.getSigningCertificateToken();
            Set processedCertificateTokens = validationContext.getProcessedCertificates();
            HashSet<CertificateToken> processedCertificateTokenList = new HashSet<CertificateToken>();
            processedCertificateTokenList.addAll(processedCertificateTokens);
            processedCertificateTokenList.remove(certificateToken);
            HashSet<CertificateToken> x509CertificateProcessedList = processedCertificateTokenList;
            this.incorporateCertificateRef(certRefsDom, x509CertificateProcessedList);
            toRemove = this.xadesSignature.getCompleteRevocationRefs();
            if (toRemove != null) {
                this.unsignedSignaturePropertiesDom.removeChild(toRemove);
            }
            Element completeRevocationRefsDom = DSSXMLUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:CompleteRevocationRefs");
            this.incorporateCRLRefs(completeRevocationRefsDom, validationContext.getProcessedRevocations());
            this.incorporateOCSPRefs(completeRevocationRefsDom, validationContext.getProcessedRevocations());
        }
    }
}

