/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.Policy;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignerLocation;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.TimestampInclude;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.xades.DSSReference;
import eu.europa.esig.dss.xades.DSSTransform;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.XAdESNamespaces;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.DSSSignatureUtils;
import eu.europa.esig.dss.xades.signature.DetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopingSignatureBuilder;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XAdESSignatureBuilder
extends XAdESBuilder
implements SignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureBuilder.class);
    protected boolean built = false;
    protected DSSDocument detachedDocument;
    protected String signedInfoCanonicalizationMethod;
    protected String signedPropertiesCanonicalizationMethod;
    protected String deterministicId;
    protected Element signatureDom;
    protected Element signedInfoDom;
    protected Element signatureValueDom;
    protected Element qualifyingPropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedSignaturePropertiesDom;
    protected Element signedDataObjectPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;

    public static XAdESSignatureBuilder getSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        switch (params.getSignaturePackaging()) {
            case ENVELOPED: {
                return new EnvelopedSignatureBuilder(params, document, certificateVerifier);
            }
            case ENVELOPING: {
                return new EnvelopingSignatureBuilder(params, document, certificateVerifier);
            }
            case DETACHED: {
                return new DetachedSignatureBuilder(params, document, certificateVerifier);
            }
        }
        throw new DSSException("Unsupported packaging " + params.getSignaturePackaging());
    }

    public XAdESSignatureBuilder(XAdESSignatureParameters params, DSSDocument detachedDocument, CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.params = params;
        this.detachedDocument = detachedDocument;
    }

    protected void setCanonicalizationMethods(XAdESSignatureParameters params, String canonicalizationMethod) {
        String signedInfoCanonicalizationMethod_ = params.getSignedInfoCanonicalizationMethod();
        this.signedInfoCanonicalizationMethod = StringUtils.isNotBlank((String)signedInfoCanonicalizationMethod_) ? signedInfoCanonicalizationMethod_ : canonicalizationMethod;
        String signedPropertiesCanonicalizationMethod_ = params.getSignedPropertiesCanonicalizationMethod();
        this.signedPropertiesCanonicalizationMethod = StringUtils.isNotBlank((String)signedPropertiesCanonicalizationMethod_) ? signedPropertiesCanonicalizationMethod_ : canonicalizationMethod;
    }

    public byte[] build() throws DSSException {
        this.documentDom = this.buildRootDocumentDom();
        this.deterministicId = this.params.getDeterministicId();
        List<DSSReference> references = this.params.getReferences();
        if (CollectionUtils.isEmpty(references)) {
            List<DSSReference> defaultReferences = this.createDefaultReferences();
            this.params.setReferences(defaultReferences);
        }
        this.incorporateSignatureDom();
        this.incorporateSignedInfo();
        this.incorporateSignatureValue();
        this.incorporateKeyInfo();
        this.incorporateObject();
        this.incorporateReferences();
        this.incorporateReferenceSignedProperties();
        byte[] canonicalizedSignedInfo = DSSXMLUtils.canonicalizeSubtree(this.signedInfoCanonicalizationMethod, this.signedInfoDom);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalized SignedInfo         --> {}", (Object)new String(canonicalizedSignedInfo));
            byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA256, (byte[])canonicalizedSignedInfo);
            LOG.trace("Canonicalized SignedInfo SHA256  --> {}", (Object)Base64.encodeBase64String((byte[])digest));
        }
        this.built = true;
        return canonicalizedSignedInfo;
    }

    protected Document buildRootDocumentDom() {
        return DSSXMLUtils.buildDOM();
    }

    public void incorporateSignatureDom() {
        this.signatureDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
        this.signatureDom.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        this.signatureDom.setAttribute("Id", this.deterministicId);
        Node parentNodeOfSignature = this.getParentNodeOfSignature();
        parentNodeOfSignature.appendChild(this.signatureDom);
    }

    protected Node getParentNodeOfSignature() {
        return this.documentDom;
    }

    public void incorporateSignedInfo() {
        this.signedInfoDom = DSSXMLUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo");
        this.incorporateCanonicalizationMethod(this.signedInfoDom, this.signedInfoCanonicalizationMethod);
        Element signatureMethod = DSSXMLUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod");
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        DigestAlgorithm digestAlgorithm = this.params.getDigestAlgorithm();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm);
        String signatureAlgorithmXMLId = signatureAlgorithm.getXMLId();
        signatureMethod.setAttribute("Algorithm", signatureAlgorithmXMLId);
    }

    private void incorporateCanonicalizationMethod(Element parentDom, String signedInfoCanonicalizationMethod) {
        Element canonicalizationMethodDom = DSSXMLUtils.addElement(this.documentDom, parentDom, "http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodDom.setAttribute("Algorithm", signedInfoCanonicalizationMethod);
    }

    private void incorporateReferences() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            this.incorporateReference(reference);
        }
    }

    protected void incorporateKeyInfo() throws DSSException {
        Element keyInfoDom = DSSXMLUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        Element x509DataDom = DSSXMLUtils.addElement(this.documentDom, keyInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
        boolean trustAnchorBPPolicy = this.params.bLevel().isTrustAnchorBPPolicy();
        CertificatePool certificatePool = this.getCertificatePool();
        HashSet<CertificateToken> certificateChains = new HashSet<CertificateToken>();
        certificateChains.add(this.params.getSigningCertificate());
        certificateChains.addAll(this.params.getCertificateChain());
        for (CertificateToken x509Certificate : certificateChains) {
            if (trustAnchorBPPolicy && certificatePool != null && !certificatePool.get(x509Certificate.getSubjectX500Principal()).isEmpty()) continue;
            this.addCertificate(x509DataDom, x509Certificate);
        }
    }

    private void addCertificate(Element x509DataDom, CertificateToken x509Certificate) {
        byte[] encoded = x509Certificate.getEncoded();
        String base64Encoded = Base64.encodeBase64String((byte[])encoded);
        DSSXMLUtils.addTextElement(this.documentDom, x509DataDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509Certificate", base64Encoded);
    }

    protected void incorporateObject() throws DSSException {
        Element objectDom = DSSXMLUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Object");
        this.qualifyingPropertiesDom = DSSXMLUtils.addElement(this.documentDom, objectDom, XAdESNamespaces.XAdES, "xades:QualifyingProperties");
        this.qualifyingPropertiesDom.setAttribute("xmlns:xades", XAdESNamespaces.XAdES);
        this.qualifyingPropertiesDom.setAttribute("Target", "#" + this.deterministicId);
        this.incorporateSignedProperties();
    }

    protected void incorporateReferenceSignedProperties() throws DSSException {
        Element reference = DSSXMLUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        reference.setAttribute("Type", this.xPathQueryHolder.XADES_SIGNED_PROPERTIES);
        reference.setAttribute("URI", "#xades-" + this.deterministicId);
        Element transforms = DSSXMLUtils.addElement(this.documentDom, reference, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        Element transform = DSSXMLUtils.addElement(this.documentDom, transforms, "http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        transform.setAttribute("Algorithm", this.signedPropertiesCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.params.getDigestAlgorithm();
        this.incorporateDigestMethod(reference, digestAlgorithm);
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.signedPropertiesCanonicalizationMethod, this.signedPropertiesDom);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method  --> {}", (Object)this.signedPropertiesCanonicalizationMethod);
            LOG.trace("Canonicalised REF_2      --> {}", (Object)new String(canonicalizedBytes));
        }
        this.incorporateDigestValue(reference, digestAlgorithm, (DSSDocument)new InMemoryDocument(canonicalizedBytes));
    }

    private void incorporateReference(DSSReference dssReference) {
        Element referenceDom = DSSXMLUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        referenceDom.setAttribute("Id", dssReference.getId());
        String uri = dssReference.getUri();
        referenceDom.setAttribute("URI", uri);
        referenceDom.setAttribute("Type", dssReference.getType());
        List<DSSTransform> dssTransforms = dssReference.getTransforms();
        if (dssTransforms != null) {
            Element transformsDom = DSSXMLUtils.addElement(this.documentDom, referenceDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
            for (DSSTransform dssTransform : dssTransforms) {
                Element transformDom = DSSXMLUtils.addElement(this.documentDom, transformsDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
                XAdESSignatureBuilder.createTransform(this.documentDom, dssTransform, transformDom);
            }
        }
        DigestAlgorithm digestAlgorithm = dssReference.getDigestMethodAlgorithm();
        this.incorporateDigestMethod(referenceDom, digestAlgorithm);
        DSSDocument canonicalizedDocument = this.transformReference(dssReference);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reference canonicalization method  -->" + this.signedInfoCanonicalizationMethod);
        }
        this.incorporateDigestValue(referenceDom, digestAlgorithm, canonicalizedDocument);
    }

    static void createTransform(Document document, DSSTransform dssTransform, Element transformDom) {
        transformDom.setAttribute("Algorithm", dssTransform.getAlgorithm());
        String elementName = dssTransform.getElementName();
        String textContent = dssTransform.getTextContent();
        if (StringUtils.isNotBlank((String)elementName)) {
            String namespace = dssTransform.getNamespace();
            DSSXMLUtils.addTextElement(document, transformDom, namespace, elementName, textContent);
        } else if (StringUtils.isNotBlank((String)textContent)) {
            Document transformContentDoc = DSSXMLUtils.buildDOM(textContent);
            Element contextDocumentElement = transformContentDoc.getDocumentElement();
            document.adoptNode(contextDocumentElement);
            transformDom.appendChild(contextDocumentElement);
        }
    }

    protected abstract List<DSSReference> createDefaultReferences();

    protected abstract DSSDocument transformReference(DSSReference var1);

    protected void incorporateSignatureValue() {
        this.signatureValueDom = DSSXMLUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue");
        this.signatureValueDom.setAttribute("Id", "value-" + this.deterministicId);
    }

    protected void incorporateSignedProperties() throws DSSException {
        this.signedPropertiesDom = DSSXMLUtils.addElement(this.documentDom, this.qualifyingPropertiesDom, XAdESNamespaces.XAdES, "xades:SignedProperties");
        this.signedPropertiesDom.setAttribute("Id", "xades-" + this.deterministicId);
        this.incorporateSignedSignatureProperties();
    }

    protected void incorporateSignedSignatureProperties() {
        this.signedSignaturePropertiesDom = DSSXMLUtils.addElement(this.documentDom, this.signedPropertiesDom, XAdESNamespaces.XAdES, "xades:SignedSignatureProperties");
        this.incorporateSigningTime();
        this.incorporateSigningCertificate();
        this.incorporateSignedDataObjectProperties();
        this.incorporatePolicy();
        this.incorporateSignatureProductionPlace();
        this.incorporateSignerRole();
        this.incorporateCommitmentTypeIndications();
    }

    private void incorporatePolicy() {
        Policy signaturePolicy = this.params.bLevel().getSignaturePolicy();
        if (signaturePolicy != null) {
            Element signaturePolicyIdentifierDom = DSSXMLUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignaturePolicyIdentifier");
            String signaturePolicyId = signaturePolicy.getId();
            if (StringUtils.isEmpty((String)signaturePolicyId)) {
                DSSXMLUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, XAdESNamespaces.XAdES, "xades:SignaturePolicyImplied");
            } else {
                String spuri;
                String description;
                Element signaturePolicyIdDom = DSSXMLUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, XAdESNamespaces.XAdES, "xades:SignaturePolicyId");
                Element sigPolicyIdDom = DSSXMLUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.XAdES, "xades:SigPolicyId");
                Element policyIdElement = DSSXMLUtils.addTextElement(this.documentDom, sigPolicyIdDom, XAdESNamespaces.XAdES, "xades:Identifier", signaturePolicyId);
                if (signaturePolicyId.equals("urn:oid:1.3.6.1.4.1.10015.1000.3.2.1")) {
                    policyIdElement.setAttribute("Qualifier", "OIDAsURN");
                }
                if (StringUtils.isNotEmpty((String)(description = signaturePolicy.getDescription()))) {
                    DSSXMLUtils.addTextElement(this.documentDom, sigPolicyIdDom, XAdESNamespaces.XAdES, "xades:Description", description);
                }
                if (signaturePolicy.getDigestAlgorithm() != null && signaturePolicy.getDigestValue() != null) {
                    Element sigPolicyHashDom = DSSXMLUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.XAdES, "xades:SigPolicyHash");
                    DigestAlgorithm digestAlgorithm = signaturePolicy.getDigestAlgorithm();
                    this.incorporateDigestMethod(sigPolicyHashDom, digestAlgorithm);
                    byte[] hashValue = signaturePolicy.getDigestValue();
                    String bas64EncodedHashValue = Base64.encodeBase64String((byte[])hashValue);
                    DSSXMLUtils.addTextElement(this.documentDom, sigPolicyHashDom, "http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue", bas64EncodedHashValue);
                }
                if (StringUtils.isNotEmpty((String)(spuri = signaturePolicy.getSpuri()))) {
                    Element sigPolicyQualifiers = DSSXMLUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.XAdES, "xades:SigPolicyQualifiers");
                    Element sigPolicyQualifier = DSSXMLUtils.addElement(this.documentDom, sigPolicyQualifiers, XAdESNamespaces.XAdES, "xades:SigPolicyQualifier");
                    DSSXMLUtils.addTextElement(this.documentDom, sigPolicyQualifier, XAdESNamespaces.XAdES, "xades:SPURI", spuri);
                }
            }
        }
    }

    private void incorporateSigningTime() {
        Date signingDate = this.params.bLevel().getSigningDate();
        XMLGregorianCalendar xmlGregorianCalendar = DSSXMLUtils.createXMLGregorianCalendar(signingDate);
        String xmlSigningTime = xmlGregorianCalendar.toXMLFormat();
        Element signingTimeDom = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:SigningTime");
        this.signedSignaturePropertiesDom.appendChild(signingTimeDom);
        Text textNode = this.documentDom.createTextNode(xmlSigningTime);
        signingTimeDom.appendChild(textNode);
    }

    private void incorporateSigningCertificate() {
        String signingCertificate = XAdESNamespaces.getXADES_SIGNING_CERTIFICATE();
        if (this.params.isEn319132()) {
            signingCertificate = XAdESNamespaces.getXADES_SIGNING_CERTIFICATE_V2();
        }
        Element signingCertificateDom = DSSXMLUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, signingCertificate);
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        certificates.add(this.params.getSigningCertificate());
        this.incorporateCertificateRef(signingCertificateDom, certificates);
    }

    private void incorporateSignedDataObjectProperties() {
        this.signedDataObjectPropertiesDom = DSSXMLUtils.addElement(this.documentDom, this.signedPropertiesDom, XAdESNamespaces.XAdES, "xades:SignedDataObjectProperties");
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            String dataObjectFormatObjectReference = "#" + reference.getId();
            Element dataObjectFormatDom = DSSXMLUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:DataObjectFormat");
            dataObjectFormatDom.setAttribute("ObjectReference", dataObjectFormatObjectReference);
            Element mimeTypeDom = DSSXMLUtils.addElement(this.documentDom, dataObjectFormatDom, XAdESNamespaces.XAdES, "xades:MimeType");
            MimeType dataObjectFormatMimeType = this.getReferenceMimeType(reference);
            DSSXMLUtils.setTextNode(this.documentDom, mimeTypeDom, dataObjectFormatMimeType.getMimeTypeString());
        }
        this.incorporateContentTimestamps();
    }

    private MimeType getReferenceMimeType(DSSReference reference) {
        MimeType dataObjectFormatMimeType = reference.getContents().getMimeType();
        if (dataObjectFormatMimeType == null) {
            dataObjectFormatMimeType = MimeType.BINARY;
        }
        return dataObjectFormatMimeType;
    }

    private void incorporateContentTimestamps() {
        List contentTimestamps = this.params.getContentTimestamps();
        if (contentTimestamps == null) {
            return;
        }
        Element allDataObjectsTimestampDom = null;
        Element individualDataObjectsTimestampDom = null;
        for (TimestampToken contentTimestamp : contentTimestamps) {
            TimestampType timeStampType = contentTimestamp.getTimeStampType();
            if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                if (allDataObjectsTimestampDom == null) {
                    allDataObjectsTimestampDom = DSSXMLUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:AllDataObjectsTimeStamp");
                }
                this.addTimestamp(allDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            if (!TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) continue;
            if (individualDataObjectsTimestampDom == null) {
                individualDataObjectsTimestampDom = DSSXMLUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:IndividualDataObjectsTimeStamp");
            }
            this.addTimestamp(individualDataObjectsTimestampDom, contentTimestamp);
        }
    }

    private void incorporateSignerRole() {
        List claimedSignerRoles = this.params.bLevel().getClaimedSignerRoles();
        List certifiedSignerRoles = this.params.bLevel().getCertifiedSignerRoles();
        if (claimedSignerRoles != null || certifiedSignerRoles != null) {
            Element signerRoleDom = this.params.isEn319132() ? DSSXMLUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignerRoleV2") : DSSXMLUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignerRole");
            if (CollectionUtils.isNotEmpty((Collection)claimedSignerRoles)) {
                Element claimedRolesDom = DSSXMLUtils.addElement(this.documentDom, signerRoleDom, XAdESNamespaces.XAdES, "xades:ClaimedRoles");
                this.addRoles(claimedSignerRoles, claimedRolesDom, "xades:ClaimedRole");
            }
            if (CollectionUtils.isNotEmpty((Collection)certifiedSignerRoles)) {
                Element certifiedRolesDom = this.params.isEn319132() ? DSSXMLUtils.addElement(this.documentDom, signerRoleDom, XAdESNamespaces.XAdES, "xades:CertifiedRolesV2") : DSSXMLUtils.addElement(this.documentDom, signerRoleDom, XAdESNamespaces.XAdES, "xades:CertifiedRoles");
                this.addRoles(certifiedSignerRoles, certifiedRolesDom, "xades:CertifiedRole");
            }
        }
    }

    private void addRoles(List<String> signerRoles, Element rolesDom, String roleType) {
        for (String signerRole : signerRoles) {
            Element roleDom = DSSXMLUtils.addElement(this.documentDom, rolesDom, XAdESNamespaces.XAdES, roleType);
            DSSXMLUtils.setTextNode(this.documentDom, roleDom, signerRole);
        }
    }

    private void incorporateSignatureProductionPlace() {
        SignerLocation signatureProductionPlace = this.params.bLevel().getSignerLocation();
        if (signatureProductionPlace != null) {
            String country;
            String postalCode;
            String stateOrProvince;
            String streetAddress;
            Element signatureProductionPlaceDom = this.params.isEn319132() ? DSSXMLUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignatureProductionPlaceV2") : DSSXMLUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.XAdES, "xades:SignatureProductionPlace");
            String city = signatureProductionPlace.getLocality();
            if (city != null) {
                DSSXMLUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:City", city);
            }
            if (this.params.isEn319132() && (streetAddress = signatureProductionPlace.getStreet()) != null) {
                DSSXMLUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:StreetAddress", streetAddress);
            }
            if ((stateOrProvince = signatureProductionPlace.getStateOrProvince()) != null) {
                DSSXMLUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:StateOrProvince", stateOrProvince);
            }
            if ((postalCode = signatureProductionPlace.getPostalCode()) != null) {
                DSSXMLUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:PostalCode", postalCode);
            }
            if ((country = signatureProductionPlace.getCountry()) != null) {
                DSSXMLUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.XAdES, "xades:CountryName", country);
            }
        }
    }

    private void incorporateCommitmentTypeIndications() {
        List commitmentTypeIndications = this.params.bLevel().getCommitmentTypeIndications();
        if (commitmentTypeIndications != null) {
            Element commitmentTypeIndicationDom = DSSXMLUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.XAdES, "xades:CommitmentTypeIndication");
            Element commitmentTypeIdDom = DSSXMLUtils.addElement(this.documentDom, commitmentTypeIndicationDom, XAdESNamespaces.XAdES, "xades:CommitmentTypeId");
            for (String commitmentTypeIndication : commitmentTypeIndications) {
                DSSXMLUtils.addTextElement(this.documentDom, commitmentTypeIdDom, XAdESNamespaces.XAdES, "xades:Identifier", commitmentTypeIndication);
            }
            DSSXMLUtils.addElement(this.documentDom, commitmentTypeIndicationDom, XAdESNamespaces.XAdES, "xades:AllSignedDataObjects");
        }
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) throws DSSException {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSSignatureUtils.convertToXmlDSig(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Base64.encodeBase64String((byte[])signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        byte[] documentBytes = DSSXMLUtils.transformDomToByteArray(this.documentDom);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected void addTimestamp(Element timestampElement, TimestampToken token) {
        List includes = token.getTimestampIncludes();
        if (includes != null) {
            for (TimestampInclude include : includes) {
                Element timestampIncludeElement = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:Include");
                String uri = include.getURI();
                if (!uri.startsWith("#")) {
                    uri = "#" + uri;
                }
                timestampIncludeElement.setAttribute("URI", uri);
                timestampIncludeElement.setAttribute("referencedData", "true");
                timestampElement.appendChild(timestampIncludeElement);
            }
        }
        Element canonicalizationMethodElement = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodElement.setAttribute("Algorithm", token.getCanonicalizationMethod());
        timestampElement.appendChild(canonicalizationMethodElement);
        Element encapsulatedTimestampElement = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:EncapsulatedTimeStamp");
        encapsulatedTimestampElement.setTextContent(Base64.encodeBase64String((byte[])token.getEncoded()));
        timestampElement.appendChild(encapsulatedTimestampElement);
    }
}

