/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.MimeType;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;

public class OfflineResolver
extends ResourceResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineResolver.class);
    private final List<DSSDocument> documents;

    public OfflineResolver(List<DSSDocument> documents) {
        this.documents = documents;
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        block10: {
            Attr uriAttr = context.attr;
            if (uriAttr != null) {
                String encodedDocumentUri = uriAttr.getNodeValue();
                String documentUri = this.decodeUrl(encodedDocumentUri);
                if ("".equals(documentUri) || documentUri.startsWith("#")) {
                    return false;
                }
                if (this.isKnown(documentUri) != null) {
                    LOG.debug("I state that I can resolve '" + documentUri.toString() + "' (external document)");
                    return true;
                }
                documentUri = BDocTmSupport.fixEncoding(encodedDocumentUri);
                if (this.isKnown(documentUri = this.decodeUrl(documentUri)) != null) {
                    LOG.debug("I state that I can resolve '" + documentUri.toString() + "' (external document)");
                    return true;
                }
                try {
                    String baseUriString = context.baseUri;
                    if (StringUtils.isNotEmpty((String)baseUriString)) {
                        URI baseUri = new URI(baseUriString);
                        URI uriNew = new URI(baseUri, documentUri);
                        if (uriNew.getScheme().equals("http")) {
                            LOG.debug("I state that I can resolve '" + uriNew.toString() + "'");
                            return true;
                        }
                        LOG.debug("I state that I can't resolve '" + uriNew.toString() + "'");
                    }
                    break block10;
                }
                catch (URI.MalformedURIException ex) {
                    if (this.documents == null || this.documents.size() == 0) {
                        LOG.warn("OfflineResolver: WARNING: ", (Throwable)ex);
                    }
                    break block10;
                }
            }
            if (this.doesContainOnlyOneDocument()) {
                return true;
            }
        }
        return false;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        Attr uriAttr = context.attr;
        String documentUri = null;
        if (uriAttr == null && this.doesContainOnlyOneDocument()) {
            documentUri = "";
        } else if (uriAttr != null) {
            documentUri = uriAttr.getNodeValue();
        }
        String decodedDocumentUri = this.decodeUrl(documentUri);
        DSSDocument document = this.isKnown(decodedDocumentUri);
        if (document == null) {
            decodedDocumentUri = BDocTmSupport.fixEncoding(documentUri);
            decodedDocumentUri = this.decodeUrl(decodedDocumentUri);
            document = this.isKnown(documentUri);
        }
        if (document == null) {
            document = this.getDocument(decodedDocumentUri);
        }
        if (document != null) {
            InputStream inputStream = document.openStream();
            XMLSignatureInput result = new XMLSignatureInput(inputStream);
            result.setSourceURI(decodedDocumentUri);
            MimeType mimeType = document.getMimeType();
            if (mimeType != null) {
                result.setMIMEType(mimeType.getMimeTypeString());
            }
            return result;
        }
        Object[] exArgs = new Object[]{"The uriNodeValue " + decodedDocumentUri + " is not configured for offline work"};
        throw new ResourceResolverException("generic.EmptyMessage", exArgs, decodedDocumentUri, context.baseUri);
    }

    private DSSDocument isKnown(String documentUri) {
        for (DSSDocument dssDocument : this.documents) {
            if (OfflineResolver.isRightDocument(documentUri, dssDocument)) {
                return dssDocument;
            }
            for (DSSDocument nextDssDocument = dssDocument.getNextDocument(); nextDssDocument != null; nextDssDocument = nextDssDocument.getNextDocument()) {
                if (!OfflineResolver.isRightDocument(documentUri, nextDssDocument)) continue;
                return nextDssDocument;
            }
        }
        return null;
    }

    private static boolean isRightDocument(String documentUri, DSSDocument document) {
        boolean case2;
        String documentUri_ = document.getName();
        if (documentUri.equals(documentUri_)) {
            return true;
        }
        int length = documentUri.length();
        int length_ = documentUri_.length();
        boolean case1 = documentUri.startsWith("/") && length - 1 == length_;
        boolean bl = case2 = documentUri.startsWith("./") && length - 2 == length_;
        return documentUri.endsWith(documentUri_) && (case1 || case2);
    }

    private DSSDocument getDocument(String documentUri) {
        DSSDocument document = this.isKnown(documentUri);
        if (document != null) {
            return document;
        }
        if (this.doesContainOnlyOneDocument()) {
            return this.documents.get(0);
        }
        return null;
    }

    private boolean doesContainOnlyOneDocument() {
        return this.documents != null && this.documents.size() == 1;
    }

    private String decodeUrl(String documentUri) {
        try {
            return URLDecoder.decode(documentUri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to decode '" + documentUri + "' : " + e.getMessage(), (Throwable)e);
            return documentUri;
        }
    }

    static {
        Init.init();
    }
}

