/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESOCSPSource.class);
    private final Element signatureElement;
    private final XPathQueryHolder xPathQueryHolder;

    public XAdESOCSPSource(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        this.signatureElement = signatureElement;
        this.xPathQueryHolder = xPathQueryHolder;
    }

    public List<BasicOCSPResp> getContainedOCSPResponses() {
        ArrayList<BasicOCSPResp> list = new ArrayList<BasicOCSPResp>();
        this.addOCSP(list, this.xPathQueryHolder.XPATH_OCSP_VALUES_ENCAPSULATED_OCSP);
        this.addOCSP(list, this.xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_OCSP_VALUE);
        return list;
    }

    private void addOCSP(List<BasicOCSPResp> list, String xPathQuery) {
        NodeList nodeList = DSSXMLUtils.getNodeList(this.signatureElement, xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            try {
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPBase64Encoded((String)certEl.getTextContent());
                list.add(basicOCSPResp);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Cannot retrieve OCSP response from '" + certEl.getTextContent() + "' : " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

